#   include	"utilPsConfig.h"

#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<string.h>
#   include	<ctype.h>

#   include	<locale.h>

#   include	<reg.h>

#   include	"psPostScriptFontList.h"
#   include	"sioStdio.h"
#   include	"sioPfb.h"
#   include	"sioPipe.h"
#   include	"appSystem.h"
#   include	"utilLongestCommonSubstring.h"

#   include	<appDebugon.h>

#   ifdef __VMS
    static const char * const		afmExtension= "AFM";
#   else
    static const char * const		afmExtension= "afm";
#   endif

static const char * PS_LocalAfmDir= "localfonts";

/************************************************************************/
/*									*/
/*  Make a catalog of postscript fonts for the font chooser.		*/
/*									*/
/*  The code assumes that afmDirectory is some kind of a resource, that	*/
/*  does not vary over different calls to the routine.			*/
/*									*/
/*  A:  Consume one file.						*/
/*  B:  Ignore errors in certain hopeless files.			*/
/*									*/
/************************************************************************/

#   define	FILEL	400

/*  A  */
static int psRememberAfmFile(	const char *		filename,
				int			adaptNames,
				PostScriptFontList *	psfl )
    {
    int				rval= 0;
    SimpleInputStream *		sisAfm= (SimpleInputStream *)0;
    int				res;

    AfmFontInfo *		afi= (AfmFontInfo *)0;

    int				len= strlen( filename );
    const int			deferMetrics= 0;

    if  ( len == 0 )
	{ LDEB(len); rval= -1; goto ready;	}

    afi= (AfmFontInfo *)malloc( sizeof(AfmFontInfo) );
    if  ( ! afi )
	{ XDEB(afi); rval= -1; goto ready;	}

    psInitAfmFontInfo( afi );

    sisAfm= sioInStdioOpen( filename );
    if  ( ! sisAfm )
	{ SXDEB(filename,sisAfm); goto ready; } /* no failure ! */

    res= psAfmReadAfm( sisAfm, afi, deferMetrics );
    if  ( res < 0 )
	{ SLDEB(filename,res); goto ready; } /* no failure ! */

    afi->afiAfmFileName= strdup( filename );
    if  ( ! afi->afiAfmFileName )
	{ XDEB(afi->afiAfmFileName); goto ready;	}

    if  ( psGetUnicodesFromGlyphNames( afi ) )
	{ SDEB(afi->afiFullName);	}
    if  ( psResolveFallbackGlyph( afi ) )
	{ SDEB(afi->afiFullName);	}

    /*  Free memory: metrics are reread when the font is really used */
    psRemoveMetricsFromInfo( afi );
    afi->afiMetricsDeferred= 1;
    afi->afiResolveMetrics= psGetDeferredMetrics;

    if  ( ! afi->afiFamilyName )
	{ SXDEB(filename,afi->afiFamilyName); goto ready; }

    if  ( adaptNames )
	{ psMapVisibleNamesToBase35( afi );	}

    if  ( psPostScriptFontListAddInfo( psfl, afi ) )
	{ SDEB(filename); rval= -1; goto ready;	}
    afi= (AfmFontInfo *)0; /* stolen */

  ready:

    if  ( afi )
	{ psFreeAfmFontInfo( afi );	}
    if  ( sisAfm )
	{ sioInClose( sisAfm );		}

    return rval;
    }

static int psGotAfmFile(	const char *	filename,
				void *		through )
    {
    return psRememberAfmFile( filename, 0, (PostScriptFontList *)through );
    }

static int psGotLocalAfmFile(	const char *	filename,
				void *		through )
    {
    return psRememberAfmFile( filename, 0, (PostScriptFontList *)through );
    }

/************************************************************************/
/*									*/
/*  Make a catalog of all the fonts for which an AFM file is found.	*/
/*									*/
/*  1)  Collect the information from all AFM files.			*/
/*	NOTE: Afm files are in the "C" locale.				*/
/*  2)  Count families.							*/
/*	NOTE: Width variants of the same family are treated like	*/
/*	different families here.					*/
/*  3)  Allocate space for the families.				*/
/*  4)  Divide the faces over the families.				*/
/*									*/
/************************************************************************/

int psFontCatalog(	PostScriptFontList *	psfl,
			const char *		afmDirectory )
    {
    int				j;

    char			scratch[FILEL+ 1];
    const int			relativeIsFile= 0;

    if  ( appAbsoluteName( scratch, sizeof(scratch)- 1,
			    PS_LocalAfmDir, relativeIsFile, afmDirectory ) < 0 )
	{ SDEB(PS_LocalAfmDir); return -1;	}

    /*  1  */
    setlocale( LC_NUMERIC, "C" );

    if  ( ! appTestDirectory( scratch ) )
	{
	j= appForAllFiles( scratch, afmExtension, psfl, psGotLocalAfmFile );
	}

    j= appForAllFiles( afmDirectory, afmExtension, psfl, psGotAfmFile );

    setlocale( LC_NUMERIC, "" );

    if  ( j )
	{ SDEB(afmDirectory); return -1;	}

    if  ( psPostScriptFontListInfosToFamilies( psfl ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

/************************************************************************/

int psSaveAfms(		const PostScriptFontList *	psfl,
			const char *			afmDirectory )
    {
    int				rval= 0;
    char			absolute[300+1];
    const int			relativeIsFile= 0;
    int				i;

    SimpleOutputStream *	sosAfm= (SimpleOutputStream *)0;


    if  ( appAbsoluteName( absolute, sizeof(absolute)- 1,
			PS_LocalAfmDir, relativeIsFile, afmDirectory ) < 0 )
	{ SDEB(PS_LocalAfmDir); return -1;	}

    if  ( appTestDirectory( absolute )	&&
	  appMakeDirectory( absolute )	)
	{ SDEB(absolute); rval= -1; goto ready;	}

    for ( i= 0; i < psfl->psflInfoCount; i++ )
	{
	AfmFontInfo *	afi= psfl->psflInfos[i];

	if  ( ! afi || ! afi->afiAfmFileName )
	    { continue;	}

	sosAfm= sioOutStdioOpen( afi->afiAfmFileName );
	if  ( ! sosAfm )
	    { SXDEB(afi->afiAfmFileName,sosAfm); rval= -1; goto ready;	}

	if  ( psWriteAfmFile( sosAfm, afi ) )
	    { SDEB(afi->afiFontName); rval= -1; goto ready;	}

	sioOutClose( sosAfm ); sosAfm= (SimpleOutputStream *)0;
	}

  ready:

    if  ( sosAfm )
	{ sioOutClose( sosAfm );	}

    return rval;
    }

int psGetDeferredMetrics(	AfmFontInfo *		afi )
    {
    int			rval= 0;
    SimpleInputStream *	sisAfm= (SimpleInputStream *)0;
    const int		deferMetrics= 0;

    int			res;
    AfmFontInfo		afiMetrics;

    psInitAfmFontInfo( &afiMetrics );

    if  ( ! afi->afiAfmFileName )
	{ XDEB(afi->afiAfmFileName); rval= -1; goto ready; }

    sisAfm= sioInStdioOpen( afi->afiAfmFileName );
    if  ( ! sisAfm )
	{ SXDEB(afi->afiAfmFileName,sisAfm); rval= -1; goto ready; }

    setlocale( LC_NUMERIC, "C" );

    res= psAfmReadAfm( sisAfm, &afiMetrics, deferMetrics );
    if  ( res < 0 )
	{ SLDEB(afi->afiAfmFileName,res); rval= -1; goto ready; }

    psRemoveMetricsFromInfo( afi );
    afi->afiMetrics= afiMetrics.afiMetrics;
    afi->afiMetricCount= afiMetrics.afiMetricCount;
    afi->afiNameToMetric= afiMetrics.afiNameToMetric;

    afiMetrics.afiMetrics= (AfmCharMetric **)0;
    afiMetrics.afiMetricCount= 0;
    afiMetrics.afiNameToMetric= (void *)0;

    afi->afiMetricsDeferred= 0;

    if  ( psGetUnicodesFromGlyphNames( afi ) )
	{ SDEB(afi->afiFullName);	}
    if  ( psResolveFallbackGlyph( afi ) )
	{ SDEB(afi->afiFullName);	}

  ready:

    setlocale( LC_NUMERIC, "" );

    psCleanAfmFontInfo( &afiMetrics );

    if  ( sisAfm )
	{ sioInClose( sisAfm );	}

    return rval;
    }

