/************************************************************************/
/*									*/
/*  A surface to draw upon.						*/
/*									*/
/************************************************************************/

#   ifndef		GUI_DRAWING_SURFACE_H
#   define		GUI_DRAWING_SURFACE_H

#   include		<utilColor.h>
#   include		<geo2DInteger.h>
#   include		<geoAffineTransform.h>
#   include		<psFontInfo.h>

struct DrawingSurface;
typedef struct DrawingSurface * DrawingSurface;

/************************************************************************/
/*									*/
/*  Routine Declarations.						*/
/*									*/
/************************************************************************/

extern void drawFreeDrawingSurface(	DrawingSurface		ds );

extern void drawSetTransform(	DrawingSurface			ds,
				const AffineTransform2D *	at2 );

extern void drawTransformRectangleBackward(
				DocumentRectangle *		drLogical,
				DrawingSurface			ds,
				const DocumentRectangle *	drPhysical );

extern int drawSetForegroundColor(	DrawingSurface		ds,
					const RGB8Color *	rgb8 );

extern void drawFillRectangle(	DrawingSurface			ds,
				const DocumentRectangle *	drLogical );

extern int drawOpenScreenFont(	DrawingSurface			ds,
				const AfmFontInfo *		afi,
				int				logicalSize );

#   endif	/*	GUI_DRAWING_SURFACE_H	*/
