/************************************************************************/
/*									*/
/*  Description of a TOC field.						*/
/*									*/
/************************************************************************/

# ifndef DOC_TOC_FIELD_H
# define DOC_TOC_FIELD_H

#   include	"docDocumentField.h"
#   include	"docParaProperties.h"

typedef enum TocType
    {
    TOCtypeTOC,
    TOCtypeSEQ,

    TOCtype_COUNT
    } TocType;

# define TOC_FIC_COUNT 20

typedef struct StyleLevel
    {
    int		slLevel;
    char *	slStyleName;
    int		slStyleNameLength;
    } StyleLevel;

typedef struct TocField
    {
			/* a,c,f */
    char *		tfIdentifierName;
			/* b */
    char *		tfMarkName;
			/* p */
    char *		tfSeparatorBytes;
			/* s */
    char *		tfSeqName;
			/* d */
    char *		tfSeqSeparatorBytes;
			/* t */
    char *		tfStylesBytes;

			/* include what */
    unsigned char	tfType;
    unsigned char	tfUseTcEntries;
    unsigned char	tfUseStyles;
    unsigned char	tfUseOutlineLevels;
    unsigned char	tfLevel0;
    unsigned char	tfLevel1;
			/* presentation */
    unsigned char	tfIncludeSeqLabelAndNumber;
    unsigned char	tfHyperlinks;
    unsigned char	tfWebNoNumber;
    unsigned char	tfPreserveTabs;
    unsigned char	tfPreserveNewlines;
    unsigned char	tfNLevel0;
    unsigned char	tfNLevel1;
			/* derived */
    StyleLevel *	tfStyleLevels;
    int			tfStyleLevelCount;
    } TocField;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitTocField(	TocField *			tf );
extern void docCleanTocField(	TocField *			tf );

extern int docCopyTocField(	TocField *			to,
				const TocField *		from );

extern int docFieldGetToc(	TocField *			tf,
				const DocumentField *		df );

extern int docTocFieldSetToc(	DocumentField *			df,
				const TocField *		tf );

extern int docTocFieldSetTocInstructions(
					MemoryBuffer *		mb,
					const TocField *	tf );

#   endif
