/************************************************************************/
/*									*/
/*  Evaluate TOC fields.						*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<utilRanges.h>

#   include	"docTocField.h"

void docInitTocField(	TocField *	tf )
    {
    tf->tfType= TOCtypeTOC;
    tf->tfIdentifierName= (char *)0;
    tf->tfMarkName= (char *)0;
    tf->tfSeparatorBytes= (char *)0;
    tf->tfSeqName= (char *)0;
    tf->tfSeqSeparatorBytes= (char *)0;
    tf->tfStylesBytes= (char *)0;

    tf->tfIncludeSeqLabelAndNumber= 0;
    tf->tfUseTcEntries= 0;
    tf->tfUseStyles= 0;
    tf->tfUseOutlineLevels= 0;
    tf->tfHyperlinks= 0;
    tf->tfWebNoNumber= 0;
    tf->tfPreserveTabs= 0;
    tf->tfPreserveNewlines= 0;

    tf->tfLevel0= 0;
    tf->tfLevel1= PPoutlineDEEPEST;
    tf->tfNLevel0= PPoutlineBODYTEXT;
    tf->tfNLevel1= PPoutlineBODYTEXT;

    tf->tfStyleLevels= (StyleLevel *)0;
    tf->tfStyleLevelCount= 0;
    }

void docCleanTocField(	TocField *	tf )
    {
    int		i;

    if  ( tf->tfIdentifierName )
	{ free( tf->tfIdentifierName );		}
    if  ( tf->tfMarkName )
	{ free( tf->tfMarkName );		}
    if  ( tf->tfSeparatorBytes )
	{ free( tf->tfSeparatorBytes );		}
    if  ( tf->tfSeqName )
	{ free( tf->tfSeqName );		}
    if  ( tf->tfSeqSeparatorBytes )
	{ free( tf->tfSeqSeparatorBytes );	}
    if  ( tf->tfStylesBytes )
	{ free( tf->tfStylesBytes );		}

    for ( i= 0; i < tf->tfStyleLevelCount; i++ )
	{
	if  ( tf->tfStyleLevels[i].slStyleName )
	    { free( tf->tfStyleLevels[i].slStyleName );	}
	}
    if  ( tf->tfStyleLevels )
	{ free( tf->tfStyleLevels );	}

    return;
    }

static int docCopyFieldString(	char **			pTo,
				const char *		from )
    {
    char *	copy;

    copy= (char *)0;
    if  ( from )
	{
	copy= strdup( from );
	if  ( ! copy )
	    { XDEB(copy); return -1;	}
	}
    if  ( *pTo )
	{ free( *pTo );	}
    *pTo= copy;

    return 0;
    }

int docCopyTocField(		TocField *		to,
				const TocField *	from )
    {
    to->tfType= from->tfType;

    if  ( docCopyFieldString( &(to->tfIdentifierName), from->tfIdentifierName ) )
	{ LDEB(1); return -1;	}
    if  ( docCopyFieldString( &(to->tfMarkName), from->tfMarkName ) )
	{ LDEB(1); return -1;	}
    if  ( docCopyFieldString( &(to->tfSeparatorBytes), from->tfSeparatorBytes ) )
	{ LDEB(1); return -1;	}
    if  ( docCopyFieldString( &(to->tfSeqName), from->tfSeqName ) )
	{ LDEB(1); return -1;	}
    if  ( docCopyFieldString( &(to->tfSeqSeparatorBytes), from->tfSeqSeparatorBytes ) )
	{ LDEB(1); return -1;	}
    if  ( docCopyFieldString( &(to->tfStylesBytes), from->tfStylesBytes ) )
	{ LDEB(1); return -1;	}

    to->tfUseTcEntries= from->tfUseTcEntries;
    to->tfUseStyles= from->tfUseStyles;
    to->tfUseOutlineLevels= from->tfUseOutlineLevels;
    to->tfLevel0= from->tfLevel0;
    to->tfLevel1= from->tfLevel1;

    to->tfIncludeSeqLabelAndNumber= from->tfIncludeSeqLabelAndNumber;
    to->tfHyperlinks= from->tfHyperlinks;
    to->tfWebNoNumber= from->tfWebNoNumber;
    to->tfPreserveTabs= from->tfPreserveTabs;
    to->tfPreserveNewlines= from->tfPreserveNewlines;
    to->tfNLevel0= from->tfNLevel0;
    to->tfNLevel1= from->tfNLevel1;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Split TOC field.							*/
/*									*/
/************************************************************************/

static int docTocFieldParseLevels(
			unsigned char *				pLevel0,
			unsigned char *				pLevel1,
			const unsigned char *			bytes,
			const FieldInstructionsComponent *	fic )
    {
    int			rval;
    int			l0, l1;

    unsigned char x= bytes[fic->ficOffset+ fic->ficSize];
    ((unsigned char *)bytes)[fic->ficOffset+ fic->ficSize]= '\0';

    rval= utilParseRange( &l0, &l1, (const char *)bytes+ fic->ficOffset );
    if  ( rval )
	{ SDEB((const char *)bytes+ fic->ficOffset); }
    if  ( l0 < 0		||
	  l1 < 0		||
	  l0 > PPoutlineDEEPEST	||
	  l1 > PPoutlineDEEPEST	||
	  l1 < l0		)
	{ LLDEB(l0,l1); rval= -1;	}

    ((unsigned char *)bytes)[fic->ficOffset+ fic->ficSize]= x;

    if  ( rval == 0 )
	{ *pLevel0= l0; *pLevel1= l1;	}

    return rval;
    }

static int docTocFieldGetFic(	char **					pField,
				const unsigned char *			bytes,
				const FieldInstructionsComponent *	fic )
    {
    char *	copy= malloc( fic->ficSize+ 1 );

    if  ( ! copy )
	{ LXDEB(fic->ficSize,copy); return -1;	}

    memcpy( copy, bytes+ fic->ficOffset, fic->ficSize );
    copy[fic->ficSize]= '\0';

    if  ( *pField )
	{ free( *pField );	}
    *pField= copy;

    return 0;
    }

int docFieldGetToc(	TocField *		tf,
			const DocumentField *	df )
    {
    FieldInstructionsComponent	fic[TOC_FIC_COUNT];
    int				n;
    int				comp;
    unsigned char *		bytes= df->dfInstructions.mbBytes;

    if  ( df->dfKind != DOCfkTOC )
	{ return -1;	}

    docCleanTocField( tf );
    docInitTocField( tf );

    n= docSplitFieldInstructions( &(df->dfInstructions), fic, TOC_FIC_COUNT );
    if  ( n < 2 )
	{ LDEB(n); return -1;	}

    comp= 0;
    if  ( fic[comp].ficSize != 3					||
	  memcmp( bytes+ fic[comp].ficOffset, "TOC", 3 )	)
	{ SDEB((char *)bytes); return -1;	}
    comp++;

    while( comp < n						&&
	  fic[comp].ficSize == 2				)
	{
	if  ( docFieldHasMergeformat( bytes, fic, n, comp ) )
	    { comp++; continue;	}

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\a", 2 )	&&
	      comp < n- 1					)
	    {
	    comp++;
	    tf->tfType= TOCtypeSEQ;
	    tf->tfIncludeSeqLabelAndNumber= 0;

	    if  ( docTocFieldGetFic( &(tf->tfIdentifierName),
							bytes, fic+ comp ) )
		{ LDEB(1); return -1;	}
	    comp++; continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\b", 2 )	&&
	      comp < n- 1					)
	    {
	    comp++;
	    if  ( docTocFieldGetFic( &(tf->tfMarkName), bytes, fic+ comp ) )
		{ LDEB(1); return -1;	}
	    comp++; continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\c", 2 )	&&
	      comp < n- 1					)
	    {
	    comp++;
	    tf->tfType= TOCtypeSEQ;
	    tf->tfIncludeSeqLabelAndNumber= 0;
	    if  ( docTocFieldGetFic( &(tf->tfIdentifierName),
							bytes, fic+ comp ) )
		{ LDEB(1); return -1;	}
	    comp++; continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\f", 2 )	&&
	      comp < n- 1					)
	    {
	    comp++;
	    tf->tfType= TOCtypeTOC;
	    tf->tfUseTcEntries= 1;

	    if  ( comp < n && bytes[fic[comp].ficOffset] != '\\' )
		{
		if  ( docTocFieldGetFic( &(tf->tfIdentifierName),
							bytes, fic+ comp ) )
		    { LDEB(1); return -1;	}
		comp++; continue;
		}

	    continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\h", 2 )	)
	    {
	    tf->tfHyperlinks= 1;
	    comp++; continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\l", 2 )	&&
	      comp < n- 1					)
	    {
	    comp++;

	    tf->tfType= TOCtypeTOC;
	    tf->tfUseTcEntries= 1;
	    if  ( docTocFieldParseLevels( &(tf->tfLevel0), &(tf->tfLevel1),
							bytes, fic+ comp ) )
		{ LDEB(1); return -1;	}

	    comp++; continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\n", 2 )	)
	    {
	    comp++;

	    if  ( comp < n && bytes[fic[comp].ficOffset] != '\\' )
		{
		if  ( docTocFieldParseLevels( &(tf->tfNLevel0),
				    &(tf->tfNLevel1), bytes, fic+ comp ) )
		    { LDEB(1); return -1;	}

		comp++; continue;
		}
	    else{
		tf->tfNLevel0= 0;
		tf->tfNLevel1= PPoutlineDEEPEST;
		}

	    continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\o", 2 )	)
	    {
	    comp++;
	    tf->tfType= TOCtypeTOC;
	    tf->tfUseStyles= 1;

	    if  ( comp < n && bytes[fic[comp].ficOffset] != '\\' )
		{
		if  ( docTocFieldParseLevels( &(tf->tfLevel0), &(tf->tfLevel1),
							bytes, fic+ comp ) )
		    { LDEB(1); return -1;	}

		comp++; continue;
		}
	    else{
		tf->tfLevel0= 0;
		tf->tfLevel1= PPoutlineDEEPEST;
		}

	    continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\p", 2 )	&&
	      comp < n- 1					)
	    {
	    comp++;
	    if  ( docTocFieldGetFic( &(tf->tfSeparatorBytes),
							bytes, fic+ comp ) )
		{ LDEB(1); return -1;	}
	    comp++; continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\s", 2 )	&&
	      comp < n- 1					)
	    {
	    comp++;
	    if  ( docTocFieldGetFic( &(tf->tfSeqName), bytes, fic+ comp ) )
		{ LDEB(1); return -1;	}
	    comp++; continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\d", 2 )	&&
	      comp < n- 1					)
	    {
	    comp++;
	    if  ( docTocFieldGetFic( &(tf->tfSeqSeparatorBytes),
							bytes, fic+ comp ) )
		{ LDEB(1); return -1;	}
	    comp++; continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\t", 2 )	)
	    {
	    tf->tfType= TOCtypeTOC;
	    tf->tfUseStyles= 1;
	    comp++;

	    if  ( comp < n && bytes[fic[comp].ficOffset] != '\\' )
		{
		if  ( docTocFieldGetFic( &(tf->tfStylesBytes),
							bytes, fic+ comp ) )
		    { LDEB(1); return -1;	}
		comp++;
		}

	    continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\u", 2 )	)
	    {
	    tf->tfType= TOCtypeTOC;
	    tf->tfUseOutlineLevels= 1;
	    comp++; continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\w", 2 )	)
	    {
	    tf->tfPreserveTabs= 1;
	    comp++; continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\x", 2 )	)
	    {
	    tf->tfPreserveNewlines= 1;
	    comp++; continue;
	    }

	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\z", 2 )	)
	    {
	    tf->tfWebNoNumber= 1;
	    comp++; continue;
	    }

	break;
	}

    while( comp < n )
	{ LSDEB(comp,(char *)bytes+ fic[comp].ficOffset); comp++; }

    if  ( tf->tfUseStyles )
	{
	if  ( tf->tfStylesBytes )
	    {
	    StyleLevel *	sl;
	    char *		from= (char *)tf->tfStylesBytes;
	    char *		comma= strchr( from, ',' );
	    char *		s;
	    int			ns;

	    ns= 0;
	    s= (char *)tf->tfStylesBytes;
	    while( *s )
		{
		if  ( *s == ',' )
		    { ns++;	}
		s++;
		}
	    ns++;
	    ns /= 2;
	    tf->tfStyleLevels= malloc( ns* sizeof(StyleLevel) );
	    if  ( ! tf->tfStyleLevels )
		{ LXDEB(ns,tf->tfStyleLevels); return -1;	}

	    sl= tf->tfStyleLevels;
	    tf->tfStyleLevelCount= 0;
	    while( comma )
		{
		char *		past= comma+ 1;
		int		level;
		int		len;

		level= strtol( comma+ 1, &past, 10 );
		if  ( past == comma+ 1 )
		    { SDEB((char *)tf->tfStylesBytes); break;	}

		level--;
		if  ( level < 0 || level > PPoutlineDEEPEST )
		    { LDEB(level); break;	}

		len= comma- from;
		sl->slStyleName= malloc( len+ 1 );
		if  ( ! sl->slStyleName )
		    { XDEB(sl->slStyleName); break;	}
		strncpy( sl->slStyleName, from, len )[len]= '\0';
		sl->slLevel= level- 1;
		sl->slStyleNameLength= len;

		tf->tfStyleLevelCount++; sl++;

		from= past+ 1;
		comma= strchr( from, ',' );
		}
	    }
	else{
	    int			level;
	    char		scratch[30];
	    StyleLevel *	sl;
	    int			ns= PPoutlineDEEPEST+ 1;

	    tf->tfStyleLevels= malloc( ns* sizeof(StyleLevel) );
	    if  ( ! tf->tfStyleLevels )
		{ LXDEB(ns,tf->tfStyleLevels); return -1;	}

	    sl= tf->tfStyleLevels;
	    tf->tfStyleLevelCount= 0;
	    for ( level= 0; level < ns; level++ )
		{
		sprintf( scratch, "heading %d", level+ 1 );
		sl->slStyleName= strdup( scratch );
		sl->slLevel= level;
		sl->slStyleNameLength= strlen( sl->slStyleName );

		tf->tfStyleLevelCount++; sl++;
		}
	    }
	}

    return 0;
    }

static int docAddTocProperty(	MemoryBuffer *		mb,
				const char *		flag,
				const char *		value )
    {
    if  ( ! value || strlen( value ) == 0 )
	{ return 0;	}

    if  ( utilAddToMemoryBuffer( mb, (unsigned char *)flag, strlen( flag ) ) )
	{ LDEB(1); return -1;	}

    if  ( utilAddToMemoryBuffer( mb,
				(unsigned char *)value, strlen( value ) ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

static int docAddTocBoolean(	MemoryBuffer *		mb,
				const char *		flag,
				int			value )
    {
    if  ( ! value )
	{ return 0;	}

    if  ( utilAddToMemoryBuffer( mb, (unsigned char *)flag, strlen( flag ) ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Fill the TOC field string.						*/
/*									*/
/*  There are two kinds of TOC:						*/
/*	-  A list of captions.						*/
/*	   =    With the name of the sequence and the number in the	*/
/*		sequence along with the caption text in the entry.	*/
/*	   =    Just repeating the the caption text in the entries.	*/
/*	-  A real table of contents.					*/
/*									*/
/************************************************************************/

static int docTocFieldAddLevels(	MemoryBuffer *		mb,
					int			level0,
					int			level1 )
    {
    char		scratch[50];

    sprintf( scratch, "%d-%d", level0+ 1, level1+ 1 );

    if  ( utilAddToMemoryBuffer( mb,
				(unsigned char *)scratch, strlen( scratch ) ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

int docTocFieldSetTocInstructions(	MemoryBuffer *		mb,
					const TocField *	tf )
    {
    const char *	flag;

    utilCleanMemoryBuffer( mb );
    utilInitMemoryBuffer( mb );

    if  ( utilAddToMemoryBuffer( mb, (unsigned char *)"TOC", 3 ) )
	{ LDEB(4); return -1;	}

    switch( tf->tfType )
	{
	case TOCtypeSEQ:
	    if  ( tf->tfIncludeSeqLabelAndNumber )
		{ flag= " \\a";		}
	    else{ flag= " \\c";		}
	    if  ( utilAddToMemoryBuffer( mb, (unsigned char *)flag, 4 ) )
		{ LDEB(1); return -1;	}
	    if  ( utilAddToMemoryBuffer( mb,
					(unsigned char *)tf->tfIdentifierName,
					strlen( tf->tfIdentifierName ) ) )
		{ LDEB(1); return -1;	}
	    break;

	case TOCtypeTOC:
	    if  ( tf->tfUseStyles )
		{
		if  ( utilAddToMemoryBuffer( mb, (unsigned char *)" \\o ", 4 ) )
		    { LDEB(1); return -1;	}

		if  ( tf->tfLevel0 > 0 || tf->tfLevel1 < PPoutlineDEEPEST )
		    {
		    if  ( docTocFieldAddLevels( mb,
					    tf->tfLevel0, tf->tfLevel1 ) )
			{ LDEB(1); return -1;	}
		    }

		if  ( tf->tfStylesBytes && tf->tfStylesBytes[0] )
		    {
		    if  ( utilAddToMemoryBuffer( mb,
					(unsigned char *)" \\t ", 4 ) )
			{ LDEB(1); return -1;	}

		    if  ( utilAddToMemoryBuffer( mb,
					(unsigned char *)tf->tfStylesBytes,
					strlen( tf->tfStylesBytes ) ) )
			{ LDEB(1); return -1;	}
		    }
		}

	    if  ( tf->tfUseTcEntries )
		{
		if  ( tf->tfIdentifierName && tf->tfIdentifierName[0] )
		    {
		    if  ( utilAddToMemoryBuffer( mb,
					(unsigned char *)" \\f ", 4 ) )
			{ LDEB(1); return -1;	}

		    if  ( utilAddToMemoryBuffer( mb,
					(unsigned char *)tf->tfIdentifierName,
					strlen( tf->tfIdentifierName ) ) )
			{ LDEB(1); return -1;	}
		    }

		if  ( tf->tfLevel0 > 0 || tf->tfLevel1 < PPoutlineDEEPEST )
		    {
		    if  ( utilAddToMemoryBuffer( mb,
					(unsigned char *)" \\l ", 4 ) )
			{ LDEB(1); return -1;	}

		    if  ( docTocFieldAddLevels( mb,
					    tf->tfLevel0, tf->tfLevel1 ) )
			{ LDEB(1); return -1;	}
		    }
		}

	    if  ( tf->tfUseOutlineLevels )
		{
		if  ( utilAddToMemoryBuffer( mb, (unsigned char *)" \\u ", 4 ) )
		    { LDEB(1); return -1;	}
		}

	    break;

	default:
	    LDEB(tf->tfType); return -1;
	}

    /*  b  */
    if  ( docAddTocProperty( mb, " \\b ", tf->tfMarkName ) )
	{ LDEB(1); return -1;	}

    /*  h  */
    if  ( docAddTocBoolean( mb, " \\h", tf->tfHyperlinks ) )
	{ LDEB(1); return -1;	}

    /*  n  */
    if  ( tf->tfNLevel0 < PPoutlineBODYTEXT )
	{
	if  ( utilAddToMemoryBuffer( mb, (unsigned char *)" \\n ", 4 ) )
	    { LDEB(1); return -1;	}

	if  ( tf->tfNLevel0 > 0 || tf->tfNLevel1 < PPoutlineDEEPEST )
	    {
	    if  ( docTocFieldAddLevels( mb, tf->tfNLevel0, tf->tfNLevel1 ) )
		{ LDEB(1); return -1;	}
	    }
	}

    /*  p  */
    if  ( docAddTocProperty( mb, " \\p ", tf->tfSeparatorBytes ) )
	{ LDEB(1); return -1;	}

    /*  s  */
    if  ( docAddTocProperty( mb, " \\s ", tf->tfSeqName ) )
	{ LDEB(1); return -1;	}

    /*  d  */
    if  ( docAddTocProperty( mb, " \\d ", tf->tfSeqSeparatorBytes ) )
	{ LDEB(1); return -1;	}

    /*  w  */
    if  ( docAddTocBoolean( mb, " \\w", tf->tfPreserveTabs ) )
	{ LDEB(1); return -1;	}

    /*  x  */
    if  ( docAddTocBoolean( mb, " \\x", tf->tfPreserveNewlines ) )
	{ LDEB(1); return -1;	}

    /*  z  */
    if  ( docAddTocBoolean( mb, " \\z", tf->tfWebNoNumber ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

int docTocFieldSetToc(	DocumentField *		df,
			const TocField *	tf )
    {
    return docTocFieldSetTocInstructions( &(df->dfInstructions), tf );
    }
