/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docStyleSheet.h"

/************************************************************************/
/*									*/
/*  Style administration.						*/
/*									*/
/************************************************************************/

void docInitDocumentStyle(	DocumentStyle *	ds )
    {
    ds->dsStyleNumber= -1;
    ds->dsBasedOn= -1;
    ds->dsAdditive= 0;
    ds->dsNext= -1;
    ds->dsLink= -1;
    ds->dsLevel= -1;
    ds->dsAutoupd= 0;
    ds->dsHidden= 0;
    ds->dsLocked= 0;
    ds->dsSemiHidden= 0;
    ds->dsPersonal= 0;
    ds->dsBusy= 0;

    docInitSectionProperties( &(ds->dsSectionProperties) );
    docInitRowProperties( &(ds->dsRowProperties) );
    docInitParagraphProperties( &(ds->dsParagraphProperties) );
    utilInitTextAttribute( &(ds->dsTextAttribute) );

    utilPropMaskClear( &(ds->dsSectMask ) );
    utilPropMaskClear( &(ds->dsRowMask ) );
    utilPropMaskClear( &(ds->dsParaMask ) );
    utilPropMaskClear( &(ds->dsTextMask ) );

    ds->dsName= (char *)0;

    return;
    }

void docCleanDocumentStyle(	DocumentStyle *	ds )
    {
    docCleanParagraphProperties( &(ds->dsParagraphProperties) );
    docCleanRowProperties( &(ds->dsRowProperties) );
    docCleanSectionProperties( &(ds->dsSectionProperties) );

    if  ( ds->dsName )
	{ free( ds->dsName );	}

    return;
    }

int docCopyStyle(	DocumentStyle *		to,
			const DocumentStyle *	from )
    {
    DocumentStyle	ds;
    PropertyMask	ppChgMask;

    docInitDocumentStyle( &ds );
    ds= *from;

    docInitParagraphProperties( &(ds.dsParagraphProperties) );
    docInitSectionProperties( &(ds.dsSectionProperties) );
    ds.dsName= (char *)0;

    utilPropMaskClear( &ppChgMask );

    if  ( docUpdParaProperties( &ppChgMask, &(ds.dsParagraphProperties),
		    &(from->dsParaMask), &(from->dsParagraphProperties),
		    (const DocumentAttributeMap *)0 ) )
	{ docCleanDocumentStyle( &ds ); return -1;	}

    if  ( docCopySectionProperties( &(ds.dsSectionProperties),
					&(from->dsSectionProperties ) ) )
	{ docCleanDocumentStyle( &ds ); return -1;	}

    if  ( from->dsName )
	{
	ds.dsName= strdup( from->dsName );
	if  ( ! ds.dsName )
	    { XDEB(ds.dsName); docCleanDocumentStyle( &ds ); return -1;	}
	}

    docCleanDocumentStyle( to );
    *to= ds;

    return 0;
    }

int docCopyStyleSheet(	DocumentStyleSheet *		to,
			const DocumentStyleSheet *	from )
    {
    int			i;

    docCleanStyleSheet( to );
    docInitStyleSheet( to );

    for ( i= from->dssStyleCount- 1; i >= 0; i-- )
	{
	DocumentStyle *	dsTo= docInsertStyle( to, i );
	if  ( ! dsTo )
	    { LPDEB(i,dsTo); return -1;	}

	if  ( docCopyStyle( dsTo, from->dssStyles+ i ) )
	    { LDEB(i); return -1;	}
	}

    return 0;
    }

DocumentStyle * docInsertStyle(	DocumentStyleSheet *	dss,
				int			n )
    {
    DocumentStyle *	ds;

    if  ( n >= dss->dssStyleCount )
	{
	ds= (DocumentStyle *)realloc( dss->dssStyles,
				    ( n + 1 ) * sizeof( DocumentStyle ) );
	}
    else{
	ds= (DocumentStyle *)realloc( dss->dssStyles,
		    ( dss->dssStyleCount + 1 ) * sizeof( DocumentStyle ) );
	}
    if  ( ! ds )
	{ LLDEB(dss->dssStyleCount,ds); return (DocumentStyle *)0; }
    dss->dssStyles= ds;

    if  ( n == -1 )
	{ n= dss->dssStyleCount;	}

    while( dss->dssStyleCount < n )
	{
	docInitDocumentStyle( ds+ dss->dssStyleCount );
	dss->dssStyleCount++;
	}

    ds += n;
    if  ( n >= dss->dssStyleCount )
	{ docInitDocumentStyle( ds );	}

    ds->dsStyleNumber= n;

    if  ( n >= dss->dssStyleCount )
	{ dss->dssStyleCount= n+ 1;	}

    return ds;
    }

void docCleanStyleSheet(	DocumentStyleSheet *	dss )
    {
    DocumentStyle *	ds;
    int			i;

    ds= dss->dssStyles;
    for ( i= 0; i < dss->dssStyleCount; ds++, i++ )
	{ docCleanDocumentStyle( ds ); }

    if  ( dss->dssStyles )
	{ free( dss->dssStyles );	}

    return;
    }

void docInitStyleSheet(	DocumentStyleSheet *	dss )
    {
    dss->dssStyles= (DocumentStyle *)0;
    dss->dssStyleCount= 0;
    }

DocumentStyle * docGetStyleByName(
				const DocumentStyleSheet *	dss,
				const char *			styleName )
    {
    int			i;
    int			nameLen= strlen( styleName );

    for ( i= 0; i < dss->dssStyleCount; i++ )
	{
	DocumentStyle *	ds= dss->dssStyles+ i;

	if  ( docStyleHasName( ds, styleName, nameLen ) )
	    { return ds;	}
	}

    return (DocumentStyle *)0;
    }

int docStyleHasName(		const DocumentStyle *	ds,
				const char *		styleName,
				int			nameLen )
    {
    const char *	styleNames= ds->dsName;

    while( styleNames )
	{
	const char *	comma;
	int		len;

	comma= strchr( styleNames, ',' );
	if  ( comma )
	    { len= (comma++)- styleNames;	}
	else{ len= strlen( styleNames );	}

	if  ( len == nameLen					&&
	      ! strncmp( styleName, styleNames, nameLen )	)
	    { return 1;	}

	styleNames= comma;
	}

    return 0;
    }
