/************************************************************************/
/*									*/
/*  Shape Properties.							*/
/*									*/
/************************************************************************/

#   ifndef	DOC_SHAPE_PROPERTIES_H
#   define	DOC_SHAPE_PROPERTIES_H

#   include	<geo2DInteger.h>

/************************************************************************/
/*									*/
/*  Primitives for shapes.						*/
/*									*/
/************************************************************************/

typedef enum ShapeWrapStyle
    {
    SHPswsTOPBOTTOM= 1,
    SHPswsAROUND,
    SHPswsNONE,
    SHPswsTIGHTLY,
    SHPswsTHROUGH
    } ShapeWrapStyle;

typedef enum ShapeWrapSide
    {
    SHPswsBOTH= 0,
    SHPswsLEFT,
    SHPswsRIGHT,
    SHPswsLARGEST
    } ShapeWrapSide;

typedef struct ShapeProperties
    {
    DocumentRectangle	spRect;
    long		spID;
    int			spZ;

    unsigned char	spXReference;		/*  (enum)	*/
    unsigned char	spYReference;		/*  (enum)	*/
    unsigned char	spWrapStyle;		/*  (enum)	*/
    unsigned char	spWrapSide;		/*  (enum)	*/

    unsigned char	spShapeBelowText;
    unsigned char	spInHeader;
    unsigned char	spLockAnchor;
    } ShapeProperties;

/************************************************************************/
/*									*/
/*  Numbers of shape properies.						*/
/*									*/
/************************************************************************/

typedef enum ShapeProperty
    {
    SHPpropLEFT= 0,
    SHPpropTOP,
    SHPpropBOTTOM,
    SHPpropRIGHT,
    SHPpropLID,
    SHPpropZ,
    SHPpropFHDR,
    SHPpropBX,
    SHPpropBY,
    SHPpropWR,
    SHPpropWRK,
    SHPpropFBLWTXT,
    SHPpropLOCKANCHOR,

    SHPprop_COUNT
    } ShapeProperty;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitShapeProperties(	ShapeProperties *	sp );

#   endif	/*  DOC_SHAPE_PROPERTIES_H	*/
