/************************************************************************/
/*									*/
/*  Change the font of stretches of text.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>

#   include	"docBuf.h"
#   include	"docEdit.h"

/************************************************************************/
/*									*/
/*  Change the TextAttributes E.G. the font of a stretch of text	*/
/*  particules.								*/
/*									*/
/************************************************************************/

int docChangeParticuleAttributes(	PropertyMask *		pTaAllMask,
					BufferDocument *	bd,
					BufferItem *		paraBi,
					int			part,
					int			partUpto,
					const TextAttribute *	taSet,
					const PropertyMask *	taSetMask )
    {
    TextParticule *		tp;
    int				i;

    tp= paraBi->biParaParticules+ part;
    for ( i= part; i < partUpto; tp++, i++ )
	{
	TextAttribute	ta;
	int		attributeNumber= tp->tpTextAttrNr;
	PropertyMask	doneMask;

	utilPropMaskClear( &doneMask );

	utilGetTextAttributeByNumber( &ta, &(bd->bdTextAttributeList),
						tp->tpTextAttrNr );

	utilUpdateTextAttribute( &doneMask, &ta, taSet, taSetMask );

	if  ( ! utilPropMaskIsEmpty( &doneMask )	||
	      attributeNumber < 0		)
	    {
	    if  ( pTaAllMask )
		{ utilPropMaskOr( pTaAllMask, pTaAllMask, &doneMask );	}

	    attributeNumber= utilTextAttributeNumber(
					&(bd->bdTextAttributeList), &ta );
	    if  ( attributeNumber < 0 )
		{ LDEB(attributeNumber); return -1;	}

	    tp->tpTextAttrNr= attributeNumber;
	    }
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Map text attribute numbers from one document to another document.	*/
/*									*/
/************************************************************************/

void docMapTextAttribute(	TextAttribute *		taTo,
				const TextAttribute *	taFrom,
				const DocumentCopyJob *	dcj )
    {
    const DocumentAttributeMap *	dam= &(dcj->dcjAttributeMap);

    *taTo= *taFrom;

    if  ( taFrom->taFontNumber >= 0 && dam->damFontMap )
	{
	taTo->taFontNumber= dam->damFontMap[taFrom->taFontNumber];
	}

    if  ( taFrom->taTextColorNumber > 0 && dam->damColorMap )
	{
	taTo->taTextColorNumber= dam->damColorMap[taFrom->taTextColorNumber];
	}

    taTo->taTextStyleNumber= 0;

    if  ( taFrom->taBorderNumber > 0 && dam->damBorderMap )
	{
	taTo->taBorderNumber= dam->damBorderMap[taFrom->taBorderNumber];
	}

    if  ( taFrom->taShadingNumber > 0 && dam->damShadingMap )
	{
	taTo->taShadingNumber= dam->damShadingMap[taFrom->taShadingNumber];
	}

    return;
    }

int docMapTextAttributeNumber(	DocumentCopyJob *	dcj,
				int			attributeNumberFrom )
    {
    EditOperation *		eo= dcj->dcjEditOperation;
    TextAttribute		taTo;
    TextAttribute		taFrom;

    int				attributeNumberTo;

    if  ( attributeNumberFrom < 0 )
	{ LDEB(attributeNumberFrom); return attributeNumberFrom;	}

    if  ( eo->eoBd == dcj->dcjBdFrom )
	{ return attributeNumberFrom;	}

    if  ( dcj->dcjForceAttributeTo >= 0 )
	{ return dcj->dcjForceAttributeTo;	}

    if  ( attributeNumberFrom == dcj->dcjCurrentTextAttributeNumberFrom )
	{ return dcj->dcjCurrentTextAttributeNumberTo;	}

    utilGetTextAttributeByNumber( &taFrom,
				    &(dcj->dcjBdFrom->bdTextAttributeList),
				    attributeNumberFrom );

    docMapTextAttribute( &taTo, &taFrom, dcj );

    docRememberFontUsed( eo->eoBd, &taTo );
    attributeNumberTo= utilTextAttributeNumber(
				&(eo->eoBd->bdTextAttributeList), &taTo );

    if  ( attributeNumberTo < 0 )
	{ LDEB(attributeNumberTo);	}

    dcj->dcjCurrentTextAttributeNumberFrom= attributeNumberFrom;
    dcj->dcjCurrentTextAttributeNumberTo= attributeNumberTo;

    return attributeNumberTo;
    }
