/************************************************************************/
/*									*/
/*  Manage the scope of selections: In which sub tree if the document	*/
/*  are they rooted?							*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Initialise a SelectionScope.					*/
/*									*/
/************************************************************************/

void docInitSelectionScope(	SelectionScope *	ss )
    {
    ss->ssInExternalItem= DOCinUNKNOWN;
    ss->ssSectNr= -1;
    ss->ssOwnerSectNr= -1;
    ss->ssOwnerNumber= -1;
    }

/************************************************************************/
/*									*/
/*  Decide whether the selection moved to a different scope.		*/
/*									*/
/*  NOTE: Only use the scope fields of the old selection as deletions	*/
/*	or insertions of BufferItems may have invalidated the pointers.	*/
/*									*/
/************************************************************************/

int docSelectionSameScope(	const SelectionScope *	ssFrom,
				const SelectionScope *	ssTo )
    {
    if  ( ssTo->ssInExternalItem != ssFrom->ssInExternalItem )
	{ return 0;	}

    switch( ssTo->ssInExternalItem )
	{
	case DOCinBODY:

	case DOCinFTNSEP:
	case DOCinFTNSEPC:
	case DOCinFTNCN:
	case DOCinAFTNSEP:
	case DOCinAFTNSEPC:
	case DOCinAFTNCN:

	    return 1;

	case DOCinFIRST_HEADER:
	case DOCinLEFT_HEADER:
	case DOCinRIGHT_HEADER:

	case DOCinFIRST_FOOTER:
	case DOCinLEFT_FOOTER:
	case DOCinRIGHT_FOOTER:

	    if  ( ssTo->ssOwnerSectNr != ssFrom->ssOwnerSectNr )
		{ return 0;	}

	    return 1;

	case DOCinFOOTNOTE:
	case DOCinENDNOTE:

	    /*  Implied by ssOwnerNumber test:
	    if  ( ssTo->ssOwnerSectNr != ssFrom->ssOwnerSectNr )
		{ return 0;	}
	    */
	    if  ( ssTo->ssOwnerNumber != ssFrom->ssOwnerNumber )
		{ return 0;	}

	    return 1;

	case DOCinSHPTXT:
	    if  ( ssTo->ssOwnerNumber != ssFrom->ssOwnerNumber )
		{ return 0;	}
	    return 1;

	default:
	    LLDEB(ssTo->ssInExternalItem,ssFrom->ssInExternalItem);
	    return -1;
	}
    }

int docSelectionSameRoot(
			const DocumentSelection *	dsFrom,
			const BufferItem *		biTo )
    {
    const SelectionScope *	ssFrom= &(dsFrom->dsSelectionScope);
    const SelectionScope *	ssTo;

    if  ( biTo->biInExternalItem == DOCinBODY	&&
          ssFrom->ssInExternalItem == DOCinBODY	)
	{ return 1;	}

    biTo= docGetSectItem( (BufferItem *)biTo );
    if  ( ! biTo )
	{ XDEB(biTo); return -1;	}
    ssTo= &(biTo->biSectSelectionScope);

    return docSelectionSameScope( ssFrom, ssTo );
    }

int docSelectionSameInstance(	const BufferItem *		bi,
				int				page,
				int				column )
    {
    bi= docGetSectItem( (BufferItem *)bi );
    if  ( ! bi )
	{ XDEB(bi); return 1;	}

    switch( bi->biInExternalItem )
	{
	case DOCinBODY:
	    return 1;

	case DOCinFTNSEP:
	case DOCinFTNSEPC:
	case DOCinFTNCN:
	case DOCinAFTNSEP:
	case DOCinAFTNSEPC:
	case DOCinAFTNCN:

	    return bi->biTopPosition.lpPage == page && 
		    bi->biTopPosition.lpColumn == column;

	case DOCinFIRST_HEADER:
	case DOCinLEFT_HEADER:
	case DOCinRIGHT_HEADER:

	case DOCinFIRST_FOOTER:
	case DOCinLEFT_FOOTER:
	case DOCinRIGHT_FOOTER:

	    return bi->biTopPosition.lpPage == page;

	case DOCinFOOTNOTE:
	case DOCinENDNOTE:

	    return 1;

	default:
	    LDEB(bi->biInExternalItem);
	    return -1;
	}
    }

/************************************************************************/
/*									*/
/*  Derive the scope of a selection from a buffer item inside.		*/
/*									*/
/************************************************************************/

void docGetSelectionScope(	SelectionScope *	ss,
				const BufferItem *	bi )
    {
    if  ( ! bi )
	{ XDEB(bi);	}

    bi= docGetSectItem( (BufferItem *)bi );
    if  ( ! bi )
	{ XDEB(bi);				}
    else{ (*ss)= bi->biSectSelectionScope;	}

    return;
    }

void docSetSelectionScope(	DocumentSelection *	ds,
				const BufferItem *	bi )
    { docGetSelectionScope( &(ds->dsSelectionScope), bi );	}
