#   ifndef		DOC_SELECT_H
#   define		DOC_SELECT_H

#   include		"docLayoutPosition.h"
#   include		"docSelectionScope.h"

/************************************************************************/
/*									*/
/*  Forward declarations of structs.					*/
/*									*/
/************************************************************************/

struct BufferDocument;
struct BufferItem;
struct DocumentField;

/************************************************************************/
/*									*/
/*  A position in a document.						*/
/*									*/
/*  NOTE Geometry is derived from the position, NOT the other way round.*/
/*									*/
/************************************************************************/

typedef struct DocumentPosition
    {
    struct BufferItem *	dpBi;
    int			dpStroff;
    } DocumentPosition;

typedef struct DocumentSelection
    {
    SelectionScope	dsSelectionScope;

    DocumentPosition	dsHead;					/*  E  */
    DocumentPosition	dsTail;					/*  E  */
    DocumentPosition	dsAnchor;				/*  E  */

    int			dsCol0;
    int			dsCol1;
    int			dsDirection;
    } DocumentSelection;

/*  2  */
typedef struct PositionGeometry
    {
    int			pgLine;
    int			pgAfterBreak;
    int			pgAtLineHead;
    int			pgAtLineEnd;

    int			pgXTwips;
    int			pgXPixels;
    LayoutPosition	pgTopPosition;
    LayoutPosition	pgBasePosition;
    LayoutPosition	pgBottomPosition;

    int			pgParaFrameX0;
    int			pgParaFrameX1;
    int			pgBlockFrameX0;
    int			pgBlockFrameX1;
    } PositionGeometry;

typedef struct SelectionGeometry
    {
    DocumentRectangle	sgRectangle;

    PositionGeometry	sgBegin;				/*  E  */
    PositionGeometry	sgEnd;					/*  E  */
    PositionGeometry	sgAnchor;				/*  E  */
    } SelectionGeometry;

typedef struct TableRectangle
    {
    int		trCol0;
    int		trCol1;
    int		trCol11;

    int		trRow00;
    int		trRow0;
    int		trRow1;
    int		trRow11;

    int		trCellColspan;
    int		trCellRowspan;
    } TableRectangle;

#   define	docSamePosition(b,e) \
		((b)->dpBi == (e)->dpBi && (b)->dpStroff == (e)->dpStroff)

#   define	docPositionsInsideParagraph(b,e) \
		((b)->dpBi == (e)->dpBi)
#   define	docPositionsInsideCell(b,e) \
		((b)->dpBi->biParent == (e)->dpBi->biParent)
#   define	docPositionsInsideRow(b,e) \
		((b)->dpBi->biParent->biParent == (e)->dpBi->biParent->biParent)

#   define	docSelectionInsideParagraph(ds) \
		docPositionsInsideParagraph(&(ds)->dsHead,&(ds)->dsTail)
#   define	docSelectionInsideCell(ds) \
		docPositionsInsideCell(&(ds)->dsHead,&(ds)->dsTail)
#   define	docSelectionInsideRow(ds) \
		docPositionsInsideRow(&(ds)->dsHead,&(ds)->dsTail)

/************************************************************************/
/*									*/
/*  Describe a selection and its relevance for application tools.	*/
/*									*/
/************************************************************************/

typedef struct SelectionDescription
    {
    unsigned int	sdDocumentId;
    int			sdIsSet;
    int			sdDocumentReadonly;
    int			sdIsIBarSelection;
    int			sdIsSingleParagraph;
    int			sdIsSingleCell;
    int			sdIsSingleFrame;
    int			sdBeginInFrame;
    int			sdBeginInTable;
    int			sdEndInTable;
    int			sdBeginInTableHeader;
    int			sdBeginInMultiColumnSection;
    int			sdIsColSlice;
    int			sdIsRowSlice;
    int			sdIsTableSlice;
    int			sdIsTableRectangle;
    int			sdIsObjectSelection;

    int			sdStartPage;
    int			sdEndPage;
    int			sdDocumentPages;

    int			sdStartSection;
    int			sdEndSection;
    int			sdDocumentSections;

    int			sdCanReplace;
    int			sdInExternalItem;
    int			sdInDocumentBody;
    int			sdInHeaderFooter;

    int			sdBeginInField;
    int			sdBeginInHyperlink;
    int			sdBeginInBookmark;

    int			sdIsListBullet;

    int			sdHasLists;
    int			sdFirstListParaNr;
    int			sdListOverride;
    int			sdListLevel;
    int			sdMultiList;
    int			sdMultiLevel;

    TableRectangle	sdTableRectangle;

    TextAttribute	sdTextAttribute;
    PropertyMask	sdTextAttributeMask;
    } SelectionDescription;

/************************************************************************/
/*									*/
/*  Routine Declarations.						*/
/*									*/
/************************************************************************/

extern void docInitDocumentPosition(	DocumentPosition *	dp );
extern void docInitDocumentSelection(	DocumentSelection *	ds );
extern void docInitPositionGeometry(	PositionGeometry *	pg );
extern void docInitSelectionGeometry(	SelectionGeometry *	sg );
extern void docInitSelectionDescription(	SelectionDescription *	sd );

extern void docSetIBarSelection(	DocumentSelection *		ds,
					const DocumentPosition *	dp );

extern int docIsIBarSelection( const DocumentSelection *		ds );
extern int docIsParaSelection( const DocumentSelection *		ds );

extern int docGetObjectSelection(
				const DocumentSelection *	ds,
				const struct BufferDocument *	bd,
				int *				pPart,
				DocumentPosition *		dpObject,
				InsertedObject **		pIo );

extern void docSetRangeSelection(
				DocumentSelection *		ds,
				const DocumentPosition *	dpFrom,
				const DocumentPosition *	dpTo,
				int				direction,
				int				col0,
				int				col1 );

extern int docBeginOfLine(	DocumentPosition *		dp,
				int				wasAtHead );
extern int docEndOfLine(	DocumentPosition *		dp,
				int				wasAtHead );

extern int docGetTableRectangle(	TableRectangle *		tr,
					const DocumentSelection *	ds );

extern int docGetTableSliceSelection(
				int *				pIsRowSlice,
				int *				pIsColSlice,
				TableRectangle *		tr,
				const DocumentSelection *	ds );

extern void docDescribeSelection(
			    SelectionDescription *		sd,
			    const DocumentSelection *		ds,
			    const SelectionGeometry *		sg,
			    struct BufferDocument *		bd,
			    unsigned int			documentId,
			    int					documentRo );

extern int docSelectFrameOfPosition(	DocumentSelection *		ds,
					const DocumentPosition *	dp );

extern void docGetSelectionScope(	SelectionScope *		ss,
					const struct BufferItem *	bi );

extern void docSetSelectionScope(	DocumentSelection *		ds,
					const struct BufferItem *	bi );

extern int docSelectionSameInstance(
				const struct BufferItem *	bi,
				int				page,
				int				column );

extern int docSelectionSameRoot(
				const DocumentSelection *	dsFrom,
				const struct BufferItem *	biTo );

extern void docSetEditPosition(	EditPosition *			ep,
				const struct BufferItem *	paraBi,
				int				stroff );

extern void docSetEditRange(	EditRange *			er,
				const DocumentSelection *	ds );

#   endif	/*	DOC_SELECT_H	*/
