/************************************************************************/
/*									*/
/*  Manipulate iten properties in a document.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	<utilPropMask.h>

#   include	"docPropVal.h"
#   include	"docSectProperties.h"

/************************************************************************/
/*									*/
/*  Change section properties and tell what has been changed.		*/
/*									*/
/************************************************************************/

int docUpdSectProperties(	PropertyMask *			pSpDoneMask,
				SectionProperties *		to,
				const PropertyMask *		setMask,
				const SectionProperties *	from )
    {
    PropertyMask		doneMask;
    PropertyMask		dgMask;

    utilPropMaskClear( &doneMask );

    utilPropMaskClear( &dgMask );
    utilPropMaskFill( &dgMask, DGprop_COUNT );
    utilPropMaskAnd( &dgMask, &dgMask, setMask );

    utilUpdDocumentGeometry( &(to->spDocumentGeometry),
					&(from->spDocumentGeometry),
					&doneMask, &dgMask );

    if  ( PROPmaskISSET( setMask, SPpropSTYLE ) )
	{
	if  ( to->spStyle != from->spStyle )
	    {
	    to->spStyle= from->spStyle;
	    PROPmaskADD( &doneMask, SPpropSTYLE );
	    }
	}

    if  ( PROPmaskISSET( setMask, SPpropTITLEPG ) )
	{
	if  ( to->spHasTitlePage != from->spHasTitlePage )
	    {
	    to->spHasTitlePage= from->spHasTitlePage;
	    PROPmaskADD( &doneMask, SPpropTITLEPG );
	    }
	}

    if  ( PROPmaskISSET( setMask, SPpropBREAK_KIND ) )
	{
	if  ( to->spBreakKind != from->spBreakKind )
	    {
	    to->spBreakKind= from->spBreakKind;
	    PROPmaskADD( &doneMask, SPpropBREAK_KIND );
	    }
	}

    if  ( PROPmaskISSET( setMask, SPpropNUMBER_STYLE ) )
	{
	if  ( to->spPageNumberStyle != from->spPageNumberStyle )
	    {
	    to->spPageNumberStyle= from->spPageNumberStyle;
	    PROPmaskADD( &doneMask, SPpropNUMBER_STYLE );
	    }
	}

    if  ( PROPmaskISSET( setMask, SPpropNUMBER_HYPHEN ) )
	{
	if  ( to->spPageNumberHyphen != from->spPageNumberHyphen )
	    {
	    to->spPageNumberHyphen= from->spPageNumberHyphen;
	    PROPmaskADD( &doneMask, SPpropNUMBER_HYPHEN );
	    }
	}

    if  ( PROPmaskISSET( setMask, SPpropPAGE_RESTART ) )
	{
	if  ( to->spRestartPageNumbers != from->spRestartPageNumbers )
	    {
	    to->spRestartPageNumbers= from->spRestartPageNumbers;
	    PROPmaskADD( &doneMask, SPpropPAGE_RESTART );
	    }
	}

    if  ( PROPmaskISSET( setMask, SPpropSTART_PAGE ) )
	{
	if  ( to->spStartPageNumber != from->spStartPageNumber )
	    {
	    to->spStartPageNumber= from->spStartPageNumber;
	    PROPmaskADD( &doneMask, SPpropSTART_PAGE );
	    }
	}

    if  ( PROPmaskISSET( setMask, SPpropCOLUMN_COUNT ) )
	{
	if  ( to->spColumnCount != from->spColumnCount )
	    {
	    if  ( docSectionPropertiesSetColumnCount( to,
						    from->spColumnCount ) )
		{ LDEB(from->spColumnCount); return -1;	}

	    PROPmaskADD( &doneMask, SPpropCOLUMN_COUNT );
	    }
	}

    if  ( PROPmaskISSET( setMask, SPpropCOLUMN_SPACING ) )
	{
	if  ( to->spColumnSpacingTwips != from->spColumnSpacingTwips )
	    {
	    to->spColumnSpacingTwips= from->spColumnSpacingTwips;
	    PROPmaskADD( &doneMask, SPpropCOLUMN_SPACING );
	    }
	}

    if  ( PROPmaskISSET( setMask, SPpropLINEBETCOL ) )
	{
	if  ( to->spLineBetweenColumns != from->spLineBetweenColumns )
	    {
	    to->spLineBetweenColumns= from->spLineBetweenColumns;
	    PROPmaskADD( &doneMask, SPpropLINEBETCOL );
	    }
	}

    if  ( PROPmaskISSET( setMask, SPpropCOLUMNS ) )
	{
	int		count;

	if  ( to->spColumnCount < from->spColumnCount )
	    { count= to->spColumnCount;		}
	else{ count= from->spColumnCount;		}

	if  ( count > 1 )
	    {
	    const SectionColumn *	scFrom= from->spColumns;
	    SectionColumn *		scTo= to->spColumns;
	    int				col;

	    for ( col= 0; col < count- 1; scTo++, scFrom++, col++ )
		{
		if  ( scTo->scColumnWidthTwips != scFrom->scColumnWidthTwips )
		    {
		    scTo->scColumnWidthTwips= scFrom->scColumnWidthTwips;
		    PROPmaskADD( &doneMask, SPpropCOLUMNS );
		    }
		if  ( scTo->scSpaceToRightTwips != scFrom->scSpaceToRightTwips )
		    {
		    scTo->scSpaceToRightTwips= scFrom->scSpaceToRightTwips;
		    PROPmaskADD( &doneMask, SPpropCOLUMNS );
		    }
		}
	    if  ( scTo->scColumnWidthTwips != scFrom->scColumnWidthTwips )
		{
		scTo->scColumnWidthTwips= scFrom->scColumnWidthTwips;
		PROPmaskADD( &doneMask, SPpropCOLUMNS );
		}
	    }
	}

    docUpdNotesProperties( &doneMask, &(to->spFootnoteProperties),
				setMask, &(from->spFootnoteProperties),
				SPpropFOOTNOTE_STARTNR,
				SPpropFOOTNOTE_POSITION,
				SPpropFOOTNOTE_RESTART,
				SPpropFOOTNOTE_STYLE );

    docUpdNotesProperties( &doneMask, &(to->spEndnoteProperties),
				setMask, &(from->spEndnoteProperties),
				SPpropENDNOTE_STARTNR,
				SPpropENDNOTE_POSITION,
				SPpropENDNOTE_RESTART,
				SPpropENDNOTE_STYLE );


    *pSpDoneMask= doneMask; return 0;
    }

void docSectPropertyDifference( PropertyMask *			pDiffMask,
				const SectionProperties *	sp1,
				const SectionProperties *	sp2,
				const PropertyMask *		cmpMask )
    {
    PropertyMask		diffMask;
    PropertyMask		dgMask;

    DocumentGeometry		dg;

    utilPropMaskClear( &diffMask );

    utilPropMaskClear( &dgMask );
    utilPropMaskFill( &dgMask, DGprop_COUNT );
    utilPropMaskAnd( &dgMask, &dgMask, cmpMask );

    dg= sp1->spDocumentGeometry;
    utilUpdDocumentGeometry( &dg, &(sp2->spDocumentGeometry),
							&diffMask, &dgMask );

    if  ( PROPmaskISSET( cmpMask, SPpropSTYLE ) )
	{
	if  ( sp1->spStyle != sp2->spStyle )
	    { PROPmaskADD( &diffMask, SPpropSTYLE ); }
	}

    if  ( PROPmaskISSET( cmpMask, SPpropTITLEPG ) )
	{
	if  ( sp1->spHasTitlePage != sp2->spHasTitlePage )
	    { PROPmaskADD( &diffMask, SPpropTITLEPG ); }
	}

    if  ( PROPmaskISSET( cmpMask, SPpropBREAK_KIND ) )
	{
	if  ( sp1->spBreakKind != sp2->spBreakKind )
	    { PROPmaskADD( &diffMask, SPpropBREAK_KIND ); }
	}

    if  ( PROPmaskISSET( cmpMask, SPpropNUMBER_STYLE ) )
	{
	if  ( sp1->spPageNumberStyle != sp2->spPageNumberStyle )
	    { PROPmaskADD( &diffMask, SPpropNUMBER_STYLE ); }
	}

    if  ( PROPmaskISSET( cmpMask, SPpropNUMBER_HYPHEN ) )
	{
	if  ( sp1->spPageNumberHyphen != sp2->spPageNumberHyphen )
	    { PROPmaskADD( &diffMask, SPpropNUMBER_HYPHEN ); }
	}

    if  ( PROPmaskISSET( cmpMask, SPpropPAGE_RESTART ) )
	{
	if  ( sp1->spRestartPageNumbers != sp2->spRestartPageNumbers )
	    { PROPmaskADD( &diffMask, SPpropPAGE_RESTART ); }
	}

    if  ( PROPmaskISSET( cmpMask, SPpropSTART_PAGE ) )
	{
	if  ( sp1->spStartPageNumber != sp2->spStartPageNumber )
	    { PROPmaskADD( &diffMask, SPpropSTART_PAGE ); }
	}

    if  ( PROPmaskISSET( cmpMask, SPpropCOLUMN_COUNT ) )
	{
	if  ( sp1->spColumnCount != sp2->spColumnCount )
	    { PROPmaskADD( &diffMask, SPpropCOLUMN_COUNT ); }
	}

    if  ( PROPmaskISSET( cmpMask, SPpropCOLUMN_SPACING ) )
	{
	if  ( sp1->spColumnSpacingTwips != sp2->spColumnSpacingTwips )
	    { PROPmaskADD( &diffMask, SPpropCOLUMN_SPACING ); }
	}

    if  ( PROPmaskISSET( cmpMask, SPpropLINEBETCOL ) )
	{
	if  ( sp1->spLineBetweenColumns != sp2->spLineBetweenColumns )
	    { PROPmaskADD( &diffMask, SPpropLINEBETCOL ); }
	}

    if  ( PROPmaskISSET( cmpMask, SPpropCOLUMNS ) )
	{
	int		count;

	if  ( sp1->spColumnCount < sp2->spColumnCount )
	    { count= sp1->spColumnCount;		}
	else{ count= sp2->spColumnCount;		}

	if  ( count > 1 )
	    {
	    const SectionColumn *	sc1= sp1->spColumns;
	    const SectionColumn *	sc2= sp2->spColumns;
	    int				col;

	    for ( col= 0; col < count- 1; sc1++, sc2++, col++ )
		{
		if  ( sc1->scColumnWidthTwips != sc2->scColumnWidthTwips )
		    { PROPmaskADD( &diffMask, SPpropCOLUMNS );	}
		if  ( sc1->scSpaceToRightTwips != sc2->scSpaceToRightTwips )
		    { PROPmaskADD( &diffMask, SPpropCOLUMNS ); }
		}
	    if  ( sc1->scColumnWidthTwips != sc2->scColumnWidthTwips )
		{ PROPmaskADD( &diffMask, SPpropCOLUMNS ); }
	    }
	}

    docNotesPropertyDifference( &diffMask, &(sp1->spFootnoteProperties),
				cmpMask, &(sp2->spFootnoteProperties),
				SPpropFOOTNOTE_STARTNR,
				SPpropFOOTNOTE_POSITION,
				SPpropFOOTNOTE_RESTART,
				SPpropFOOTNOTE_STYLE );

    docNotesPropertyDifference( &diffMask, &(sp1->spEndnoteProperties),
				cmpMask, &(sp2->spEndnoteProperties),
				SPpropENDNOTE_STARTNR,
				SPpropENDNOTE_POSITION,
				SPpropENDNOTE_RESTART,
				SPpropENDNOTE_STYLE );

    *pDiffMask= diffMask;
    return;
    }

/************************************************************************/
/*									*/
/*  Clean, Initialize section properties.				*/
/*									*/
/************************************************************************/

void docCleanSectionProperties(	SectionProperties *	sp )
    {
    if  ( sp->spColumns )
	{ free( sp->spColumns );	}

    return;
    }

void docInitSectionProperties(	SectionProperties *	sp )
    {
    utilInitDocumentGeometry( &(sp->spDocumentGeometry) );

    sp->spStyle= 0;

    sp->spColumnSpacingTwips= 720;
    sp->spLineBetweenColumns= 0;

    sp->spHasTitlePage= 0;
    sp->spBreakKind= DOCibkPAGE;
    sp->spPageNumberStyle= DOCpgnDEC;
    sp->spPageNumberHyphen= DOCpgnhPGNHNSH;
    sp->spRestartPageNumbers= 0;

    sp->spColumnCount= 1;
    sp->spColumns= (SectionColumn *)0;

    sp->spStartPageNumber= 0;

    sp->spFootnoteProperties.npStartNumber= 1;
    sp->spFootnoteProperties.npPosition= FTN_POS_PAGE_BOTTOM;
    sp->spFootnoteProperties.npRestart= FTN_RST_CONTINUOUS;
    sp->spFootnoteProperties.npNumberStyle= FTNstyleNAR;

    sp->spEndnoteProperties.npStartNumber= 1;
    sp->spEndnoteProperties.npPosition= FTN_POS_DOC_END;
    sp->spEndnoteProperties.npRestart= FTN_RST_CONTINUOUS;
    sp->spEndnoteProperties.npNumberStyle= FTNstyleNRLC;

    return;
    }

/************************************************************************/

int docSectionPropertiesSetColumnCount(	SectionProperties *	sp,
					int			n )
    {
    if  ( n > 1 && sp->spColumnCount < n )
	{
	SectionColumn *	sc= realloc( sp->spColumns, n* sizeof(SectionColumn) );
	if  ( ! sc )
	    { LXDEB(n,sc); return -1;	}

	sp->spColumns= sc;

	if  ( sp->spColumnCount == 1 )
	    {
	    sc->scSpaceToRightTwips= 0;
	    sc->scColumnWidthTwips= 0;
	    }

	sc= sp->spColumns+ sp->spColumnCount;
	while( sp->spColumnCount < n )
	    {
	    sc->scSpaceToRightTwips= 0;
	    sc->scColumnWidthTwips= 0;

	    sc++; sp->spColumnCount++;
	    }
	}

    sp->spColumnCount= n;
    return 0;
    }


/************************************************************************/
/*									*/
/*  Copy SectionProperties.						*/
/*									*/
/*  NOTE that the headers and footers are not copied.			*/
/*									*/
/************************************************************************/

int docCopySectionProperties(	SectionProperties *		to,
				const SectionProperties *	from )
    {
    int		i;

    if  ( docSectionPropertiesSetColumnCount( to, from->spColumnCount ) )
	{ LDEB(from->spColumnCount); return -1;	}

    to->spDocumentGeometry= from->spDocumentGeometry;

    to->spStyle= from->spStyle;

    to->spColumnSpacingTwips= from->spColumnSpacingTwips;
    to->spLineBetweenColumns= from->spLineBetweenColumns;

    to->spHasTitlePage= from->spHasTitlePage;
    to->spBreakKind= from->spBreakKind;
    to->spPageNumberStyle= from->spPageNumberStyle;
    to->spPageNumberHyphen= from->spPageNumberHyphen;
    to->spRestartPageNumbers= from->spRestartPageNumbers;

    to->spStartPageNumber= from->spStartPageNumber;

    if  ( from->spColumnCount > 1 )
	{
	for ( i= 0; i < from->spColumnCount; i++ )
	    { to->spColumns[i]= from->spColumns[i];	}
	}

    to->spFootnoteProperties= from->spFootnoteProperties;
    to->spEndnoteProperties= from->spEndnoteProperties;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Get the equal column width of section properties. If we have	*/
/*  explicit column width, return 0.					*/
/*									*/
/************************************************************************/

int docSectGetEqualColumnWidth(	const SectionProperties *	sp )
    {
    int				col;
    const SectionColumn *	sc;
    const DocumentGeometry *	dg= &(sp->spDocumentGeometry);
    int				pageWide;
    int				colWide;

    pageWide= dg->dgPageWideTwips-
			    dg->dgLeftMarginTwips- dg->dgRightMarginTwips;

    if  ( sp->spColumnCount < 2 )
	{ return pageWide;	}

    colWide= ( pageWide- ( sp->spColumnCount- 1 )*
			    sp->spColumnSpacingTwips )/ sp->spColumnCount;

    sc=  sp->spColumns;
    for ( col= 0; col < sp->spColumnCount; sc++, col++ )
	{
	if  ( sc->scColumnWidthTwips == 0 )
	    { return colWide;	}
	}

    return 0;
    }

int docSectSetEqualColumnWidth(	SectionProperties *	sp )
    {
    int				col;
    SectionColumn *		sc;
    const DocumentGeometry *	dg= &(sp->spDocumentGeometry);
    int				pageWide;
    int				colWide;

    pageWide= dg->dgPageWideTwips-
			    dg->dgLeftMarginTwips- dg->dgRightMarginTwips;

    if  ( sp->spColumnCount < 2 )
	{ return pageWide;	}

    colWide= ( pageWide- ( sp->spColumnCount- 1 )*
			    sp->spColumnSpacingTwips )/ sp->spColumnCount;

    sc=  sp->spColumns;
    for ( col= 0; col < sp->spColumnCount; sc++, col++ )
	{
	sc->scColumnWidthTwips= 0;
	sc->scSpaceToRightTwips= 0;
	}

    return colWide;
    }

void docSectSetExplicitColumnWidth(	SectionProperties *	sp )
    {
    int				col;
    SectionColumn *		sc;
    const DocumentGeometry *	dg= &(sp->spDocumentGeometry);
    int				pageWide;
    int				colWide;

    pageWide= dg->dgPageWideTwips-
			    dg->dgLeftMarginTwips- dg->dgRightMarginTwips;

    if  ( sp->spColumnCount < 2 )
	{ return;	}

    colWide= ( pageWide- ( sp->spColumnCount- 1 )*
			    sp->spColumnSpacingTwips )/ sp->spColumnCount;

    if  ( colWide < 20 )
	{ LDEB(colWide); return;	}

    sc=  sp->spColumns;
    for ( col= 0; col < sp->spColumnCount; sc++, col++ )
	{
	sc->scColumnWidthTwips= colWide;
	sc->scSpaceToRightTwips= sp->spColumnSpacingTwips;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Determine the column margins.					*/
/*									*/
/*  Because of gutters and/or mirrored margins, the page geometry is	*/
/*  not necessarily identical to that in the section properties.	*/
/*									*/
/************************************************************************/

void docSectGetColumnX(		int *				pXLine,
				int *				pX0,
				int *				pX1,
				const SectionProperties *	sp,
				const DocumentGeometry *	dgPage,
				int				column )
    {
    int				x0= dgPage->dgLeftMarginTwips;
    int				col;

    if  ( sp->spColumnCount < 2 )
	{
	*pX0= dgPage->dgLeftMarginTwips;
	*pX1= dgPage->dgPageWideTwips- dgPage->dgRightMarginTwips;
	return;
	}

    for ( col= 0; col < column; col++ )
	{
	if  ( sp->spColumns[col].scColumnWidthTwips == 0 )
	    { break;	}

	x0 += sp->spColumns[col].scColumnWidthTwips;
	x0 += sp->spColumns[col].scSpaceToRightTwips;
	}

    if  ( col < column || sp->spColumns[column].scColumnWidthTwips == 0 )
	{
	int		pageWide;
	int		colWide;

	pageWide= dgPage->dgPageWideTwips-
			dgPage->dgLeftMarginTwips- dgPage->dgRightMarginTwips;

	colWide= ( pageWide- ( sp->spColumnCount- 1 )*
			sp->spColumnSpacingTwips )/ sp->spColumnCount;

	x0= dgPage->dgLeftMarginTwips+
			    column* ( colWide+ sp->spColumnSpacingTwips );

	*pXLine= x0- sp->spColumnSpacingTwips/ 2;
	*pX0= x0;
	*pX1= x0+ colWide;
	}
    else{
	if  ( column == 0 )
	    {
	    *pXLine= x0- sp->spColumnSpacingTwips/ 2;
	    }
	else{
	    *pXLine= x0- sp->spColumns[column-1].scSpaceToRightTwips/ 2;
	    }

	*pX0= x0;
	*pX1= x0+ sp->spColumns[column].scColumnWidthTwips;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Set a section property.						*/
/*									*/
/************************************************************************/

int docSetSectionProperty(	SectionProperties *	sp,
				int			prop,
				int			arg )
    {
    DocumentGeometry *		dg= &(sp->spDocumentGeometry);

    switch( prop )
	{
	case DGpropPAGE_WIDTH:
	    dg->dgPageWideTwips= arg;
	    break;
	case DGpropPAGE_HEIGHT:
	    dg->dgPageHighTwips= arg;
	    break;

	case DGpropLEFT_MARGIN:
	    dg->dgLeftMarginTwips= arg;
	    break;
	case DGpropRIGHT_MARGIN:
	    dg->dgRightMarginTwips= arg;
	    break;
	case DGpropTOP_MARGIN:
	    dg->dgTopMarginTwips= arg;
	    break;
	case DGpropBOTTOM_MARGIN:
	    dg->dgBottomMarginTwips= arg;
	    break;

	case DGpropHEADER_POSITION:
	    if  ( arg != 0 )
		{ dg->dgHeaderPositionTwips= arg; }
	    break;
	case DGpropFOOTER_POSITION:
	    if  ( arg != 0 )
		{ dg->dgFooterPositionTwips= arg; }
	    break;

	case DGpropGUTTER:
	    dg->dgGutterTwips= arg;
	    break;
	case DGpropMARGMIR:
	    dg->dgMirrorMargins= arg != 0;
	    break;

	case SPpropSTYLE:
	    sp->spStyle= arg;
	    break;

	case SPpropTITLEPG:
	    sp->spHasTitlePage= ( arg != 0 );
	    break;

	case SPpropBREAK_KIND:
	    sp->spBreakKind= arg;
	    break;

	case SPpropNUMBER_STYLE:
	    sp->spPageNumberStyle= arg;
	    break;

	case SPpropNUMBER_HYPHEN:
	    sp->spPageNumberHyphen= arg;
	    break;

	case SPpropPAGE_RESTART:
	    sp->spRestartPageNumbers= arg;
	    break;

	case SPpropSTART_PAGE:
	    sp->spStartPageNumber= arg;
	    break;

	case SPpropCOLUMN_COUNT:
	    if  ( docSectionPropertiesSetColumnCount( sp, arg ) )
		{ LDEB(arg); return -1;	}
	    break;

	case SPpropCOLUMN_SPACING:
	    sp->spColumnSpacingTwips= arg;
	    break;
	case SPpropLINEBETCOL:
	    sp->spLineBetweenColumns= ( arg != 0 );
	    break;

	/***/
	case SPpropFOOTNOTE_STARTNR:
	    sp->spFootnoteProperties.npStartNumber= arg;
	    break;
	case SPpropENDNOTE_STARTNR:
	    sp->spEndnoteProperties.npStartNumber= arg;
	    break;

	case SPpropFOOTNOTE_POSITION:
	    sp->spFootnoteProperties.npPosition= arg;
	    break;
	case SPpropENDNOTE_POSITION:
	    sp->spEndnoteProperties.npPosition= arg;
	    break;

	case SPpropFOOTNOTE_RESTART:
	    sp->spFootnoteProperties.npRestart= arg;
	    break;

	case SPpropENDNOTE_RESTART:
	    sp->spEndnoteProperties.npRestart= arg;
	    break;

	case SPpropFOOTNOTE_STYLE:
	    sp->spFootnoteProperties.npNumberStyle= arg;
	    break;

	case SPpropENDNOTE_STYLE:
	    sp->spEndnoteProperties.npNumberStyle= arg;
	    break;

	default:
	    LLDEB(prop,arg); return -1;
	}

    return 0;
    }
