/************************************************************************/
/*									*/
/*  Text Editor Section specifics.					*/
/*									*/
/************************************************************************/

#   ifndef	DOC_SECT_ITEM_H
#   define	DOC_SECT_ITEM_H

#   include	"docSectProperties.h"
#   include	"docSelect.h"
#   include	"docExternalItem.h"

/************************************************************************/
/*									*/
/*  Type dependent part of a BufferItem of 'Section' level.		*/
/*									*/
/*  Section level BufferItems are the sections of the document and the	*/
/*  'External Items' that are not part of the regular tree of items	*/
/*  that forms the document. Examples of 'External Items' are the page	*/
/*  headers and footers and the footnotes and endnotes in the document.	*/
/*									*/
/*  The root of external items are recognised by the fact that		*/
/*  bi->biInExternalItem != DOCinBODY. In practice there are no parents	*/
/*  to the section level items in external items. This is accidental	*/
/*  and should not be used as a recognition criterion.			*/
/*									*/
/*  1)  Formatting properties of the section.				*/
/*  2)  Page Headers.							*/
/*  3)  Page Footers.							*/
/*  5)  Number of the section in the document tree that an external	*/
/*	item belongs to.						*/
/*									*/
/************************************************************************/

typedef struct SectItem
    {
				/*  1  */
    SectionProperties		bsProperties;

				/*  2  */
    /* DocumentTree		bsHeader; Word 11+ uses Right */
    DocumentTree		bsFirstPageHeader;
    DocumentTree		bsLeftPageHeader;
    DocumentTree		bsRightPageHeader;

				/*  3  */
    /* DocumentTree		bsFooter; Word 11+ uses Right */
    DocumentTree		bsFirstPageFooter;
    DocumentTree		bsLeftPageFooter;
    DocumentTree		bsRightPageFooter;

				/*  5  */
    SelectionScope		bsSelectionScope;

				/****************************************/
				/*					*/
				/*  Not used in the body of a document:	*/
				/*					*/
				/*  A)  Normally not set. Is set by the	*/
				/*	formatter to pass information	*/
				/*	to calculate page numbers.	*/
				/*  B)  Normally not set. In headers	*/
				/*	and footers it is the number of	*/
				/*	the page it is formatted for.	*/
				/*	[ Either during the formatting	*/
				/*	process or after formatting has	*/
				/*	been finished.]			*/
				/*					*/
				/****************************************/
    const struct BufferItem *	bsUseForSectBi;			/*  A	*/
    int				bsUseForPage;			/*  B	*/
    int				bsUseForColumn;			/*  B	*/

				/*  A  */
#   define			biSectExternalUseForSectBi \
					    BIU.biuSect.bsUseForSectBi
				/*  B	*/
#   define			biSectExternalUseForPage \
					    BIU.biuSect.bsUseForPage
#   define			biSectExternalUseForColumn \
					    BIU.biuSect.bsUseForColumn
    } SectItem;

/************************************************************************/
/*									*/
/*  Shortcut defines through the BufferItem union.			*/
/*									*/
/************************************************************************/

#   define biSectFirstPageHeader	BIU.biuSect.bsFirstPageHeader
#   define biSectLeftPageHeader		BIU.biuSect.bsLeftPageHeader
#   define biSectRightPageHeader	BIU.biuSect.bsRightPageHeader

#   define biSectFirstPageFooter	BIU.biuSect.bsFirstPageFooter
#   define biSectLeftPageFooter		BIU.biuSect.bsLeftPageFooter
#   define biSectRightPageFooter	BIU.biuSect.bsRightPageFooter

#   define biSectSelectionScope		BIU.biuSect.bsSelectionScope

#   define biSectProperties		BIU.biuSect.bsProperties

#   define biSectDocumentGeometry	biSectProperties.spDocumentGeometry
#   define biSectPageWideTwips		biSectProperties.spPageWideTwips
#   define biSectPageHighTwips		biSectProperties.spPageHighTwips
#   define biSectLeftMarginTwips	biSectProperties.spLeftMarginTwips
#   define biSectTopMarginTwips		biSectProperties.spTopMarginTwips
#   define biSectRightMarginTwips	biSectProperties.spRightMarginTwips
#   define biSectBottomMarginTwips	biSectProperties.spBottomMarginTwips
#   define biSectHeaderYTwips		biSectProperties.spHeaderYTwips
#   define biSectFooterYTwips		biSectProperties.spFooterYTwips

#   define biSectColumnCount		biSectProperties.spColumnCount

#   define biSectHasTitlePage		biSectProperties.spHasTitlePage
#   define biSectBreakKind		biSectProperties.spBreakKind
#   define biSectPageNumberStyle	biSectProperties.spPageNumberStyle
#   define biSectPageNumberHyphen	biSectProperties.spPageNumberHyphen
#   define biSectRestartPageNumbers	biSectProperties.spRestartPageNumbers
#   define biSectStartPageNumber	biSectProperties.spStartPageNumber

#   define biSectParagraphNumbers	biSectProperties.spParagraphNumbers
#   define biSectParagraphNumberCount	biSectProperties.spParagraphNumberCount

#   define DOC_SECTitemBELOW_PREVIOUS(bi) \
		    DOC_SECTpropsBELOW_PREVIOUS( &((bi)->biSectProperties) )

#   endif
