/************************************************************************/
/*									*/
/*  Save a BufferDocument into an RTF file.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	<appSystem.h>
#   include	"docRtf.h"

/************************************************************************/

void docRtfInitTextConverters( RtfTextConverter * rtc )
    {
    utilInitTextConverter( &(rtc->rtcRtfConverter) );
    utilInitTextConverter( &(rtc->rtcTextConverter) );
    }

void docRtfCleanTextConverters( RtfTextConverter * rtc )
    {
    utilCleanTextConverter( &(rtc->rtcRtfConverter) );
    utilCleanTextConverter( &(rtc->rtcTextConverter) );
    }

void docRtfInitWritingContext(	RtfWritingContext *	rwc )
    {
    rwc->rwcBd= (BufferDocument *)0;

    utilInitTextAttribute( &(rwc->rwcTextAttribute) );
    rwc->rwcTextCharset= FONTcharsetANSI;
    docInitParagraphProperties( &(rwc->rwcParagraphProperties) );
    docInitRowProperties( &(rwc->rwcRowProperties) );

    docInitParagraphProperties( &(rwc->rwcOutsideTableParagraphProperties) );

    utilInitPagedList( &(rwc->rwcEncodedFontList) );
    utilStartPagedList( &(rwc->rwcEncodedFontList),
				sizeof(EncodedFont),
				(InitPagedListItem)docRtfInitEncodedFont,
				(CleanPagedListItem)0 );

    rwc->rwcPushedAttribute= (PushedAttribute *)0;

    rwc->rwcInFldrslt= 0;
    rwc->rwcTableNesting= 0;
    rwc->rwcTableNestingWritten= -1;

    rwc->rwcSaveFlags= 0;

    rwc->rwcCol= 0;
    rwc->rwcSosOut= (SimpleOutputStream *)0;

    docRtfInitTextConverters( &(rwc->rwcTextConverters) );
    docRtfWriteSetRtfEncodingName( rwc, "WINDOWS-1252" );
    }

void docRtfCleanWritingContext(	RtfWritingContext *	rwc )
    {
    docCleanParagraphProperties( &rwc->rwcParagraphProperties );
    docCleanRowProperties( &rwc->rwcRowProperties );

    docCleanParagraphProperties( &rwc->rwcOutsideTableParagraphProperties );

    utilCleanPagedList( &(rwc->rwcEncodedFontList) );

    docRtfCleanTextConverters( &(rwc->rwcTextConverters) );
    }

/************************************************************************/
/*									*/
/*  Reserve a number of columns in the output file.			*/
/*									*/
/************************************************************************/

void docRtfReserveColumns(	RtfWritingContext *	rwc,
				int			cols )
    {
    if  ( rwc->rwcCol > 0 && rwc->rwcCol+ cols > 72 )
	{ docRtfWriteNextLine( rwc );	}

    return;
    }

/************************************************************************/
/*									*/
/*  Save a tag with an argument.					*/
/*									*/
/************************************************************************/

void docRtfWriteNextLine(	RtfWritingContext *	rwc )
    {
    if  ( rwc->rwcCol > 0 )
	{
	sioOutPutString( "\r\n", rwc->rwcSosOut );

	rwc->rwcCol= 0;
	rwc->rwcAfter= RTFafterTEXT;
	}

    return;
    }

void docRtfWriteTag(	RtfWritingContext *	rwc,
			const char *		tag )
    {
    int		len= strlen( tag );

    rwc->rwcCol += len;

    if  ( rwc->rwcCol > 72 )
	{
	docRtfWriteNextLine( rwc );
	rwc->rwcCol= len;
	}

    sioOutPutString( tag, rwc->rwcSosOut );
    rwc->rwcAfter= RTFafterTAG;

    return;
    }

void docRtfWriteDestinationBegin(	RtfWritingContext *	rwc,
					const char *		tag )
    {
    int		len= strlen( tag );

    rwc->rwcCol += 1+ len;

    if  ( rwc->rwcCol > 72 )
	{
	docRtfWriteNextLine( rwc );
	rwc->rwcCol= 1+ len;
	}

    sioOutPutByte( '{', rwc->rwcSosOut );
    if  ( tag && tag[0] )
	{
	sioOutPutString( tag, rwc->rwcSosOut );
	rwc->rwcAfter= RTFafterTAG;
	}
    else{
	rwc->rwcAfter= RTFafterTEXT;
	}

    return;
    }

void docRtfWriteArgDestinationBegin(	RtfWritingContext *	rwc,
					const char *		tag,
					int			arg )
    {
    char	scratch[20];
    int		len;

    sprintf( scratch, "%d", arg );

    len= strlen( tag )+ strlen( scratch );

    rwc->rwcCol += 1+ len;

    if  ( rwc->rwcCol > 72 )
	{
	docRtfWriteNextLine( rwc );
	rwc->rwcCol= 1+ len;
	}

    sioOutPutByte( '{', rwc->rwcSosOut );
    sioOutPutString( tag, rwc->rwcSosOut );
    sioOutPutString( scratch, rwc->rwcSosOut );
    rwc->rwcAfter= RTFafterARG;

    return;
    }

void docRtfWriteDestinationEnd(		RtfWritingContext *	rwc )
    {
    sioOutPutByte( '}', rwc->rwcSosOut ); rwc->rwcCol += 1;
    rwc->rwcAfter= RTFafterTEXT;
    }

void docRtfWriteArgTag(	RtfWritingContext *	rwc,
			const char *		tag,
			int			arg )
    {
    char	scratch[20];
    int		len;

    sprintf( scratch, "%d", arg );

    len= strlen( tag )+ strlen( scratch );

    rwc->rwcCol += len;

    if  ( rwc->rwcCol > 72 )
	{
	docRtfWriteNextLine( rwc );
	rwc->rwcCol= len;
	}

    sioOutPutString( tag, rwc->rwcSosOut );
    sioOutPutString( scratch, rwc->rwcSosOut );
    rwc->rwcAfter= RTFafterARG;

    return;
    }

void docRtfWriteSemicolon(	RtfWritingContext *	rwc )
    {
    sioOutPutString( ";", rwc->rwcSosOut );
    rwc->rwcCol += 1;

    rwc->rwcAfter= RTFafterTEXT;
    }

void docRtfWriteDocEncodedStringDestination(
					RtfWritingContext *	rwc,
					const char *		tag,
					const char *		s,
					int			n,
					int			addSemicolon )
    {
    docRtfWriteDestinationBegin( rwc, tag );

    if  ( n > 0 )
	{ docRtfWriteDocEncodedString( rwc, s, n );	}

    if  ( addSemicolon )
	{ docRtfWriteSemicolon( rwc );	}

    docRtfWriteDestinationEnd( rwc );

    return;
    }

void docRtfWriteRawBytesDestination(	RtfWritingContext *	rwc,
					const char *		tag,
					const char *		s,
					int			n )
    {
    docRtfWriteDestinationBegin( rwc, tag );

    if  ( n > 0 )
	{ docRtfWriteRawBytes( rwc, s, n );	}

    docRtfWriteDestinationEnd( rwc );

    return;
    }

/************************************************************************/
/*									*/
/*  Write the tags that describe the geometry of a picture object.	*/
/*									*/
/************************************************************************/

int docRtfSavePictureTags(		RtfWritingContext *		rwc,
					const PictureProperties *	pip )
    {
    int		xExt= pip->pip_xWinExt;
    int		yExt= pip->pip_yWinExt;

    if  ( xExt == 0 )
	{ xExt= (int)( 100000.0* pip->pipTwipsWide )/ ( 20* POINTS_PER_M ); }
    if  ( yExt == 0 )
	{ yExt= (int)( 100000.0* pip->pipTwipsHigh )/ ( 20* POINTS_PER_M ); }

    docRtfWriteArgTag( rwc, "\\picw", xExt );
    docRtfWriteArgTag( rwc, "\\pich", yExt );

    if  ( pip->pipScaleXSet != 100 )
	{ docRtfWriteArgTag( rwc, "\\picscalex", pip->pipScaleXSet ); }
    if  ( pip->pipScaleYSet != 100 )
	{ docRtfWriteArgTag( rwc, "\\picscaley", pip->pipScaleYSet ); }

    docRtfWriteArgTag( rwc, "\\picwgoal", pip->pipTwipsWide );
    docRtfWriteArgTag( rwc, "\\pichgoal", pip->pipTwipsHigh );

    if  ( pip->pipTopCropTwips != 0 )
	{ docRtfWriteArgTag( rwc, "\\piccropt", pip->pipTopCropTwips ); }
    if  ( pip->pipBottomCropTwips != 0 )
	{ docRtfWriteArgTag( rwc, "\\piccropb", pip->pipBottomCropTwips ); }
    if  ( pip->pipLeftCropTwips != 0 )
	{ docRtfWriteArgTag( rwc, "\\piccropl", pip->pipLeftCropTwips ); }
    if  ( pip->pipRightCropTwips != 0 )
	{ docRtfWriteArgTag( rwc, "\\piccropr", pip->pipRightCropTwips ); }

    /*  Not Necessary..
    if  ( pip->pipBliptag == 0 )
	{ pip->pipBliptag= appGetTimestamp(); 	}
    */

    if  ( pip->pipBliptag != 0 )
	{ docRtfWriteArgTag( rwc, "\\bliptag", pip->pipBliptag ); }

    if  ( pip->pipBmUnitsPerInch > 0 )
	{ docRtfWriteArgTag( rwc, "\\blipupi", pip->pipBmUnitsPerInch ); }

    return 0;
    }

/************************************************************************/
/*									*/
/*  Write object data.							*/
/*									*/
/************************************************************************/

int docRtfWriteMemoryBuffer(	RtfWritingContext *		rwc,
				const MemoryBuffer *		mb )
    {
    const unsigned char *	s;
    int				i;

    if  ( rwc->rwcCol+ mb->mbSize > 78 )
	{ docRtfWriteNextLine( rwc ); }

    if  ( rwc->rwcAfter != RTFafterTEXT )
	{
	sioOutPutByte( ' ', rwc->rwcSosOut ); rwc->rwcCol += 1;
	rwc->rwcAfter= RTFafterTEXT;
	}

    s= mb->mbBytes;
    for ( i= 0; i < mb->mbSize; s++, i++ )
	{
	if  ( rwc->rwcCol >= 78 )
	    { docRtfWriteNextLine( rwc ); }

	sioOutPutByte( *s, rwc->rwcSosOut ); rwc->rwcCol++;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Write a color table.						*/
/*									*/
/************************************************************************/

void docRtfWriteColorTable(	RtfWritingContext *		rwc,
				const DocumentProperties *	dp )
    {
    int				i;
    const RGB8Color *		rgb8= dp->dpColors;

    docRtfWriteDestinationBegin( rwc, "\\colortbl" );
    docRtfWriteNextLine( rwc );

    for ( i= 0; i < dp->dpColorCount; rgb8++, i++ )
	{
	if  ( i != dp->dpDefaultColor )
	    {
	    docRtfWriteArgTag( rwc, "\\red", rgb8->rgb8Red );
	    docRtfWriteArgTag( rwc, "\\green", rgb8->rgb8Green );
	    docRtfWriteArgTag( rwc, "\\blue", rgb8->rgb8Blue );
	    }
	sioOutPutByte( ';', rwc->rwcSosOut ); rwc->rwcCol += 1;
	docRtfWriteNextLine( rwc );
	}

    docRtfWriteDestinationEnd( rwc );
    docRtfWriteNextLine( rwc );

    return;
    }

/************************************************************************/
/*									*/
/*  Write a revision table.						*/
/*									*/
/************************************************************************/

void docRtfWriteRevisorTable(	RtfWritingContext *		rwc,
				const DocumentProperties *	dp )
    {
    int				i;
    const int			addSemicolon= 0;

    docRtfWriteDestinationBegin( rwc, "\\*\\revtbl" );
    docRtfWriteNextLine( rwc );

    for ( i= 0; i < dp->dpAuthorCount; i++ )
	{
	docRtfWriteDocEncodedStringDestination( rwc, "",
				dp->dpAuthors[i], strlen( dp->dpAuthors[i] ),
				addSemicolon );

	docRtfWriteNextLine( rwc );
	}

    docRtfWriteDestinationEnd( rwc );
    docRtfWriteNextLine( rwc );

    return;
    }

/************************************************************************/
/*									*/
/*  Write a word 2000 style table or cell formatting property.		*/
/*									*/
/************************************************************************/

void docRtfSaveAutoSpace(		RtfWritingContext *	rwc,
					const char *		unitTag,
					int			unit,
					const char *		numberTag,
					int			number )
    {
    if  ( number != 0 || unit != TRautoNONE )
	{ docRtfWriteArgTag( rwc, unitTag, unit );	}

    if  ( number != 0 )
	{ docRtfWriteArgTag( rwc, numberTag, number );	}

    return;
    }

