/************************************************************************/
/*									*/
/*  Mail an RTF document.						*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	<sioGeneral.h>
#   include	<sioBase64.h>
#   include	"docRtfReadWrite.h"

int docWriteRtfMail(		SimpleOutputStream *		sos,
				const char *			mimeBoundary,
				BufferDocument *		bd )
    {
    SimpleOutputStream *	sosBody;
    int				rval= 0;

    const DocumentProperties *	dp= &(bd->bdProperties);

    const char *		file= (const char *)dp->dpFilename;

    if  ( file )
	{
	const char *		relative;

	relative= strrchr( file, '/' );
	if  ( relative )
	    { file= relative+ 1;	}
	}

    if  ( ! file || ! file[0] )
	{ file= "file.rtf";	}

    sosBody= sos;

    if  ( mimeBoundary )
	{
	sioOutPutByte( '-', sos ); sioOutPutByte( '-', sos );
	sioOutPutString( mimeBoundary, sos );
	sioOutPutByte( '\r', sos ); sioOutPutByte( '\n', sos );
	sioOutPutString( "Content-Type: text/plain", sos );
	sioOutPutByte( '\r', sos ); sioOutPutByte( '\n', sos );
	sioOutPutString( "Content-Transfer-Encoding: 8bit", sos );
	sioOutPutByte( '\r', sos ); sioOutPutByte( '\n', sos );

	sioOutPutByte( '\r', sos ); sioOutPutByte( '\n', sos );

	if  ( dp->dpTitle && strcmp( mimeBoundary, (char *)dp->dpTitle ) )
	    {
	    sioOutPutString( (char *)dp->dpTitle, sos );
	    sioOutPutByte( '\r', sos ); sioOutPutByte( '\n', sos );
	    }
	else{
	    DocumentPosition	dpFirst;
	    DocumentSelection	ds;

	    if  ( docFirstDocumentPosition( &dpFirst, bd ) )
		{ sioOutPutString( "application/rtf\r\n", sos );	}
	    else{
		const int		fold= 1;
		const int		closed= 1;
		const int		direction= 1;

		BufferItem *		bi= dpFirst.dpBi;

		docSetParaSelection( &ds, bi, direction,
						0, docParaStrlen( bi ) );

		return docPlainSaveDocument( sos, bd, &ds, fold, closed );
		}
	    }

	sioOutPutByte( '-', sos ); sioOutPutByte( '-', sos );
	sioOutPutString( mimeBoundary, sos );
	sioOutPutByte( '\r', sos ); sioOutPutByte( '\n', sos );

	sioOutPutString( "Content-Type: ", sos );
	if  ( file && file[0] )
	    {
	    sioOutPutString( "application/rtf; name=\"", sos );
	    sioOutPutString( file, sos );
	    sioOutPutString( "\"", sos );
	    }
	else{
	    sioOutPutString( "application/rtf", sos );
	    }
	sioOutPutByte( '\r', sos ); sioOutPutByte( '\n', sos );

	sioOutPutString( "Content-Transfer-Encoding: ", sos );
	sioOutPutString( "base64", sos );
	sioOutPutByte( '\r', sos ); sioOutPutByte( '\n', sos );

	sioOutPutByte( '\r', sos ); sioOutPutByte( '\n', sos );

	sosBody= sioOutBase64Open( sos );
	if  ( ! sosBody )
	    { XDEB(sosBody); return -1;	}
	}

    rval= docRtfSaveDocument( sosBody, bd, (const DocumentSelection *)0, 0 );

    if  ( mimeBoundary )
	{
	sioOutClose( sosBody );

	sioOutPutByte( '-', sos ); sioOutPutByte( '-', sos );
	sioOutPutString( mimeBoundary, sos );
	sioOutPutByte( '-', sos ); sioOutPutByte( '-', sos );
	sioOutPutByte( '\r', sos ); sioOutPutByte( '\n', sos );
	}

    return rval;
    }

