/************************************************************************/
/*									*/
/*  Exchange text properties with an RTF file.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"

/************************************************************************/

static const char * DOC_rtfTextShadingTags[]=
    {
    (const char *)0,	/*  solid	*/
    "\\chbghoriz",
    "\\chbgvert",
    "\\chbgfdiag",
    "\\chbgbdiag",
    "\\chbgcross",
    "\\chbgdcross",
    "\\chbgdkhoriz",
    "\\chbgdkvert",
    "\\chbgdkfdiag",
    "\\chbgdkbdiag",
    "\\chbgdkcross",
    "\\chbgdkdcross",
    };

/************************************************************************/
/*									*/
/*  Save a text attribute (change).					*/
/*									*/
/************************************************************************/

void docRtfSaveTextAttribute(		RtfWritingContext *	rwc,
					const PropertyMask *	updMask,
					const TextAttribute *	ta )
    {
    if  ( PROPmaskISSET( updMask, TApropTEXT_STYLE ) )
	{ docRtfWriteArgTag( rwc, "\\cs", ta->taTextStyleNumber ); }

    if  ( PROPmaskISSET( updMask, TApropDOC_FONT_NUMBER ) )
	{ docRtfWriteArgTag( rwc, "\\f", ta->taFontNumber ); }

    if  ( PROPmaskISSET( updMask, TApropFONTSIZE ) )
	{ docRtfWriteArgTag( rwc, "\\fs", ta->taFontSizeHalfPoints ); }

    if  ( PROPmaskISSET( updMask, TApropTEXT_COLOR ) )
	{ docRtfWriteArgTag( rwc, "\\cf", ta->taTextColorNumber ); }

    if  ( PROPmaskISSET( updMask, TApropBORDER ) )
	{
	const int	anyway= 1;

	docRtfSaveBorderByNumber( rwc, "\\chbrdr",
					    ta->taBorderNumber, anyway );
	}

    if  ( PROPmaskISSET( updMask, TApropSHADING ) )
	{
	const BufferDocument *		bd= rwc->rwcBd;
	const NumberedPropertiesList *	isl= &(bd->bdItemShadingList);
	ItemShading			is;

	docGetItemShadingByNumber( &is, isl, ta->taShadingNumber );

	if  ( is.isBackColor > 0		&&
	      is.isPattern == DOCspSOLID	&&
	      is.isLevel == 0			)
	    { docRtfWriteArgTag( rwc, "\\cb", is.isBackColor );	}

	docRtfSaveShadingByNumber( rwc, ta->taShadingNumber,
		DOC_rtfTextShadingTags, "\\chcfpat", "\\chcbpat", "\\chshdng" );
	}

    if  ( PROPmaskISSET( updMask, TApropFONTBOLD ) )
	{
	if  ( ta->taFontIsBold )
	    { docRtfWriteTag( rwc, "\\b" );			}
	else{ docRtfWriteArgTag( rwc, "\\b", ta->taFontIsBold );	}
	}

    if  ( PROPmaskISSET( updMask, TApropFONTSLANTED ) )
	{
	if  ( ta->taFontIsSlanted )
	    { docRtfWriteTag( rwc, "\\i" );			}
	else{ docRtfWriteArgTag( rwc, "\\i", ta->taFontIsSlanted ); }
	}

    if  ( PROPmaskISSET( updMask, TApropTEXTUNDERLINED ) )
	{
	if  ( ta->taTextIsUnderlined )
	    { docRtfWriteTag( rwc, "\\ul" );			 }
	else{ docRtfWriteArgTag( rwc, "\\ul", ta->taTextIsUnderlined ); }
	}

    if  ( PROPmaskISSET( updMask, TApropSUPERSUB ) )
	{
	switch( ta->taSuperSub )
	    {
	    case DOCfontREGULAR:
		docRtfWriteTag( rwc, "\\nosupersub" );
		break;

	    case DOCfontSUPERSCRIPT:
		docRtfWriteTag( rwc, "\\super" );
		break;

	    case DOCfontSUBSCRIPT:
		docRtfWriteTag( rwc, "\\sub" );
		break;

	    default:
		LDEB(ta->taSuperSub);
	    }
	}

    if  ( PROPmaskISSET( updMask, TApropSMALLCAPS ) )
	{
	if  ( ta->taSmallCaps )
	    { docRtfWriteTag( rwc, "\\scaps" );			 }
	else{ docRtfWriteArgTag( rwc, "\\scaps", ta->taSmallCaps ); }
	}

    if  ( PROPmaskISSET( updMask, TApropCAPITALS ) )
	{
	if  ( ta->taCapitals )
	    { docRtfWriteTag( rwc, "\\caps" );			}
	else{ docRtfWriteArgTag( rwc, "\\caps", ta->taCapitals );	}
	}

    if  ( PROPmaskISSET( updMask, TApropSTRIKETHROUGH ) )
	{
	if  ( ta->taHasStrikethrough )
	    { docRtfWriteTag( rwc, "\\strike" );			}
	else{
	    docRtfWriteArgTag( rwc, "\\strike", ta->taHasStrikethrough );
	    }
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Handle a text property when reading RTF.				*/
/*									*/
/************************************************************************/

static int docRtfRememberTextPropertyImpl(	TextAttribute *		ta,
						const RtfControlWord *	rcw,
						int			arg,
						RtfReadingContext *	rrc )
    {
    switch( rcw->rcwID )
	{
	case TAprop_NONE:
	    docPlainTextAttribute( ta, rrc->rrcBd );
	    return 0;

	case TApropFONTSIZE:
	    if  ( arg < 2 || arg > 2000 )
		{ LSLDEB(rrc->rrcCurrentLine,rcw->rcwWord,arg); arg=20;	}
	    break;

	case TApropBORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;

	default:
	    break;
	}

    if  ( utilSetTextProperty( ta, rcw->rcwID, arg ) < 0 )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

int docRtfRememberTextShadingProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    RtfReadingState *	rrs= rrc->rrcState;

    if  ( docSetShadingProperty( &(rrs->rrsTextShading),
						    rcw->rcwID, arg ) < 0 )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    rrs->rrsTextShadingChanged= 1;

    return 0;
    }

int docRtfRememberTextProperty(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    RtfReadingState *	rrs= rrc->rrcState;

    if  ( rcw->rcwID == TApropTEXT_STYLE )
	{
	const	DocumentStyleSheet *	dss= &(rrc->rrcBd->bdStyleSheet);

	rrc->rrcDocumentStyle.dsLevel= DOClevSPAN;

	if  ( arg >= 0 && arg < dss->dssStyleCount )
	    {
	    const DocumentStyle *	ds= dss->dssStyles+ arg;

	    if  ( ds->dsLevel == DOClevSPAN )
		{
		PropertyMask	doneMask;

		if  ( rrs->rrsTextShadingChanged )
		    { docRtfRefreshTextShading( rrc, rrs );	}

		utilUpdateTextAttribute( &doneMask, &(rrs->rrsTextAttribute),
				    &(ds->dsTextAttribute), &(ds->dsTextMask) );
		}
	    }
	}

    /* Also used to start a font in the font list		*/
    if  ( rcw->rcwID == TApropDOC_FONT_NUMBER )
	{
	docRtfRestartFont( rrc );

	rrc->rrcCurrentEncodedFont.ecFileFontNumber= arg;

	if  ( ! docRtfReadMapFont( rrc,
			    &(rrc->rrcCurrentEncodedFont.ecBufFontNumber),
			    &(rrc->rrcCurrentEncodedFont.ecCharset),
			    rrc->rrcCurrentEncodedFont.ecFileFontNumber ) )
	    {
	    rrc->rrcCurrentFont.dfDocFontNumber=
				rrc->rrcCurrentEncodedFont.ecBufFontNumber;
	    rrs->rrsTextCharset= rrc->rrcCurrentEncodedFont.ecCharset;

	    arg= rrc->rrcCurrentEncodedFont.ecBufFontNumber;
	    }
	}

    if  ( rcw->rcwID == TAprop_NONE )
	{
	docInitItemShading( &(rrs->rrsTextShading) );
	rrs->rrsTextShadingChanged= 0;
	}

    if  ( docRtfRememberTextPropertyImpl( &(rrs->rrsTextAttribute),
							    rcw, arg, rrc ) )
	{ SDEB(rcw->rcwWord); return -1;	}

    if  ( rcw->rcwID != TAprop_NONE && rcw->rcwID < TAprop_COUNT )
	{ PROPmaskADD( &(rrc->rrcDocumentStyle.dsTextMask), rcw->rcwID ); }

    return 0;
    }

int docRtfRememberPntextProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    /* Also used to start a font in the font list		*/
    if  ( rcw->rcwID == TApropDOC_FONT_NUMBER )
	{
	int		bufFontNum;
	int		charset;

	if  ( ! docRtfReadMapFont( rrc, &bufFontNum, &charset, arg ) )
	    { arg= bufFontNum;	}
	}

    if  ( rcw->rcwID == TAprop_NONE )
	{
	docInitItemShading( &(rrc->rrcParagraphNumberTextShading) );
	/*rrc->rrcParagraphNumberTextShadingChanged= 0;*/
	}

    if  ( docRtfRememberTextPropertyImpl(
		&(rrc->rrcParagraphNumber.pnTextAttribute), rcw, arg, rrc ) )
	{ SDEB(rcw->rcwWord); return -1;	}

    return 0;
    }

void docRtfResetTextAttribute(	RtfReadingState *	rrs,
				BufferDocument *	bd )
    {
    docPlainTextAttribute( &(rrs->rrsTextAttribute), bd );
    docInitItemShading( &(rrs->rrsTextShading) );
    rrs->rrsTextShadingChanged= 0;

    return;
    }

/************************************************************************/
/*									*/
/*  Translate the separate text shading properties that we have		*/
/*  collected to a shading number.					*/
/*									*/
/************************************************************************/

void docRtfRefreshTextShading(	RtfReadingContext *	rrc,
				RtfReadingState *	rrs )
    {
    rrs->rrsTextAttribute.taShadingNumber= docItemShadingNumber(
					&(rrc->rrcBd->bdItemShadingList),
					&(rrs->rrsTextShading) );
    rrs->rrsTextShadingChanged= 0;

    return;
    }

