/************************************************************************/
/*									*/
/*  Identifies RTF control words					*/
/*									*/
/************************************************************************/

typedef enum RtfTag
    {
    RTFidRTF,

				/****************************************/
				/*  Document group.			*/
				/****************************************/
    RTFidPN,
				/****************************************/
				/*  Groups inside the document.		*/
				/****************************************/
    RTFidF,
    RTFidREVTBL,
				/****************************************/
				/*  Font number.			*/
				/****************************************/
    RTFidUC,
				/****************************************/
				/*  Document properties.		*/
				/****************************************/

    RTFidFTNALT,
				/****************************************/
				/*  Revision marks for paragraph	*/
				/*  numbers.				*/
				/****************************************/
				/****************************************/
				/*  Multilevel Lists.			*/
				/****************************************/
    RTFidPNSECLVL,

				/****************************************/
				/*  Tabs.				*/
				/****************************************/
    RTFidTX,

				/****************************************/
				/*  Character Formatting Properties	*/
				/****************************************/
    RTFidULNONE,
    RTFidV,

				/****************************************/
				/*  Pictures				*/
				/****************************************/
    RTFidDO,
				/****************************************/
				/*  Pictures, objects			*/
				/****************************************/
    RTFidOBJECT,
    RTFidOBJCLASS,
    RTFidOBJNAME,
    RTFidOBJDATA,

				/****************************************/
				/*  Table definitions			*/
				/****************************************/

				/****************************************/
				/*  Bullets and Numbering.		*/
				/*  (No destinations)			*/
				/****************************************/
    RTFidPNHANG,
    RTFidPNULNONE,

				/****************************************/
				/*  Fields, Bookmarks.			*/
				/****************************************/
    RTFidFIELD,

    RTFidBKMKSTART,
    RTFidBKMKEND,
				/****************************************/
				/*  Index entries.			*/
				/*  Table of contents entries.		*/
				/****************************************/

				/****************************************/
				/*  Associated Character Properties	*/
				/****************************************/

				/****************************************/
				/*  About bullet numbering.		*/
				/****************************************/
    RTFidPNTXTA,
    RTFidPNTXTB,
				/****************************************/
				/*  Groups inside the 'info' group.	*/
				/****************************************/
    RTFidOPERATOR,
    RTFidVERSION,
    RTFidEDMINS,
    RTFidNOFPAGES,
    RTFidNOFWORDS,
    RTFidNOFCHARS,
    RTFidNOFCHARSWS,
    RTFidVERN,
				/****************************************/
				/*  Shapes.				*/
				/****************************************/
    RTFidSHPTXT,
    RTFidSHPRSLT,
    RTFidSHPINST,
				/****************************************/
				/*  Fields in dates and times.		*/
				/****************************************/
    RTFidHR,
    RTFidMIN,
    RTFidSEC,
    RTFidDY,
    RTFidMO,
    RTFidYR,
				/****************************************/
				/*  Unknown				*/
				/****************************************/

    RTFid_NOT_SUPPORTED,

    RTFid__COUNT

    } RtfTag;

