/************************************************************************/
/*									*/
/*  Read/Write tab stops from/to rtf.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"

/************************************************************************/
/*									*/
/*  Save a tab stop.							*/
/*									*/
/************************************************************************/

void docRtfSaveTabStopList( 	RtfWritingContext *		rwc,
				const TabStopList *		tsl )
    {
    int			i;
    const TabStop *	ts;

    ts= tsl->tslTabStops;
    for ( i= 0; i < tsl->tslTabStopCount; ts++, i++ )
	{
	if  ( rwc->rwcCol >= 65 )
	    { docRtfWriteNextLine( rwc );	}

	switch( ts->tsAlignment )
	    {
	    case DOCtaLEFT:
		break;
	    case DOCtaRIGHT:
		docRtfWriteTag( rwc, "\\tqr" );
		break;
	    case DOCtaCENTER:
		docRtfWriteTag( rwc, "\\tqc" );
		break;
	    case DOCtaDECIMAL:
		docRtfWriteTag( rwc, "\\tqdec" );
		break;
	    default:
		LDEB(ts->tsAlignment); break;
	    }

	switch( ts->tsLeader )
	    {
	    case DOCtlNONE:
		break;
	    case DOCtlDOTS:
		docRtfWriteTag( rwc, "\\tldot" );
		break;
	    case DOCtlUNDERLINE:
		docRtfWriteTag( rwc, "\\tlul" );
		break;
	    case DOCtlHYPH:
		docRtfWriteTag( rwc, "\\tlhyph" );
		break;
	    case DOCtlTHICK:
		docRtfWriteTag( rwc, "\\tlth" );
		break;
	    case DOCtlEQUAL:
		docRtfWriteTag( rwc, "\\tleq" );
		break;
	    default:
		LDEB(ts->tsLeader); break;
	    }

	if  ( ts->tsFromStyleOrList )
	    { docRtfWriteTag( rwc, "\\jclisttab" );	}

	docRtfWriteArgTag( rwc, "\\tx", ts->tsTwips );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Handle a tab stop property when reading RTF.			*/
/*									*/
/************************************************************************/

int docRtfRememberTabStopProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    TabStop *	ts= &(rrc->rrcTabStop);

    switch( rcw->rcwID )
	{
	case TABpropX:
	    ts->tsTwips= arg; /* but never passed to setter */
	    break;

	case TABpropALIGN:
	    ts->tsAlignment= arg;
	    break;

	case TABpropLEADER:
	    ts->tsLeader= arg;
	    break;

	case TABpropFROM_STYLE:
	    ts->tsFromStyleOrList= arg != 0;
	    break;

	default:
	    SDEB(rcw->rcwWord);
	    return 0;
	}

    return 0;
    }
