/************************************************************************/
/*									*/
/*  Exchange of section properties with RTF.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"

/************************************************************************/
/*									*/
/*  Write Section Properties.						*/
/*									*/
/************************************************************************/

void docRtfSaveSectionProperties( RtfWritingContext *		rwc,
				const PropertyMask *		updMask,
				const SectionProperties *	sp )
    {
    const DocumentGeometry *	dg= &(sp->spDocumentGeometry);

    /**************/

    if  ( PROPmaskISSET( updMask, DGpropPAGE_WIDTH ) )
	{
	docRtfWriteArgTag( rwc, "\\pgwsxn",	dg->dgPageWideTwips );
	}
    if  ( PROPmaskISSET( updMask, DGpropPAGE_HEIGHT ) )
	{
	docRtfWriteArgTag( rwc, "\\pghsxn",	dg->dgPageHighTwips );
	}
    if  ( PROPmaskISSET( updMask, DGpropLEFT_MARGIN ) )
	{
	docRtfWriteArgTag( rwc, "\\marglsxn",dg->dgLeftMarginTwips );
	}
    if  ( PROPmaskISSET( updMask, DGpropTOP_MARGIN ) )
	{
	docRtfWriteArgTag( rwc, "\\margtsxn",dg->dgTopMarginTwips );
	}
    if  ( PROPmaskISSET( updMask, DGpropRIGHT_MARGIN ) )
	{
	docRtfWriteArgTag( rwc, "\\margrsxn",dg->dgRightMarginTwips );
	}
    if  ( PROPmaskISSET( updMask, DGpropBOTTOM_MARGIN ) )
	{
	docRtfWriteArgTag( rwc, "\\margbsxn",dg->dgBottomMarginTwips );
	}
    if  ( PROPmaskISSET( updMask, DGpropGUTTER ) )
	{
	docRtfWriteArgTag( rwc, "\\guttersxn",dg->dgGutterTwips );
	}
    if  ( PROPmaskISSET( updMask, DGpropMARGMIR ) && dg->dgMirrorMargins )
	{
	docRtfWriteTag( rwc, "\\margmirsxn" );
	}
    if  ( PROPmaskISSET( updMask, DGpropHEADER_POSITION ) )
	{
	docRtfWriteArgTag( rwc, "\\headery", dg->dgHeaderPositionTwips );
	}
    if  ( PROPmaskISSET( updMask, DGpropFOOTER_POSITION ) )
	{
	docRtfWriteArgTag( rwc, "\\footery", dg->dgFooterPositionTwips );
	}

    /**************/

    if  ( PROPmaskISSET( updMask, SPpropSTYLE ) )
	{
	docRtfWriteArgTag( rwc, "\\ds",sp->spStyle );
	}

    if  ( PROPmaskISSET( updMask, SPpropTITLEPG ) )
	{
	if  ( sp->spHasTitlePage )
	    { docRtfWriteTag( rwc, "\\titlepg" );			 }
	else{ docRtfWriteArgTag( rwc, "\\titlepg", sp->spHasTitlePage ); }
	}

    if  ( PROPmaskISSET( updMask, SPpropBREAK_KIND ) )
	{
	switch( sp->spBreakKind )
	    {
	    case DOCibkNONE:
		docRtfWriteTag( rwc, "\\sbknone" );	break;
	    case DOCibkCOL:
		docRtfWriteTag( rwc, "\\sbkcol" );	break;
	    case DOCibkPAGE:
		docRtfWriteTag( rwc, "\\sbkpage" );	break;
	    case DOCibkEVEN:
		docRtfWriteTag( rwc, "\\sbkeven" );	break;
	    case DOCibkODD:
		docRtfWriteTag( rwc, "\\sbkodd" );	break;
	    default:
		LDEB(sp->spBreakKind);
	    }
	}

    if  ( PROPmaskISSET( updMask, SPpropNUMBER_STYLE ) )
	{
	switch( sp->spPageNumberStyle )
	    {
	    case DOCpgnDEC:
		docRtfWriteTag( rwc, "\\pgndec" );	break;
	    case DOCpgnUCRM:
		docRtfWriteTag( rwc, "\\pgnucrm" );	break;
	    case DOCpgnLCRM:
		docRtfWriteTag( rwc, "\\pgnlcrm" );	break;
	    case DOCpgnUCLTR:
		docRtfWriteTag( rwc, "\\pgnucltr" );	break;
	    case DOCpgnLCLTR:
		docRtfWriteTag( rwc, "\\pgnlcltr" );	break;
	    default:
		LDEB(sp->spPageNumberStyle);
	    }
	}

    if  ( PROPmaskISSET( updMask, SPpropNUMBER_HYPHEN ) )
	{
	switch( sp->spPageNumberHyphen )
	    {
	    case DOCpgnhPGNHNSH:
		docRtfWriteTag( rwc, "\\pgnhnsh" );	break;
	    case DOCpgnhPGNHNSP:
		docRtfWriteTag( rwc, "\\pgnhnsp" );	break;
	    case DOCpgnhPGNHNSC:
		docRtfWriteTag( rwc, "\\pgnhnsc" );	break;
	    case DOCpgnhPGNHNSM:
		docRtfWriteTag( rwc, "\\pgnhnsm" );	break;
	    case DOCpgnhPGNHNSN:
		docRtfWriteTag( rwc, "\\pgnhnsn" );	break;
	    default:
		LDEB(sp->spPageNumberHyphen);
	    }
	}

    if  ( PROPmaskISSET( updMask, SPpropPAGE_RESTART ) )
	{
	if  ( sp->spRestartPageNumbers )
	    { docRtfWriteTag( rwc, "\\pgnrestart" );	}
	else{ docRtfWriteTag( rwc, "\\pgncont" );		}
	}

    if  ( PROPmaskISSET( updMask, SPpropSTART_PAGE ) )
	{
	docRtfWriteArgTag( rwc, "\\pgnstarts", sp->spStartPageNumber+ 1 );
	}

    if  ( PROPmaskISSET( updMask, SPpropCOLUMN_COUNT ) )
	{ docRtfWriteArgTag( rwc, "\\cols", sp->spColumnCount );	}
    if  ( PROPmaskISSET( updMask, SPpropCOLUMN_SPACING ) )
	{ docRtfWriteArgTag( rwc, "\\colsx", sp->spColumnSpacingTwips ); }

    if  ( PROPmaskISSET( updMask, SPpropCOLUMNS )	||
	  sp->spColumnCount > 1				)
	{
	int			i;
	const SectionColumn *	sc= sp->spColumns;


	for ( i= 0; i < sp->spColumnCount; sc++, i++ )
	    {
	    if  ( sc->scColumnWidthTwips == 0	&&
		  sc->scSpaceToRightTwips == 0	)
		{ continue;	}

	    docRtfWriteArgTag( rwc, "\\colno", i+ 1 );

	    if  ( sc->scColumnWidthTwips != 0 )
		{
		docRtfWriteArgTag( rwc, "\\colw", sc->scColumnWidthTwips );
		}
	    if  ( sc->scSpaceToRightTwips != 0 )
		{
		docRtfWriteArgTag( rwc, "\\colsr", sc->scSpaceToRightTwips );
		}
	    }
	}

    if  ( PROPmaskISSET( updMask, SPpropLINEBETCOL ) )
	{
	if  ( sp->spLineBetweenColumns )
	    { docRtfWriteTag( rwc, "\\linebetcol" );	}
	else{ docRtfWriteTag( rwc, "\\linebetcol0" );	}
	}

    docRtfWriteNextLine( rwc );

    /**************/

    if  ( PROPmaskISSET( updMask, SPpropFOOTNOTE_POSITION ) )
	{
	switch( sp->spFootnoteProperties.npPosition )
	    {
	    case FTN_POS_SECT_END:
	    case FTN_POS_DOC_END:
		/* inherited from doc? */
		break;

	    case FTN_POS_BELOW_TEXT:
		docRtfWriteTag( rwc, "\\sftntj" );
		break;
	    case FTN_POS_PAGE_BOTTOM:
		docRtfWriteTag( rwc, "\\sftnbj" );
		break;
	    default:
		LDEB(sp->spFootnoteProperties.npPosition); break;
	    }
	}

    if  ( PROPmaskISSET( updMask, SPpropENDNOTE_POSITION ) )
	{
	switch( sp->spEndnoteProperties.npPosition )
	    {
	    case FTN_POS_SECT_END:
	    case FTN_POS_DOC_END:
		/* inherited from doc? */
		break;

	    case FTN_POS_BELOW_TEXT:
		docRtfWriteTag( rwc, "\\saftntj" );
		break;
	    case FTN_POS_PAGE_BOTTOM:
		docRtfWriteTag( rwc, "\\saftnbj" );
		break;
	    default:
		LDEB(sp->spEndnoteProperties.npPosition); break;
	    }
	}

    if  ( PROPmaskISSET( updMask, SPpropFOOTNOTE_STARTNR ) )
	{
	docRtfWriteArgTag( rwc, "\\sftnstart",
				    sp->spFootnoteProperties.npStartNumber );
	}
    if  ( PROPmaskISSET( updMask, SPpropENDNOTE_STARTNR ) )
	{
	docRtfWriteArgTag( rwc, "\\saftnstart",
				    sp->spEndnoteProperties.npStartNumber );
	}

    if  ( PROPmaskISSET( updMask, SPpropFOOTNOTE_RESTART ) )
	{
	switch( sp->spFootnoteProperties.npRestart )
	    {
	    case FTN_RST_CONTINUOUS:
		docRtfWriteTag( rwc, "\\sftnrstcont" );
		break;
	    case FTN_RST_PER_SECTION:
		docRtfWriteTag( rwc, "\\sftnrestart" );
		break;
	    case FTN_RST_PER_PAGE:
		docRtfWriteTag( rwc, "\\sftnrstpg" );
		break;
	    default:
		LDEB(sp->spFootnoteProperties.npRestart); break;
	    }
	}

    if  ( PROPmaskISSET( updMask, SPpropENDNOTE_RESTART ) )
	{
	switch( sp->spEndnoteProperties.npRestart )
	    {
	    case FTN_RST_CONTINUOUS:
		docRtfWriteTag( rwc, "\\saftnrstcont" );
		break;
	    case FTN_RST_PER_SECTION:
		docRtfWriteTag( rwc, "\\saftnrestart" );
		break;
	    /* No!
	    case FTN_RST_PER_PAGE:
		docRtfWriteTag( rwc, "\\saftnrstpg" );
		break;
	    */
	    default:
		LDEB(sp->spEndnoteProperties.npRestart); break;
	    }
	}

    if  ( PROPmaskISSET( updMask, SPpropFOOTNOTE_STYLE ) )
	{
	switch( sp->spFootnoteProperties.npNumberStyle )
	    {
	    case FTNstyleNAR:
		docRtfWriteTag( rwc, "\\sftnnar" );
		break;
	    case FTNstyleNALC:
		docRtfWriteTag( rwc, "\\sftnnalc" );
		break;
	    case FTNstyleNAUC:
		docRtfWriteTag( rwc, "\\sftnnauc" );
		break;
	    case FTNstyleNRLC:
		docRtfWriteTag( rwc, "\\sftnnrlc" );
		break;
	    case FTNstyleNRUC:
		docRtfWriteTag( rwc, "\\sftnnruc" );
		break;
	    case FTNstyleNCHI:
		docRtfWriteTag( rwc, "\\sftnnchi" );
		break;
	    default:
		LDEB(sp->spFootnoteProperties.npNumberStyle); break;
	    }
	}

    if  ( PROPmaskISSET( updMask, SPpropENDNOTE_STYLE ) )
	{
	switch( sp->spEndnoteProperties.npNumberStyle )
	    {
	    case FTNstyleNAR:
		docRtfWriteTag( rwc, "\\saftnnar" );
		break;
	    case FTNstyleNALC:
		docRtfWriteTag( rwc, "\\saftnnalc" );
		break;
	    case FTNstyleNAUC:
		docRtfWriteTag( rwc, "\\saftnnauc" );
		break;
	    case FTNstyleNRLC:
		docRtfWriteTag( rwc, "\\saftnnrlc" );
		break;
	    case FTNstyleNRUC:
		docRtfWriteTag( rwc, "\\saftnnruc" );
		break;
	    case FTNstyleNCHI:
		docRtfWriteTag( rwc, "\\saftnnchi" );
		break;
	    default:
		LDEB(sp->spEndnoteProperties.npNumberStyle); break;
	    }
	}

    return;
    }


/************************************************************************/
/*									*/
/*  Handle a section property when reading RTF.				*/
/*									*/
/************************************************************************/

int docRtfRememberSectionProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    SectionProperties *		sp= &(rrc->rrcSectionProperties);

    switch( rcw->rcwID )
	{
	case SPprop_NONE:
	    {
	    const DocumentProperties *	dp;

	    if  ( ! rrc->rrcBd )
		{ XDEB(rrc->rrcBd); return -1;	}

	    dp= &(rrc->rrcBd->bdProperties);

	    docCleanSectionProperties( sp );
	    docInitSectionProperties( sp );
	    rrc->rrcSectionColumn= 0;

	    sp->spDocumentGeometry= dp->dpGeometry;
	    sp->spFootnoteProperties= dp->dpFootnoteProperties;
	    sp->spEndnoteProperties= dp->dpEndnoteProperties;
	    }
	    return 0;

	case SPpropSTYLE:
	    rrc->rrcDocumentStyle.dsLevel= DOClevSECT;
	    break;

	/***/
	case SPprop_COLUMN_NUMBER:
	    rrc->rrcSectionColumn= arg- 1;
	    return 0;

	case SPprop_COLUMN_WIDTH:
	    if  ( sp->spColumnCount < 2				||
		  rrc->rrcSectionColumn < 0			||
		  rrc->rrcSectionColumn >= sp->spColumnCount	)
		{
		/*LLDEB(rrc->rrcSectionColumn,sp->spColumnCount);*/
		return 0;
		}

	    sp->spColumns[rrc->rrcSectionColumn].scColumnWidthTwips= arg;
	    return 0;

	case SPprop_COLUMN_RIGHT:
	    if  ( sp->spColumnCount < 2				||
		  rrc->rrcSectionColumn < 0			||
		  rrc->rrcSectionColumn >= sp->spColumnCount	)
		{ LLDEB(rrc->rrcSectionColumn,sp->spColumnCount); return 0; }

	    sp->spColumns[rrc->rrcSectionColumn].scSpaceToRightTwips= arg;
	    return 0;
	}

    PROPmaskADD( &(rrc->rrcCellPropertyMask), rcw->rcwID );

    if  ( docSetSectionProperty( sp, rcw->rcwID, arg ) < 0 )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    PROPmaskADD( &(rrc->rrcDocumentStyle.dsSectMask), rcw->rcwID );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Save the headers and footers of a Section.				*/
/*									*/
/************************************************************************/

int docRtfSaveSectHeadersFooters(	RtfWritingContext *	rwc,
					const BufferItem *	sectBi )
    {
    const BufferItem *		prevBi= (const BufferItem *)0;
    const DocumentProperties *	dp= &(rwc->rwcBd->bdProperties);
    const int			forcePar= 1;

    if  ( sectBi->biParent				&&
	  sectBi->biNumberInParent > 0			)
	{ prevBi= sectBi->biParent->biChildren[ sectBi->biNumberInParent- 1]; }

    /*  Word 11+ uses right header/footer anyway. For compatibility: */
    if  ( ! dp->dpHasFacingPages )
	{
	if  ( docRtfSaveExternalItem( rwc, "\\header",
				sectBi->biSectRightPageHeader.eiRoot,
				prevBi && prevBi->biSectRightPageHeader.eiRoot,
				forcePar )	)
	    { LDEB(1); return -1;	}
	}

    if  ( docRtfSaveExternalItem( rwc, "\\headerf",
				sectBi->biSectFirstPageHeader.eiRoot,
				prevBi && prevBi->biSectFirstPageHeader.eiRoot,
				forcePar )	)
	{ LDEB(1); return -1;	}

    if  ( docRtfSaveExternalItem( rwc, "\\headerl",
				sectBi->biSectLeftPageHeader.eiRoot,
				prevBi && prevBi->biSectLeftPageHeader.eiRoot,
				forcePar )	)
	{ LDEB(1); return -1;	}

    if  ( docRtfSaveExternalItem( rwc, "\\headerr",
				sectBi->biSectRightPageHeader.eiRoot,
				prevBi && prevBi->biSectRightPageHeader.eiRoot,
				forcePar )	)
	{ LDEB(1); return -1;	}

    /*  Word 11+ uses right header/footer anyway. For compatibility: */
    if  ( ! dp->dpHasFacingPages )
	{
	if  ( docRtfSaveExternalItem( rwc, "\\footer",
				sectBi->biSectRightPageFooter.eiRoot,
				prevBi && prevBi->biSectRightPageFooter.eiRoot,
				forcePar )	)
	    { LDEB(1); return -1;	}
	}

    if  ( docRtfSaveExternalItem( rwc, "\\footerf",
				sectBi->biSectFirstPageFooter.eiRoot,
				prevBi && prevBi->biSectFirstPageFooter.eiRoot,
				forcePar )	)
	{ LDEB(1); return -1;	}

    if  ( docRtfSaveExternalItem( rwc, "\\footerl",
				sectBi->biSectLeftPageFooter.eiRoot,
				prevBi && prevBi->biSectLeftPageFooter.eiRoot,
				forcePar )	)
	{ LDEB(1); return -1;	}

    if  ( docRtfSaveExternalItem( rwc, "\\footerr",
				sectBi->biSectRightPageFooter.eiRoot,
				prevBi && prevBi->biSectRightPageFooter.eiRoot,
				forcePar )	)
	{ LDEB(1); return -1;	}

    return 0;
    }

