/************************************************************************/
/*									*/
/*  Exchange between row properties and Rtf.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"

/************************************************************************/

static const char * DOC_rtfRowShadingTags[]=
    {
    (const char *)0,	/*  solid	*/
    "\\trbghoriz",
    "\\trbgvert",
    "\\trbgfdiag",
    "\\trbgbdiag",
    "\\trbgcross",
    "\\trbgdcross",
    "\\trbgdkhor",
    "\\trbgdkvert",
    "\\trbgdkfdiag",
    "\\trbgdkbdiag",
    "\\trbgdkcross",
    "\\trbgdkdcross",
    };

/************************************************************************/
/*									*/
/*  Save row properties to RTF.						*/
/*									*/
/************************************************************************/

void docRtfSaveRowProperties(		RtfWritingContext *	rwc,
					const RowProperties *	rp,
					int			col0,
					int			col1 )
    {
    const CellProperties *	cp= rp->rpCells;

    int				col;
    int				shiftLeft= 0;

    const int			anyway= 0;
    FrameProperties		fp;

    docRtfWriteTag( rwc, "\\trowd" );

    if  ( rp->rpRowNumber >= 0 )
	{ docRtfWriteArgTag( rwc, "\\irow", rp->rpRowNumber ); }
    if  ( rp->rpRowBandNumber >= 0 )
	{ docRtfWriteArgTag( rwc, "\\irowband", rp->rpRowBandNumber ); }
    if  ( rp->rpRowStyle >= 0 )
	{ docRtfWriteArgTag( rwc, "\\ts", rp->rpRowStyle ); }

    if  ( rp->rpHalfGapWidthTwips != 0 )
	{ docRtfWriteArgTag( rwc, "\\trgaph", rp->rpHalfGapWidthTwips ); }

    if  ( rp->rpLeftIndentTwips != 0 )
	{ docRtfWriteArgTag( rwc, "\\trleft", rp->rpLeftIndentTwips ); }

    if  ( rp->rpHeightTwips != 0 )
	{ docRtfWriteArgTag( rwc, "\\trrh", rp->rpHeightTwips ); }

    if  ( rp->rpIsTableHeader )
	{ docRtfWriteTag( rwc, "\\trhdr" ); }
    if  ( rp->rpKeepOnOnePage )
	{ docRtfWriteTag( rwc, "\\trkeep" ); }
    if  ( rp->rp_Keepfollow )
	{ docRtfWriteTag( rwc, "\\trkeepfollow" ); }
    if  ( rp->rpAutofit )
	{ docRtfWriteArgTag( rwc, "\\trautofit", rp->rpAutofit ); }

    docRtfWriteNextLine( rwc );

    docRtfSaveBorderByNumber( rwc, "\\trbrdrt",
				    rp->rpTopBorderNumber, anyway );
    docRtfSaveBorderByNumber( rwc, "\\trbrdrl",
				    rp->rpLeftBorderNumber, anyway );
    docRtfSaveBorderByNumber( rwc, "\\trbrdrr",
				    rp->rpRightBorderNumber, anyway );
    docRtfSaveBorderByNumber( rwc, "\\trbrdrb",
				    rp->rpBottomBorderNumber, anyway );
    docRtfSaveBorderByNumber( rwc, "\\trbrdrv",
				    rp->rpVerticalBorderNumber, anyway );
    docRtfSaveBorderByNumber( rwc, "\\trbrdrh",
				    rp->rpHorizontalBorderNumber, anyway );

    /**/
    docRtfSaveShadingByNumber( rwc, rp->rpShadingNumber,
		DOC_rtfRowShadingTags, "\\trcfpat", "\\trcbpat", "\\trshdng" );

    /**/
    docGetFramePropertiesByNumber( &fp,
			    &(rwc->rwcBd->bdFramePropertyList),
			    rp->rpFrameNumber );
    if  ( DOCisFRAME( &fp ) )
	{ docRtfSaveRowFrameProperties( rwc, &fp );	}

    /**/
    docRtfSaveAutoSpace( rwc,
			"\\trftsWidth", rp->rpPreferredWidthUnit,
			"\\trwWidth", rp->rpPreferredWidth );

    /**/
    docRtfSaveAutoSpace( rwc,
			"\\trspdfl", rp->rpLeftDefaultCellSpacingUnit,
			"\\trspdl", rp->rpLeftDefaultCellSpacing );

    docRtfSaveAutoSpace( rwc,
			"\\trspdfr", rp->rpRightDefaultCellSpacingUnit,
			"\\trspdr", rp->rpRightDefaultCellSpacing );

    docRtfSaveAutoSpace( rwc,
			"\\trspdft", rp->rpTopDefaultCellSpacingUnit,
			"\\trspdt", rp->rpTopDefaultCellSpacing );

    docRtfSaveAutoSpace( rwc,
			"\\trspdfb", rp->rpBottomDefaultCellSpacingUnit,
			"\\trspdb", rp->rpBottomDefaultCellSpacing );

    /**/
    docRtfSaveAutoSpace( rwc,
			"\\trpaddfl", rp->rpLeftCellPaddingUnit,
			"\\trpaddl", rp->rpLeftCellPadding );

    docRtfSaveAutoSpace( rwc,
			"\\trpaddfr", rp->rpRightCellPaddingUnit,
			"\\trpaddr", rp->rpRightCellPadding );

    docRtfSaveAutoSpace( rwc,
			"\\trpaddft", rp->rpTopCellPaddingUnit,
			"\\trpaddt", rp->rpTopCellPadding );

    docRtfSaveAutoSpace( rwc,
			"\\trpaddfb", rp->rpBottomCellPaddingUnit,
			"\\trpaddb", rp->rpBottomCellPadding );

    /**/
    docRtfSaveAutoSpace( rwc,
			"\\trftsWidthB", rp->rpCellWidthBeforeUnit,
			"\\trwWidthB", rp->rpCellWidthBefore );

    docRtfSaveAutoSpace( rwc,
			"\\trftsWidthA", rp->rpCellWidthAfterUnit,
			"\\trwWidthA", rp->rpCellWidthAfter );

    /**/
    if  ( col0 > 0 )
	{ shiftLeft= cp[col0-1].cpRightBoundaryTwips; }

    for ( col= 0; col < rp->rpCellCount; cp++, col++ )
	{
	if  ( ( col0 < 0 || col >= col0 )	&&
	      ( col1 < 0 || col <= col1 )	)
	    { docRtfSaveCellProperties( rwc, cp, shiftLeft );	}
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Handle a row property when reading RTF.				*/
/*									*/
/************************************************************************/

static void docRtfResetRowProperties(	RtfReadingContext *	rrc )
    {
    RowProperties *	rp= &(rrc->rrcRowProperties);

    docCleanRowProperties( rp );
    docInitRowProperties(  rp );
    utilPropMaskClear( &(rrc->rrcRowPropertyMask) );
    docInitItemShading(  &(rrc->rrcRowShading) );

    docCleanCellProperties( &(rrc->rrcCellProperties) );
    docInitCellProperties(  &(rrc->rrcCellProperties) );
    docInitItemShading(  &(rrc->rrcCellShading) );
    }

int docRtfRememberRowShadingProperty(	const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    if  ( docSetShadingProperty( &(rrc->rrcRowShading), rcw->rcwID, arg ) < 0 )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    PROPmaskADD( &(rrc->rrcRowPropertyMask), RPpropSHADING );

    return 0;
    }

int docRtfRememberRowProperty(		const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    RowProperties *	rp= &(rrc->rrcRowProperties);

    switch( rcw->rcwID )
	{
	case RPprop_NONE:
	    docRtfResetRowProperties( rrc );
	    return 0;

	case RPpropTOP_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;
	case RPpropBOTTOM_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;
	case RPpropLEFT_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;
	case RPpropRIGHT_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;
	case RPpropHORIZ_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;
	case RPpropVERT_BORDER:
	    arg= docRtfReadGetBorderNumber( rrc );
	    if  ( arg < 0 )
		{ LDEB(arg); return -1;	}
	    break;

	case RPprop_IGNORED:
	    return 0;
	}

    PROPmaskADD( &(rrc->rrcRowPropertyMask), rcw->rcwID );

    if  ( docSetRowProperty( rp, rcw->rcwID, arg ) < 0 )
	{ SLDEB(rcw->rcwWord,arg); return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Cope with Word10 {\trowd ...... } peculiarity.			*/
/*									*/
/************************************************************************/

int docRtfReadRow(		const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    int			rval= 0;

    RowProperties	savedRp;
    CellProperties	savedCp;
    ItemShading		savedRowShading;
    ItemShading		savedCellShading;

    savedRp= rrc->rrcRowProperties;
    savedCp= rrc->rrcCellProperties;
    savedRowShading= rrc->rrcRowShading;
    savedCellShading= rrc->rrcCellShading;

    docInitRowProperties( &(rrc->rrcRowProperties) );
    docInitCellProperties( &(rrc->rrcCellProperties) );
    docInitItemShading(  &(rrc->rrcRowShading) );
    docInitItemShading(  &(rrc->rrcCellShading) );

    if  ( docRtfReadGroup( rcw, 0, 0, rrc,
	    docRtfDocumentGroups, docRtfTextParticule, (RtfCommitGroup)0 ) )
	{ SDEB(rcw->rcwWord); rval= -1; goto ready;	}

  ready:

    docCleanRowProperties( &(rrc->rrcRowProperties) );
    docCleanCellProperties( &(rrc->rrcCellProperties) );

    rrc->rrcRowProperties= savedRp;
    rrc->rrcCellProperties= savedCp;
    rrc->rrcRowShading= savedRowShading;
    rrc->rrcCellShading= savedCellShading;

    return rval;
    }

