/************************************************************************/
/*									*/
/*  Read an RTF text file into a BufferDocument				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	<utilMatchFont.h>

#   include	"docRtf.h"
#   include	"docRtfReadWrite.h"
#   include	"docParaString.h"

/************************************************************************/
/*									*/
/*  Groups (Most of them handeled at the document level).		*/
/*									*/
/************************************************************************/

RtfControlWord	docRtfDocumentGroups[]=
{
    RTF_DEST_XX( "tc",		DOCfkTC,	docRtfLookupEntry ),
    RTF_DEST_XX( "tcn",		DOCfkTCN,	docRtfLookupEntry ),

    RTF_DEST_XX( "nonesttables", 1,		docRtfSkipGroup ),

    RTF_DEST_XX( "trowd",	DOClevROW,	docRtfReadRow ),

    { (char *)0, 0, 0 }
};

/************************************************************************/
/*									*/
/*  Read a document as a whole.						*/
/*									*/
/************************************************************************/

static int docRtfReadDoc(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    int		res;

    rrc->rrcSelectionScope.ssInExternalItem= DOCinBODY;

    res= docRtfReadGroup( rcw, 0, 0, rrc,
				docRtfDocumentGroups,
				docRtfTextParticule,
				docRtfFinishCurrentItem );
    if  ( res )
	{ SLDEB(rcw->rcwWord,res);	}

    return res;
    }

/************************************************************************/
/*									*/
/*  Read a whole document.						*/
/*									*/
/*  As at least MS-Word 2000 crashes on lists without an override,	*/
/*  and on the other hand staroffice/openoffice creates them under	*/
/*  certain circumstances: Make an empty override for lists without	*/
/*  overrides.								*/
/*									*/
/************************************************************************/

static RtfControlWord	docRtfOutsideGroups[]=
    {
	RTF_DEST_XX( "rtf",	RTFidRTF,	docRtfReadDoc ),

	{ (char *)0, 0, 0 }
    };

BufferDocument * docRtfReadFile(SimpleInputStream *		sis,
				const PostScriptFontList *	psfl )
    {
    BufferDocument *		rval= (BufferDocument *)0;
    BufferDocument *		bd= (BufferDocument *)0;
    RtfReadingContext		rrc;

    int				res;
    const RtfControlWord *	rcw;

    char			controlWord[TEDszRTFCONTROL+1];
    int				gotArg;
    int				arg= -1;
    int				c;

    const DocumentField *	dfNote;
    DocumentNote *		dn;

    bd= docNewDocument();
    if  ( ! bd )
	{ XDEB(bd); goto ready;	}

    docRtfInitReadingContext( &rrc );

    rrc.rrcBd= bd;
    rrc.rrcEi= &(bd->bdBody);
    rrc.rrcBi= rrc.rrcEi->eiRoot;
    rrc.rrcLevel= DOClevBODY;
    rrc.rrcPostScriptFontList= psfl;
    rrc.rrcSis= sis;

    res= docRtfFindControl( &rrc, &c, controlWord, &gotArg, &arg );
    if  ( res != RTFfiCTRLGROUP )
	{ goto ready; }

    rcw= docRtfFindWord( controlWord, docRtfOutsideGroups );
    if  ( ! rcw )
	{ LDEB(1); goto ready; }
    if  ( rcw->rcwType != RTCtypeDEST )
	{ SLDEB(rcw->rcwWord,rcw->rcwType); goto ready;	}

    res= docRtfApplyControlWord( rcw, gotArg, arg, &rrc );
    if  ( res )
	{ LDEB(1); goto ready; }

    if  ( ! rrc.rrcGotDocGeometry	&&
	  bd->bdBody.eiRoot->biChildCount > 0	)
	{
	bd->bdProperties.dpGeometry=
		    bd->bdBody.eiRoot->biChildren[0]->biSectDocumentGeometry;
	}

    docRtfCleanReadingContext( &rrc );

    dfNote= docGetFirstNoteOfDocument( &dn, bd, DOCinFOOTNOTE );
    if  ( dfNote )
	{
	if  ( docCheckNoteSeparatorItem( bd, DOCinFTNSEP ) )
	    { LDEB(DOCinFTNSEP); goto ready; }
	}

    dfNote= docGetFirstNoteOfDocument( &dn, bd, DOCinENDNOTE );
    if  ( dfNote )
	{
	if  ( docCheckNoteSeparatorItem( bd, DOCinAFTNSEP ) )
	    { LDEB(DOCinAFTNSEP); goto ready; }
	}

    if  ( docMakeOverrideForEveryList( &(bd->bdProperties) ) )
	{ LDEB(1); goto ready;	}

    if  ( docGetCharsUsed( bd ) )
	{ LDEB(1); goto ready;	}

    rval= bd; bd= (BufferDocument *)0; /* steal */

    /* LDEB(1); docListItem(0,rval->bdBody.eiRoot); */

  ready:

    if  ( bd )
	{ docFreeDocument( bd );	}

    return rval;
    }

/************************************************************************/
/*									*/
/*  Remember properties to be used subsequently.			*/
/*									*/
/*  References are to be replaced with feature specific routine		*/
/*  refrerences.							*/
/*									*/
/************************************************************************/

int docRtfRememberProperty(	const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    RtfReadingState *	rrs= rrc->rrcState;

    switch( rcw->rcwID )
	{
	case RTFidUC:
	    if  ( rrc->rrcState )
		{ rrc->rrcState->rrsBytesPerUnicode= arg;	}
	    break;

	case RTFidFTNALT:
	    if  ( rrc->rrcSelectionScope.ssInExternalItem != DOCinFOOTNOTE )
		{ LLDEB(rrc->rrcSelectionScope.ssInExternalItem,DOCinFOOTNOTE);	}
	    else{ rrc->rrcSelectionScope.ssInExternalItem= DOCinENDNOTE;		}

	    break;

	case RTFidTX:
	    rrc->rrcTabStop.tsTwips= arg;
	    if  ( docParaAddTab( &(rrs->rrsParagraphProperties),
						    &(rrc->rrcTabStop) ) < 0 )
		{ LDEB(arg); return -1;	}
	    docInitTabStop( &(rrc->rrcTabStop) );

	    PROPmaskADD( &(rrc->rrcDocumentStyle.dsParaMask),
							PPpropTAB_STOPS );
	    break;

				/****************************************/
				/*  Set/Unset Text Attributes.		*/
				/****************************************/
	case RTFidULNONE:
	    rrs->rrsTextAttribute.taTextIsUnderlined= 0;
	    break;
				/****************************************/
				/*  Set/Unset Text Attributes.		*/
				/*  In Paragraph Numbering.		*/
				/****************************************/
	case RTFidPNULNONE:
	    rrc->rrcParagraphNumber.pnTextAttribute.taTextIsUnderlined= 0;
	    break;

				/****************************************/
				/*  Paragraph Numbering.		*/
				/****************************************/
	case RTFidPNHANG:
	    rrc->rrcParagraphNumber.pnUseHangingIndent= 1;
	    break;
				/****************************************/
				/*  Unknown				*/
				/****************************************/
	default:
	    /*SLDEB(rcw->rcwWord,rcw->rcwID);*/
	    break;
	}

    return 0;
    }
