/************************************************************************/
/*									*/
/*  Calculate page number and ref fields.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<utilBase26.h>
#   include	<utilRoman.h>
#   include	"docBuf.h"
#   include	"docEvalField.h"

/************************************************************************/
/*									*/
/*  Evaluate REF fields.						*/
/*									*/
/************************************************************************/

# define REF_FIC_COUNT 8
static int docFieldGetRef(	const DocumentField *	df,
				const char **		pMarkName,
				int *			pMarkSize )
    {
    FieldInstructionsComponent	fic[REF_FIC_COUNT];
    int				n;
    int				comp;
    unsigned char *		bytes= df->dfInstructions.mbBytes;

    char *			markName= (char *)0;
    int				markSize= 0;

    if  ( df->dfKind != DOCfkREF )
	{ return -1;	}

    n= docSplitFieldInstructions( &(df->dfInstructions), fic, REF_FIC_COUNT );
    if  ( n < 2 )
	{ LDEB(n); return -1;	}

    comp= 0;
    if  ( fic[comp].ficSize != 3					||
	  memcmp( bytes+ fic[comp].ficOffset, "REF", 3 )	)
	{ SDEB((char *)bytes); return -1;	}
    comp++;

    markName= (char *)bytes+ fic[comp].ficOffset;
    markSize= fic[comp].ficSize;
    comp++;

    while( comp < n						&&
	  fic[comp].ficSize == 2				)
	{
	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\f", 2 )	)
	    { comp++; continue;	}
	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\n", 2 )	)
	    { comp++; continue;	}
	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\h", 2 )	)
	    { comp++; continue;	}
	if  ( ! memcmp( bytes+ fic[comp].ficOffset, "\\r", 2 )	)
	    { comp++; continue;	}

	break;
	}

    while( comp < n )
	{ LSDEB(comp,(char *)bytes+ fic[comp].ficOffset); comp++; }

    *pMarkName= markName;
    *pMarkSize= markSize;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Return the value of a ref field.					*/
/*									*/
/************************************************************************/

int docCalculateRefFieldString( int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf )
    {
    const char *		markName;
    int				markSize;

    DocumentSelection		dsInside;
    int				headPart;
    int				tailPart;

    if  ( docFieldGetRef( df, &markName, &markSize ) )
	{ LDEB(1); *pCalculated= 0; return 0;	}

    docInitDocumentSelection( &dsInside );

    if  ( docFindBookmarkInDocument( &dsInside, &headPart, &tailPart,
					    rf->rfBd, markName, markSize ) )
	{
	const char *	ehh1= "<<? ";
	const char *	ehh2= "?>> ";

	utilAddToMemoryBuffer( mbResult,
				    (unsigned char *)ehh1, strlen( ehh1 ) );

	utilAddToMemoryBuffer( mbResult,
				    (unsigned char *)markName, markSize );

	utilAddToMemoryBuffer( mbResult,
				    (unsigned char *)ehh2, strlen( ehh2 ) );
	}
    else{
	int			beginMoved= 0;
	int			endMoved= 0;
	int			skipping= 0;

	const BufferItem *	paraBiFrom;
	const TextParticule *	tp;
	int			part;
	const int		lastOne= 1;

	docConstrainSelectionToOneParagraph( &beginMoved, &endMoved,
								&dsInside ); 
	paraBiFrom= dsInside.dsHead.dpBi;
	/*
	Really happens. E.G: In the word 2003 rtf spec.
	if  ( dsInside.dsTail.dpStroff == dsInside.dsHead.dpStroff )
	    { LLDEB(dsInside.dsTail.dpStroff,dsInside.dsHead.dpStroff);	}
	*/

	if  ( docFindParticuleOfPosition( &part,
					    &(dsInside.dsHead), lastOne ) )
	    { LDEB(dsInside.dsHead.dpStroff); return -1;	}

	tp= paraBiFrom->biParaParticules+ part;
	while( part < paraBiFrom->biParaParticuleCount	&&
	       tp->tpKind != DOCkindSPAN		)
	    { part++; tp++;	}

	for ( ; part < paraBiFrom->biParaParticuleCount; tp++, part++ )
	    {
	    if  ( tp->tpStroff >= dsInside.dsTail.dpStroff )
		{ break;	}

	    if  ( tp->tpKind == DOCkindSPAN )
		{
		if  ( skipping )
		    {
		    utilAddToMemoryBuffer( mbResult, (unsigned char *)" ", 1 );
		    }

		utilAddToMemoryBuffer( mbResult,
				    docParaString( paraBiFrom, tp->tpStroff ),
				    tp->tpStrlen );
		skipping= 0;
		}
	    else{
		skipping= 1;
		}
	    }
	}

    *pCalculated= 1;

    return 0;
    }

