#   include	"docBuf.h"

#   ifndef	DOC_RECALCULATE_FIELDS_H
#   define	DOC_RECALCULATE_FIELDS_H

#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Pass through information for recalculating fields.			*/
/*									*/
/*  MERGEFIELDs and report generation.					*/
/*									*/
/************************************************************************/

typedef int (*FieldDataProvider)(	int *		pCalculated,
					MemoryBuffer *	mbResult,
					const char *	fieldName,
					void *		through );

typedef enum StreamPosition
    {
    StreamFirstInstance= 0,
    StreamNextInstance,
    StreamReady
    } StreamPosition;

typedef int (*InstanceStreamProvider)(	int *		pCalculated,
					const char *	streamName,
					int		streamPosition,
					void *		through );

/************************************************************************/
/*									*/
/*  Pass through information for recalculating fields.			*/
/*									*/
/************************************************************************/

typedef struct RecalculateFields
    {
    struct BufferDocument *	rfBd;
    struct DocumentTree *	rfEi;
    void *			rfMergeValueTree;
    DOC_CLOSE_OBJECT		rfCloseObject;
    unsigned int		rfFieldsUpdated;
    unsigned int		rfUpdateFlags;
    EditPosition		rfSelBegin;
    EditPosition		rfSelEnd;

    FieldDataProvider		rfFieldDataProvider;
    InstanceStreamProvider	rfInstanceStreamProvider;
    void *			rfMergeThrough;
    } RecalculateFields;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitRecalculateFields(	RecalculateFields *	rf );

extern int docRecalculateTocFields( RecalculateFields *		rf );

extern int docRecalculateOneTocField(	BufferDocument *	bdDoc,
					const DocumentField *	df );

#   endif	/*  DOC_RECALCULATE_FIELDS_H  */
