/************************************************************************/
/*									*/
/*  Obtain the objects embedded in a document.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<sioMemory.h>
#   include	<sioStdio.h>
#   include	<sioHex.h>
#   include	<sioEndian.h>

#   include	<appDebugon.h>

#   include	<docBuf.h>

/************************************************************************/
/*									*/
/*  Read a bitmap/pixmap image file.					*/
/*									*/
/************************************************************************/

int docReadBitmapObject(	InsertedObject *	io,
				const char *		filename )
    {
    int				rval= 0;
    int				res;
    AppBitmapImage		abi;
    const char *		typeId= "?";
    int				copyAsFile= 0;
    int				includedAsBitmap= 0;

    PictureProperties *		pip= &(io->ioPictureProperties);

    SimpleOutputStream *	sosMem= (SimpleOutputStream *)0;
    SimpleOutputStream *	sosHex= (SimpleOutputStream *)0;
    SimpleInputStream *		sisFile= (SimpleInputStream *)0;

    bmInitBitmapImage( &abi );

    res= bmRead( filename, &(abi.abiBuffer), &(abi.abiBitmap),
							&(abi.abiFormat) );
    if  ( res )
	{ SLDEB(filename,res); rval= -1; goto ready;	}

    if  ( abi.abiFormat >= 0 )
	{ typeId= bmFileFormats[abi.abiFormat].bffFileType->bftTypeId; }

    io->ioKind= DOCokPICTPNGBLIP;
    io->ioInline= 1;

    bmImageSizeTwips( &(io->ioTwipsWide), &(io->ioTwipsHigh),
							&(abi.abiBitmap) );

    pip->pipTwipsWide= io->ioTwipsWide;
    pip->pipTwipsHigh= io->ioTwipsHigh;

    io->ioResultData.mbSize= 0;
    sosMem= sioOutMemoryOpen( &(io->ioObjectData) );
    if  ( ! sosMem )
	{ XDEB(sosMem); rval= -1; goto ready;	}

    sosHex= sioOutHexOpen( sosMem );
    if  ( ! sosHex )
	{ XDEB(sosHex); sioOutClose( sosMem ); rval= -1; goto ready;	}

    if  ( abi.abiFormat >= 0				&&
	  ( ! strcmp( typeId, "jpgFile" )	||
	    ! strcmp( typeId, "jpegFile" )	)	)
	{
	io->ioKind= DOCokPICTJPEGBLIP;
	pip->pipType= DOCokPICTJPEGBLIP;
	copyAsFile= 1;
	}

    if  ( abi.abiFormat >= 0			&&
	  ! strcmp( typeId, "pngFile" )		)
	{
	io->ioKind= DOCokPICTPNGBLIP;
	pip->pipType= DOCokPICTPNGBLIP;
	copyAsFile= 1;
	}

    if  ( copyAsFile )
	{
	unsigned char		buf[4096];
	int			got;

	sisFile= sioInStdioOpen( filename );
	if  ( ! sisFile )
	    { SXDEB(filename,sisFile); rval= -1; goto ready; }

	for (;;)
	    {
	    got= sioInReadBytes( sisFile, buf, sizeof(buf) );
	    if  ( got < 0 )
		{ LDEB(got); rval= -1; goto ready; }
	    if  ( got <= 0 )
		{ break; }

	    if  ( sioOutWriteBytes( sosHex, buf, got ) < 0 )
		{ LDEB(got); rval= -1; goto ready;	}
	    }

	includedAsBitmap= 1;
	}

    if  ( ! includedAsBitmap				&&
	  ! bmCanWritePngFile(  &(abi.abiBitmap), 1 )	)
	{
	if  ( bmPngWritePng( &(abi.abiBitmap), abi.abiBuffer, sosHex ) )
	    { LDEB(1); rval= -1; goto ready;	}

	io->ioKind= DOCokPICTPNGBLIP;
	pip->pipType= DOCokPICTPNGBLIP;
	includedAsBitmap= 1;
	}

    if  ( ! includedAsBitmap )
	{
	if  ( bmWmfWriteWmf( &(abi.abiBitmap), abi.abiBuffer, sosHex ) )
	    { LDEB(1); rval= -1; goto ready;	}

	pip->pipMetafileIsBitmap= 1;
	pip->pipMetafileBitmapBpp= abi.abiBitmap.bdBitsPerPixel;

	io->ioKind= DOCokPICTWMETAFILE;
	pip->pipType= DOCokPICTWMETAFILE;
	pip->pipMapMode= 8;
	}

  ready:

    bmCleanBitmapImage( &abi );

    if  ( sisFile )
	{ sioInClose( sisFile );	}
    if  ( sosHex )
	{ sioOutClose( sosHex );	}
    if  ( sosMem )
	{ sioOutClose( sosMem );	}

    return rval;
    }
