/************************************************************************/
/*									*/
/*  Set DocumentPosition and EditPosition values.			*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  From DocumentPosition to EditPosition.				*/
/*									*/
/************************************************************************/

void docSetEditPosition(	EditPosition *		ep,
				const BufferItem *	paraBi,
				int			stroff )
    {
    ep->epParaNr= docNumberOfParagraph( paraBi );
    ep->epStroff= stroff;
    }

void docSetEditRange(		EditRange *			er,
				const DocumentSelection *	ds )
    {
    docSetEditPosition( &(er->erHead),
				ds->dsHead.dpBi, ds->dsHead.dpStroff );
    docSetEditPosition( &(er->erTail),
				ds->dsTail.dpBi, ds->dsTail.dpStroff );
    }

/************************************************************************/
/*									*/
/*  Compare two positions in a document.				*/
/*									*/
/*  Comparison is in terms of the reading order in the document.	*/
/*  Assume the items are part of the same tree in the document.		*/
/*									*/
/************************************************************************/

int docCompareItemPositions(	const BufferItem *	bi1,
				const BufferItem *	bi2 )
    {
    while( bi1->biParent && bi1->biLevel > bi2->biLevel )
	{ bi1= bi1->biParent;	}

    while( bi2->biParent && bi2->biLevel > bi1->biLevel )
	{ bi2= bi2->biParent;	}

    if  ( bi1 == bi2 )
	{ return 0;	}

    while( bi1->biParent			&&
	   bi2->biParent			&&
	   ( bi1->biParent != bi2->biParent )	)
	{ bi1= bi1->biParent; bi2= bi2->biParent; }

    if  ( bi1->biParent && bi1->biParent == bi2->biParent )
	{
	if  ( bi1->biNumberInParent > bi2->biNumberInParent )
	    { return  1;	}

	if  ( bi1->biNumberInParent < bi2->biNumberInParent )
	    { return -1;	}

	return 0;
	}

    XXDEB(bi1->biParent,bi2->biParent);

    return 0;
    }

int docComparePositions(	const DocumentPosition *	dp1,
				const DocumentPosition *	dp2 )
    {
    const BufferItem *	bi1= dp1->dpBi;
    const BufferItem *	bi2= dp2->dpBi;

    if  ( bi1 == bi2 )
	{
	if  ( dp1->dpStroff > dp2->dpStroff )
	    { return  1;	}

	if  ( dp1->dpStroff < dp2->dpStroff )
	    { return -1;	}

	return 0;
	}

    return docCompareItemPositions( bi1, bi2 );
    }

/************************************************************************/
/*									*/
/*  From EditPosition to DocumentPosition.				*/
/*									*/
/************************************************************************/

int docPositionForEditPosition(	DocumentPosition *		dpNew,
				const EditPosition *		ep,
				const DocumentTree *		ei )
    {
    BufferItem *		paraBi;

    if  ( ! ei )
	{ XDEB(ei); return -1;	}

    paraBi= docGetParagraphByNumber( ei, ep->epParaNr );
    if  ( ! paraBi )
	{ LXDEB(ep->epParaNr,paraBi); return -1;	}
    if  ( ep->epStroff > docParaStrlen( paraBi ) )
	{
	LLDEB(ep->epStroff,docParaStrlen(paraBi));
	if  ( docLastPosition( dpNew, paraBi ) )
	    { LDEB(1); return -1;	}
	}
    else{
	docSetDocumentPosition( dpNew, paraBi, ep->epStroff );
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Fill a DocumentPosition.						*/
/*									*/
/************************************************************************/

int docSetDocumentPosition(	DocumentPosition *	dp,
				BufferItem *		bi,
				int			stroff )
    {
    dp->dpBi= bi;
    dp->dpStroff= stroff;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Initialise a DocumentPosition.					*/
/*									*/
/************************************************************************/

void docInitDocumentPosition(	DocumentPosition *	dp )
    {
    dp->dpBi= (BufferItem *)0;
    dp->dpStroff= 0;

    return;
    }

/************************************************************************/
/*									*/
/*  Translate an EditRange to a selection for a particular document.	*/
/*									*/
/************************************************************************/

int docSelectionForEditPositionsInTree(	DocumentSelection *		dsNew,
					const DocumentTree *		ei,
					const EditPosition *		epHead,
					const EditPosition *		epTail )
    {
    DocumentPosition		dpHead;
    DocumentPosition		dpTail;

    if  ( docPositionForEditPosition( &dpHead, epHead, ei ) )
	{ LDEB(1); return -1;	}
    if  ( docPositionForEditPosition( &dpTail, epTail, ei ) )
	{ LDEB(1); return -1;	}

    docSetRangeSelection( dsNew, &dpHead, &dpTail, 1, -1, -1 );

    return 0;
    }

int docSelectionForEditPositionsInDoc(	DocumentSelection *		dsNew,
					const BufferDocument *		bd,
					const SelectionScope *		ss,
					const EditPosition *		epHead,
					const EditPosition *		epTail )
    {
    DocumentTree *		ei;
    BufferItem *		bodySectBi;

    TableRectangle		tr;

    if  ( docGetRootOfSelectionScope( &ei, &bodySectBi, 
						(BufferDocument *)bd, ss ) )
	{ LDEB(1); return -1;	}

    if  ( docSelectionForEditPositionsInTree( dsNew, ei, epHead, epTail ) )
	{ LDEB(1); return -1;	}

    if  ( ! docSelectionInsideCell( dsNew )	&&
	  ! docGetTableRectangle( &tr, dsNew )	)
	{
	BufferItem *	selParentBi;

	if  ( docTableRectangleSelection( dsNew, &selParentBi,
						(BufferDocument *)bd, &tr ) )
	    { LDEB(1);	}
	}

    return 0;
    }

