/************************************************************************/
/*									*/
/*  Save a BufferDocument into a plain text file.			*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"docBuf.h"

#   include	<appDebugon.h>

typedef struct PlainWritingContext
    {
    int		pwcFold;
    int		pwcEndClosed;
    int		pwcNoteRefCount;
    int		pwcNoteDefCount;
    } PlainWritingContext;

static void docInitPlainWritingContext(	PlainWritingContext *	pwc )
    {
    pwc->pwcFold= 0;
    pwc->pwcEndClosed= 1;
    pwc->pwcNoteRefCount= 0;
    pwc->pwcNoteDefCount= 0;
    }

static int docPlainSaveParaItem(	SimpleOutputStream *		sos,
					const BufferDocument *		bd,
					const BufferItem *		paraBi,
					const DocumentSelection *	ds,
					PlainWritingContext *		pwc )
    {
    TextParticule *		tp;
    int				pos= 0;
    int				lineCount= 0;
    int				part= 0;

    int				from= 0;
    int				upto= docParaStrlen( paraBi );

    const DocumentField *	df;

    if  ( ds )
	{
	if  ( ds->dsHead.dpBi == paraBi )
	    {
	    const int	lastOne= 1;

	    if  ( docFindParticuleOfPosition( &part, &(ds->dsHead), lastOne ) )
		{ LDEB(ds->dsHead.dpStroff); return -1;	}

	    from= ds->dsHead.dpStroff;
	    }

	if  ( ds->dsTail.dpBi == paraBi )
	    { upto= ds->dsTail.dpStroff;	}
	}

    tp= paraBi->biParaParticules+ part;

    while( part < paraBi->biParaParticuleCount )
	{
	TextAttribute		ta;

	utilGetTextAttributeByNumber( &ta, &(bd->bdTextAttributeList),
						tp->tpTextAttrNr );

	switch( tp->tpKind )
	    {
	    case DOCkindTAB:
		sioOutPutByte( '\t', sos );
		pos= 8* ( pos+ 8 )/ 8;
		break;

	    case DOCkindSPAN:
		if  ( pwc->pwcFold && pos > 8 && pos+ tp->tpStrlen >= 72 )
		    {
		    sioOutPutByte( '\n', sos );
		    lineCount++; pos= 0;

		    if  ( paraBi->biParaFirstIndentTwips < -9	&&
			  paraBi->biParaLeftIndentTwips > 9	)
			{
			sioOutPutByte( '\t', sos ); pos= 8;
			}
		    }

		{
		int			stroff= tp->tpStroff;
		const unsigned char *	s;

		if  ( stroff < from )
		    { stroff=  from;	}

		s= docParaString( paraBi, stroff );
		while( stroff < upto && stroff < tp->tpStroff+ tp->tpStrlen )
		    {
		    sioOutPutByte( *s, sos );
		    s++; stroff++; pos++;
		    }
		}

		break;

	    case DOCkindLINEBREAK:
		sioOutPutByte( '\n', sos );
		pos= 0;
		break;

	    case DOCkindPAGEBREAK:
	    case DOCkindCOLUMNBREAK:
		sioOutPutByte( '\n', sos );
		sioOutPutByte( '\f', sos );
		pos= 0;
		break;

	    case DOCkindFIELDSTART:
		df= docGetFieldByNumber( &(bd->bdFieldList),
						    tp->tpObjectNumber );

		if  ( df->dfKind == DOCfkPAGEREF )
		    {
		    int		count;
		    int		closed;

		    count= docCountParticulesInField( paraBi, &closed, part,
						paraBi->biParaParticuleCount );

		    count++;
		    tp += count; part += count;
		    break;
		    }

		if  ( df->dfKind == DOCfkCHFTN )
		    {
		    int		count;
		    int		closed;
		    char	scratch[20+1];

		    count= docCountParticulesInField( paraBi, &closed, part,
						paraBi->biParaParticuleCount );

		    if  ( paraBi->biInExternalItem == DOCinBODY )
			{
			sprintf( scratch, "[%d]", pwc->pwcNoteRefCount+ 1 );
			pwc->pwcNoteRefCount++;
			}
		    else{
			sprintf( scratch, "[%d]", pwc->pwcNoteDefCount+ 1 );
			pwc->pwcNoteDefCount++;
			}

		    sioOutPutString( scratch, sos );

		    tp += count; part += count;
		    }
		break;

	    default:
		LDEB(tp->tpKind);
		/*FALLTHROUGH*/
	    case DOCkindOBJECT:
	    case DOCkindFIELDEND:
		break;
	    }

	 part++; tp++;
	 }

    if  ( pwc->pwcEndClosed && upto == docParaStrlen( paraBi ) )
	{ sioOutPutByte( '\n', sos ); lineCount++;	}

#   if 0
    if  ( lineCount == 1	&&
	  pos > 0		&&
	  paragraphUnderlined	)
	{
	stroff= 0;
	if  ( ds && ds->dsHead.dpBi == paraBi )
	    { stroff= ds->dsHead.dpStroff; }

	while( stroff < upto )
	    { sioOutPutByte( '-', sos ); stroff++;	}

	sioOutPutByte( '\n', sos );
	}
#   endif

    return 0;
    }

static int docPlainSaveRowItem(	SimpleOutputStream *		sos,
				const BufferDocument *		bd,
				const BufferItem *		rowBi,
				const DocumentSelection *	ds,
				PlainWritingContext *		pwc )
    {
    int			col;

    for ( col= 0; col < rowBi->biChildCount; col++ )
	{
	int		para;
	BufferItem *	cellBi= rowBi->biChildren[col];

	if  ( ds && docCompareItemPositions( cellBi, ds->dsHead.dpBi ) < 0 )
	    { continue;	}

	if  ( ds && docCompareItemPositions( cellBi, ds->dsTail.dpBi ) > 0 )
	    { continue;	}

	if  ( ! ds						||
	      ( ( ds->dsCol0 < 0 || col >= ds->dsCol0 )	&&
		( ds->dsCol1 < 0 || col <= ds->dsCol1 )	)	)
	    {
	    for ( para= 0; para < cellBi->biChildCount; para++ )
		{
		BufferItem *	paraBi= cellBi->biChildren[para];

		if  ( ds && docCompareItemPositions( paraBi,
						    ds->dsHead.dpBi ) < 0 )
		    { continue;	}

		if  ( ds && docCompareItemPositions( paraBi,
						    ds->dsTail.dpBi ) > 0 )
		    { continue;	}

		if  ( docPlainSaveParaItem( sos, bd, paraBi, ds, pwc ) )
		    { LLDEB(col,para); return -1;	}
		}
	    }
	}

    return 0;
    }

static int docPlainSaveItem(	SimpleOutputStream *		sos,
				const BufferDocument *		bd,
				const BufferItem *		bi,
				const DocumentSelection *	ds,
				PlainWritingContext *		pwc )
    {
    int		i;

    if  ( ds )
	{
	if  ( docCompareItemPositions( bi, ds->dsHead.dpBi ) < 0	)
	    { return 0;	}

	if  ( docCompareItemPositions( bi, ds->dsTail.dpBi ) > 0	)
	    { return 0;	}
	}

    switch( bi->biLevel )
	{
	case DOClevBODY:
	case DOClevSECT:
	case DOClevCELL:
	rowAsGroup:
	    for ( i= 0; i < bi->biChildCount; i++ )
		{
		if  ( docPlainSaveItem( sos, bd, bi->biChildren[i], ds, pwc ) )
		    { LDEB(i); return -1;	}
		}
	    break;

	case DOClevROW:
	    if  ( ! docIsRowItem( bi ) )
		{ goto rowAsGroup;	}

	    if  ( docPlainSaveRowItem( sos, bd, bi, ds, pwc ) )
		{ LDEB(1); return -1;	}
	    break;

	case DOClevPARA:
	    if  ( docPlainSaveParaItem( sos, bd, bi, ds, pwc ) )
		{ LDEB(1); return -1;	}
	    break;

	default:
	    LDEB(bi->biLevel); return -1;
	}

    return 0;
    }


int docPlainSaveDocument(	SimpleOutputStream *		sos,
				BufferDocument *		bd,
				const DocumentSelection *	ds,
				int				fold,
				int				closed )
    {
    const BufferItem *		bi= bd->bdBody.eiRoot;

    PlainWritingContext		pwc;

    docInitPlainWritingContext( &pwc );

    pwc.pwcFold= fold;
    pwc.pwcEndClosed= closed;

    if  ( ds )
	{
	DocumentTree *	ei;
	BufferItem *	bodySectBi;

	bi= docGetSelectionRoot( &ei, &bodySectBi, bd, ds );
	if  ( ! bi )
	    { XDEB(bi); return -1;	}
	}

    if  ( docPlainSaveItem( sos, bd, bi, ds, &pwc ) )
	{ LDEB(bi->biLevel); return -1; }

    if  ( ! ds && pwc.pwcNoteRefCount > 0 )
	{
	DocumentField *	dfNote;
	DocumentNote *	dn;

	sioOutPutString( "\n-----\n\n", sos );

	for ( dfNote= docGetFirstNoteOfDocument( &dn, bd, -1 );
	      dfNote;
	      dfNote= docGetNextNoteInDocument( &dn, bd, dfNote, -1 ) )
	    {
	    DocumentTree *	ei;

	    ei= &(dn->dnDocumentTree);;
	    if  ( ! ei->eiRoot )
		{ XDEB(ei->eiRoot); continue;	}

	    if  ( docPlainSaveItem( sos, bd, ei->eiRoot, ds, &pwc ) )
		{ LDEB(bi->biLevel); return -1; }
	    }

	if  ( pwc.pwcNoteDefCount != pwc.pwcNoteRefCount )
	    { LLDEB(pwc.pwcNoteDefCount,pwc.pwcNoteRefCount);	}
	}

    return 0;
    }
