/************************************************************************/
/*									*/
/*  Conversion to pixels inside a document.				*/
/*									*/
/************************************************************************/

#   ifndef	DOC_PIXELS_H
#   define	DOC_PIXELS_H

#   include	"docBuf.h"
#   include	<appDraw.h>

/************************************************************************/
/*									*/
/*  Pixel position on a page						*/
/*									*/
/************************************************************************/

# define PAGE_TOP_YPIXELS( add, lp ) \
	    ( (add)->addPageStepPixels* (lp)->lpPage )
# define PAGE_BELOW_YPIXELS( add, lp ) \
	    ( (add)->addPageStepPixels* ((lp)->lpPage+1) )

# define LP_YPIXELS( add, lp ) \
		Y_PIXELS( (add), (lp)->lpPage, (lp)->lpPageYTwips )
# define LP_Y1PIXELS( add, lp, high  ) \
		Y_PIXELS( (add), (lp)->lpPage, (lp)->lpPageYTwips+ (high) )

/**/

# define BI_TOP_PIXELS( add, bi ) \
			LP_YPIXELS( add, &((bi)->biTopPosition) )

# define BI_BELOW_PIXELS( add, bi ) \
			LP_YPIXELS( add, &((bi)->biBelowPosition) )

/**/

# define PG_TOP_PIXELS( add, pg ) \
			LP_YPIXELS( add, &((pg)->pgTopPosition) )

/**/

# define TL_TOP_PIXELS( add, tl ) LP_YPIXELS( add, &((tl)->tlTopPosition) )

# define TL_BASE_PIXELS( add, tl ) \
	( (add)->addPageStepPixels* (tl)->tlTopPosition.lpPage+ \
	  COORDtoGRID( (add)->addMagnifiedPixelsPerTwip, \
	    (tl)->tlTopPosition.lpPageYTwips- (tl)->tlAscY0 ) )

# define TL_BELOW_PIXELS( add, tl ) \
	( (add)->addPageStepPixels* (tl)->tlTopPosition.lpPage+ \
	  COORDtoGRID( (add)->addMagnifiedPixelsPerTwip, \
	    (tl)->tlTopPosition.lpPageYTwips+ \
	    (tl)->tlLineStride ) )

#   endif	/*  DOC_PIXELS_H  */
