/************************************************************************/
/*									*/
/*  Paragraph properties.						*/
/*									*/
/************************************************************************/

#   ifndef	DOC_PARA_PROP_H
#   define	DOC_PARA_PROP_H

#   include	<utilDocFont.h>
#   include	"utilPropMask.h"
#   include	"docPropVal.h"
#   include	"docTabStop.h"
#   include	"docBorderProperties.h"
#   include	"docItemShading.h"
#   include	"docParaNumber.h"
#   include	"docFrameProperties.h"
#   include	"docDocumentAttributeMap.h"

/************************************************************************/
/*									*/
/*  Paragraph properties.						*/
/*									*/
/*  Unless explicitly stated, all properties except numbers in pixels	*/
/*  are properties of the paragraph.					*/
/*									*/
/*  1)  Tab stops.							*/
/*  2)  Indentations.							*/
/*  3)  White space above/after the paragraph.				*/
/*  4)  Style, List Override ID.					*/
/*  5)  Borders.							*/
/*  6)  Shading.							*/
/*  7)  Frame.							*/
/*									*/
/************************************************************************/

typedef struct ParagraphProperties
    {
    /*  1  */
    TabStopList		ppTabStopList;

    /*  2  */
    short int		ppFirstIndentTwips;
    short int		ppLeftIndentTwips;
    short int		ppRightIndentTwips;

    /*  3  */
    short int		ppSpaceBeforeTwips;
    short int		ppSpaceAfterTwips;
    short int		ppLineSpacingTwips;

    /*  4  */
    short int		ppStyle;
    short int		ppListOverride;

    /*  5  */
    int			ppTopBorderNumber;
    int			ppBottomBorderNumber;
    int			ppLeftBorderNumber;
    int			ppRightBorderNumber;
    int			ppBetweenBorderNumber;
    int			ppBarNumber;

    /*  6  */
    int			ppShadingNumber;

    /*  7  */
    int			ppFrameNumber;
    unsigned char	ppTableNesting;			/*  itap	*/

    unsigned char	ppBreakKind;

    unsigned char	ppOutlineLevel;			/*  0 .. 9	*/
							/*  9= body.	*/
    unsigned char	ppListLevel; 			/*  ilvl	*/

    unsigned char	ppAlignment;			/*  (enum)	*/

    unsigned char	ppLineSpacingIsMultiple;

    unsigned char	ppKeepOnPage;
    unsigned char	ppKeepWithNext;
    unsigned char	ppWidowControl;
    unsigned char	ppHyphenateParagraph;
    } ParagraphProperties;

#   define	PPoutlineBODYTEXT	9
#   define	PPoutlineDEEPEST	(PPoutlineBODYTEXT-1)
#   define	PPoutline_COUNT		10

/************************************************************************/
/*									*/
/*  Numbers of paragraph properies.					*/
/*									*/
/************************************************************************/

typedef enum ParagraphProperty
    {
    PPprop_NONE= -1,

    PPpropSTYLE= 0,
    PPpropLISTOVERRIDE,
    PPpropTABLE_NESTING,
    PPpropLEFT_INDENT,
    PPpropFIRST_INDENT,
    PPpropRIGHT_INDENT,
    PPpropALIGNMENT,
    PPpropTAB_STOPS,
    PPpropBREAKKIND,
    PPpropWIDCTLPAR,
    PPpropKEEP,
    PPpropKEEPN,
    PPpropSPACE_BEFORE,
    PPpropSPACE_AFTER,
    PPpropLINE_SPACING_DIST,
    PPpropLINE_SPACING_MULT,

    PPpropTOP_BORDER,
    PPpropBOTTOM_BORDER,
    PPpropLEFT_BORDER,
    PPpropRIGHT_BORDER,
    PPpropBETWEEN_BORDER,
    PPpropBAR_BORDER,

    PPpropSHADING,
    PPpropFRAME,

    PPpropOUTLINELEVEL,
    PPpropLISTLEVEL,
    PPpropHYPHPAR,

    PPprop_COUNT,

    PPprop_IN_TABLE,			/* For read/write/tools only	*/

    PPprop_IGNORED,

    PPprop_COLUMNS,			/*  Not a real property.	*/
					/*  But used for managing the	*/
					/*  ruler of a document window.	*/
    PPprop_BOX_BORDER,			/*  Not a real property.	*/
					/*  But used to support the	*/
					/*  obsolete \\box tag.		*/

    PPprop_LISB,			/*  ignored.			*/
    PPprop_LISA,			/*  ignored.			*/

    PPprop_FULL_COUNT
    } ParagraphProperty;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int docParaAddTab(	ParagraphProperties *	pp,
				const TabStop *		tsNew );

extern void docParaDeleteTab(	ParagraphProperties *	pp,
				int			n );

extern int docUpdParaProperties( PropertyMask *			pPpChgPask,
				ParagraphProperties *		pp,
				const PropertyMask *		ppUpdMask,
				const ParagraphProperties *	ppNew,
				const DocumentAttributeMap *	dam );

extern void docParaPropertyDifference(
				PropertyMask *			pChgMask,
				const ParagraphProperties *	pp1,
				const ParagraphProperties *	pp2,
				const PropertyMask *		updMask );

extern void docCleanParagraphProperties(	ParagraphProperties *	pp );

extern void docInitParagraphProperties(		ParagraphProperties *	pp );

extern int docCopyParagraphProperties(
				ParagraphProperties *		ppTo,
				const ParagraphProperties *	ppFrom );

extern int docSetParaProperty(		ParagraphProperties *	pp,
					int			prop,
					int			arg );

extern int docGetParaProperty(		const ParagraphProperties *	pp,
					int				prop );

#   endif	/*  DOC_PARA_PROP_H	*/
