/************************************************************************/
/*									*/
/*  Document Layout and Printing related functionality.			*/
/*									*/
/************************************************************************/

#   ifndef	DOC_PAGE_GRID_H
#   define	DOC_PAGE_GRID_H

#   include	"docBuf.h"
#   include	"docBlockFrame.h"
#   include	"docStripFrame.h"
#   include	"docBlockOrnaments.h"

/************************************************************************/

#   define	includeRectangleY( dr1, dr2 ) \
		{ \
		if  ( (dr1)->drY0 > (dr2)->drY0 )  \
		    { (dr1)->drY0=  (dr2)->drY0; } \
		if  ( (dr1)->drY1 < (dr2)->drY1 )  \
		    { (dr1)->drY1=  (dr2)->drY1; } \
		}

/************************************************************************/

# define DOClayoutUSE_COLUMNS( inExtIt ) \
		    ( (inExtIt) == DOCinBODY		|| \
		      (inExtIt) == DOCinFOOTNOTE	|| \
		      (inExtIt) == DOCinENDNOTE		|| \
		      (inExtIt) == DOCinFTNSEP		|| \
		      (inExtIt) == DOCinFTNSEPC		|| \
		      (inExtIt) == DOCinFTNCN		|| \
		      (inExtIt) == DOCinAFTNSEP		|| \
		      (inExtIt) == DOCinAFTNSEPC	|| \
		      (inExtIt) == DOCinAFTNCN		)

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docBlockFrameTwips(	BlockFrame *			bf,
				BufferItem *			bi,
				const BufferItem *		bodySectBi,
				const BufferDocument *		bd,
				int				page,
				int				column );

extern void docCellFrameTwips(	ParagraphFrame *		pf,
				const BlockFrame *		bf,
				const BufferItem *		cellBi );

extern void docLayoutSectColumnTop(
				LayoutPosition *		lpTop,
				BlockFrame *			bf,
				BufferItem *			bodySectBi,
				BufferDocument *		bd );

extern void docParaBlockFrameRectangle( DocumentRectangle *	dr,
					BufferItem *		paraBi,
					const BufferItem *	bodySectBi,
					const BufferDocument *	bd,
					int			page,
					int			column );

extern void docParaBlockFrameTwips(	BlockFrame *		bf,
					BufferItem *		paraBi,
					const BufferItem *	bodySectBi,
					const BufferDocument *	bd,
					int			page,
					int			column );

extern void docParagraphFrameTwips(	ParagraphFrame *	pf,
					const BlockFrame *	bf,
					const BufferItem *	paraBi );

extern void docLayoutSetTextFrame(
				BlockFrame *			bfTextFrame,
				const LayoutPosition *		lpRef,
				const BlockFrame *		bfRef,
				const FrameProperties *		fp,
				int				frameHighVal );

extern void docGetCellOrnaments(
			BlockOrnaments *		cellOrnaments,
			DocumentRectangle *		drOutside,
			DocumentRectangle *		drInside,
			const DocumentRectangle *	drCell,
			const BufferDocument *		bd,
			const BufferItem *		rowBi,
			int				col,
			int				atRowTop,
			int				atRowBottom,
			int				drawTableGrid );

extern void docGetParaOrnaments(
			BlockOrnaments *		ornaments,
			DocumentRectangle *		drOutside,
			DocumentRectangle *		drInside,
			const DocumentRectangle *	drPara,
			const BufferDocument *		bd,
			const BufferItem *		paraBi,
			int				atTop,
			int				atBottom );

extern void docLayoutCalculateRowTopInset(
				int *				pInset,
				const BufferDocument *		bd,
				const BufferItem *		rowBi,
				int				atRowTop );

extern void docLayoutFrameX(	BlockFrame *			bfTextFrame,
				FrameXReference			xRefProp,
				int				xPosProp,
				int				xPosVal,
				int				layoutInCell,
				const ParagraphFrame *		pfRef,
				const BlockFrame *		bfRef,
				int				xChar,
				int				frameWide );

extern void docLayoutFrameY(	BlockFrame *			bfTextFrame,
				FrameXReference			yRefProp,
				int				yPosProp,
				int				yPosVal,
				const LayoutPosition *		lpLineTop,
				const LayoutPosition *		lpParaTop,
				const BlockFrame *		bfRef,
				int				frameHighProp,
				int				frameHighVal );

#   endif	/*  DOC_PAGE_GRID_H  */
