/************************************************************************/
/*									*/
/*  Buffer administration: manage embedded objects.			*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docObject.h"

/************************************************************************/
/*									*/
/*  Manage inserted objects.						*/
/*									*/
/************************************************************************/

void docCleanInsertedObject( InsertedObject * io )
    {
    utilCleanMemoryBuffer( &io->ioObjectData );
    utilCleanMemoryBuffer( &io->ioResultData );

    if  ( io->ioObjectName )
	{ free( io->ioObjectName );	}
    if  ( io->ioObjectClass )
	{ free( io->ioObjectClass );	}
    
    }

void docInitInsertedObject(	InsertedObject *	io )
    {
    io->ioKind= DOCokUNKNOWN;
    io->ioResultKind= DOCokUNKNOWN;
    io->ioRtfResultKind= RESULTkindUNKNOWN;
    io->ioRtfEmbedKind= EMBEDkindOBJEMB;

    docInitPictureProperties( &(io->ioPictureProperties) );

    io->ioInline= 1;

    io->ioTwipsWide= 0;
    io->ioTwipsHigh= 0;

    io->ioPixelsWide= 0;
    io->ioPixelsHigh= 0;
    io->ioScaleXSet= 100;
    io->ioScaleYSet= 100;
    io->ioScaleXUsed= 100;
    io->ioScaleYUsed= 100;

    io->ioX0Twips= 0;
    docInitLayoutPosition( &(io->ioY0Position) );

    io->ioTopCropTwips= 0;
    io->ioBottomCropTwips= 0;
    io->ioLeftCropTwips= 0;
    io->ioRightCropTwips= 0;

    utilInitMemoryBuffer( &io->ioObjectData );
    utilInitMemoryBuffer( &io->ioResultData );
    
    io->ioObjectName= (char *)0;
    io->ioObjectClass= (char *)0;

    io->ioDrawingShape= (struct DrawingShape *)0;

    io->ioScreenPixmap= (ScreenPixmap)0;
    io->ioPrivate= (void *)0;

    return;
    }

void docObjectAdaptToPictureGeometry(	InsertedObject *		io,
					const PictureProperties *	pip )
    {
    io->ioTwipsWide= pip->pipTwipsWide;
    io->ioTwipsHigh= pip->pipTwipsHigh;

    io->ioScaleXSet= pip->pipScaleXSet;
    io->ioScaleYSet= pip->pipScaleYSet;
    io->ioScaleXUsed= pip->pipScaleXUsed;
    io->ioScaleYUsed= pip->pipScaleYUsed;

    io->ioTopCropTwips= pip->pipTopCropTwips;
    io->ioBottomCropTwips= pip->pipBottomCropTwips;
    io->ioLeftCropTwips= pip->pipLeftCropTwips;
    io->ioRightCropTwips= pip->pipRightCropTwips;

    return;
    }

int docObjectSetData(	InsertedObject *	io,
			const char *		bytes,
			int			size )
    {
    return utilSetMemoryBuffer( &(io->ioObjectData),
				    (const unsigned char *)bytes, size );
    }

int docSetResultData(	InsertedObject *	io,
			const char *		bytes,
			int			size )
    {
    return utilSetMemoryBuffer( &(io->ioResultData),
				    (const unsigned char *)bytes, size );
    }

int docSetObjectName(	InsertedObject *	io,
			const char *		name,
			int			len )
    {
    char *	fresh= (char *)malloc( len+ 1 );

    if  ( ! fresh )
	{ LXDEB(len,fresh); return -1;	}

    io->ioObjectName= fresh;
    strncpy( fresh, name, len ); fresh[len]= '\0';

    return 0;
    }

int docSetObjectClass(	InsertedObject *	io,
			const char *		name,
			int			len )
    {
    char *	fresh= (char *)malloc( len+ 1 );

    if  ( ! fresh )
	{ LXDEB(len,fresh); return -1;	}

    io->ioObjectClass= fresh;
    strncpy( fresh, name, len ); fresh[len]= '\0';

    return 0;
    }

