/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>
#   include	<charnames.h>

#   include	<appUnit.h>
#   include	"docBuf.h"
#   include	"docEvalField.h"

/************************************************************************/
/*									*/
/*  Evaluate fields to merge in external data.				*/
/*									*/
/************************************************************************/

#   define	FIC_COUNT	15

/************************************************************************/
/*									*/
/*  Calculate the value for a database merge field.			*/
/*									*/
/************************************************************************/

# define MERGE_ASIS	0
# define MERGE_LOWER	1
# define MERGE_UPPER	2
# define MERGE_FIRSTCAP	3
# define MERGE_CAPS	4

int docCalculateMergefieldFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf )
    {
    FieldInstructionsComponent	fic[FIC_COUNT];
    int				n;
    unsigned char *		bytes= df->dfInstructions.mbBytes;

    int				comp;

    const unsigned char *	name;
    int				namelen= 0;

    int				format= MERGE_ASIS;

    n= docSplitFieldInstructions( &(df->dfInstructions), fic, FIC_COUNT );
    if  ( n < 1 )
	{ LDEB(n); return -1;	}
    if  ( n == 1 )
	{ LDEB(n); *pCalculated= 0; return 0;	}

    name= bytes+ fic[1].ficOffset;
    namelen= fic[1].ficSize;

    for ( comp= 2; comp < n; comp++ )
	{
	if  ( docFieldHasMergeformat( bytes, fic, n, comp ) )
	    { comp++; continue;	}

	if  ( comp < n- 1					&&
	      fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\*", 2 )	)
	    {
	    if  (  fic[comp+ 1].ficSize == 5				&&
		   ! memcmp( bytes+ fic[comp+ 1].ficOffset, "Lower", 5 ) )
		{ format= MERGE_LOWER; comp++; continue;	}

	    if  (  fic[comp+ 1].ficSize == 5				&&
		   ! memcmp( bytes+ fic[comp+ 1].ficOffset, "Upper", 5 ) )
		{ format= MERGE_UPPER; comp++; continue;	}

	    if  (  fic[comp+ 1].ficSize == 8				&&
		   ! memcmp( bytes+ fic[comp+ 1].ficOffset, "FirstCap", 8 ) )
		{ format= MERGE_FIRSTCAP; comp++; continue;	}

	    if  (  fic[comp+ 1].ficSize == 4				&&
		   ! memcmp( bytes+ fic[comp+ 1].ficOffset, "Caps", 4 ) )
		{ format= MERGE_CAPS; comp++; continue;	}
	    }

	LSDEB(comp,(char *)bytes+ fic[comp].ficOffset);
	}

    if  ( rf->rfFieldDataProvider )
	{
	int		ret= 0;
	char *		fieldName= malloc( namelen+ 1 );

	if  ( ! fieldName )
	    { XDEB(fieldName); return -1;	}
	else{
	    memcpy( fieldName, name, namelen );
	    fieldName[namelen]= '\0';

	    ret= (*rf->rfFieldDataProvider)( pCalculated, mbResult,
					    fieldName, rf->rfMergeThrough );

	    free( fieldName );
	    }

	if  ( ret )
	    { LDEB(ret); *pCalculated= 0;	}
	}
    else{ *pCalculated= 0;	}

    return 0;
    }

/*
if  ( targetSize < 1+ namelen+ 1 )
    { LLDEB(namelen,targetSize); *pCalculated= 0; return 0; }

size= 0;
target[size++]= ISO1_guillemotleft;
memcpy( target+ size, value, namelen ); size += namelen;
target[size++]= ISO1_guillemotright;
target[size]= '\0';
*/

