/************************************************************************/
/*									*/
/*  List the fonts in a document.					*/
/*  Manage resources for layout.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	"docListFonts.h"
#   include	"docParticuleData.h"
#   include	"docFind.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Recursively retrieve the list of PostScriptFonts that is used in	*/
/*  a document.								*/
/*									*/
/************************************************************************/

static int docScanParaSpans(	DocumentSelection *		ds,
				BufferItem *			paraBi,
				const BufferDocument *		bd,
				const DocumentPosition *	dpFrom,
				void *				vsdf );

static int docScanShapeSpans(	const DrawingShape *		ds,
				const BufferDocument *		bd,
				ScanDocumentFonts *		sdf )
    {
    int		rval= 0;
    int		i;

    if  ( ds->dsDocumentTree.eiRoot )
	{
	DocumentPosition	dp;

	if  ( ! docFirstPosition( &dp, ds->dsDocumentTree.eiRoot ) )
	    {
	    DocumentSelection	dsIgnored;

	    docInitDocumentSelection( &dsIgnored );

	    if  ( docFindFindNextInTree( &dsIgnored, &dp, bd,
						docScanParaSpans, sdf ) != 1 )
		{ LDEB(1); rval= -1;	}
	    }
	}

    for ( i= 0; i < ds->dsChildCount; i++ )
	{
	if  ( docScanShapeSpans( ds->dsChildren[i], bd, sdf ) )
	    { LDEB(1); rval= -1;	}
	}

    return rval;
    }

/*  a  */
static int docScanParaSpans(	DocumentSelection *		ds,
				BufferItem *			paraBi,
				const BufferDocument *		bd,
				const DocumentPosition *	dpFrom,
				void *				vsdf )
    {
    ScanDocumentFonts *		sdf= (ScanDocumentFonts *)vsdf;
    int				attributeNumber= -1;
    TextAttribute		ta;

    InsertedObject *		io;

    const TextParticule *	tp;
    int				part;

    utilInitTextAttribute( &ta );
    tp= paraBi->biParaParticules; part= 0;

    while( part < paraBi->biParaParticuleCount )
	{
	int		from;
	int		upto;

	switch( tp->tpKind )
	    {
	    case DOCkindSPAN:
	    case DOCkindTAB:
	    case DOCkindOPT_HYPH:
		from= tp->tpStroff;
		upto= tp->tpStroff+ tp->tpStrlen;
		if  ( tp->tpTextAttrNr >= 0			&&
		      tp->tpTextAttrNr != attributeNumber	)
		    {
		    utilGetTextAttributeByNumber( &ta,
					    &(bd->bdTextAttributeList),
					    tp->tpTextAttrNr );

		    attributeNumber= tp->tpTextAttrNr;
		    }

		while( part+ 1 < paraBi->biParaParticuleCount )
		    {
		    if  ( tp[1].tpKind != DOCkindSPAN	&&
			  tp[1].tpKind != DOCkindTAB	)
			{ break;	}
		    if  ( tp[1].tpTextAttrNr != attributeNumber )
			{ break;	}

		    part++; tp++;
		    }
		upto= tp->tpStroff+ tp->tpStrlen;
		part++; tp++;

		/* Do invoke the callback for empty spans! */
		if  ( (*sdf->sdfDocListSpanFont)( bd, paraBi, &ta,
						from, upto, sdf->sdfThrough ) )
		    { LLDEB(from,tp->tpStroff); return -1;	}

		break;

	    case DOCkindOBJECT:
		io= docGetObject( bd, tp->tpObjectNumber );
		if  ( ! io )
		    { LPDEB(tp->tpObjectNumber,io); return -1;	}

		if  ( sdf->sdfListObjectFonts )
		    {
		    if  ( (*sdf->sdfListObjectFonts)( io, "f",
							    sdf->sdfThrough ) )
			{ LDEB(tp->tpKind); return -1;	}
		    }

		if  ( io->ioKind == DOCokDRAWING_SHAPE			&&
		      io->ioDrawingShape				&&
		      docScanShapeSpans( io->ioDrawingShape,
							    bd, sdf )	)
		    { LDEB(1);	}

		part++; tp++; break;

	    case DOCkindFIELDSTART:
	    case DOCkindFIELDEND:
	    case DOCkindLINEBREAK:
	    case DOCkindPAGEBREAK:
	    case DOCkindCOLUMNBREAK:
	    case DOCkindCHFTNSEP:
	    case DOCkindCHFTNSEPC:
		part++; tp++; break;

	    default:
		LDEB(tp->tpKind); return -1;
	    }
	}

    return 1;
    }

int docListDocumentFonts(	BufferDocument *		bd,
				ScanDocumentFonts *		sdf )
    {
    DocumentPosition		dpBeginFrom;
    DocumentSelection		dsIgnored;
    int				res;

    /*  a  */
    if  ( docFirstDocumentPosition( &dpBeginFrom, bd ) )
	{
	docListItem( 0, bd->bdBody.eiRoot, 0 );
	LDEB(1); return -1;
	}

    res= docFindFindNextInDocument( &dsIgnored, &dpBeginFrom, bd,
						    docScanParaSpans, sdf );
    if  ( res != 1 )
	{ LDEB(res); return -1;	}

    return 0;
    }

