/************************************************************************/
/*									*/
/*  Buffer administration: manage embedded objects.			*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	"docParaString.h"
/*
#   include	"docEdit.h"
*/

/************************************************************************/
/*									*/
/*  Insert an object.							*/
/*									*/
/*  NOTE that objects have text attributes. This is for the following	*/
/*  reasons:								*/
/*  *)  The calculation of the descender height below the object.	*/
/*  *)  This makes editing around the object and saving it MUCH easier.	*/
/*									*/
/************************************************************************/

static TextParticule *	docInsertObject( BufferDocument *	bd,
					BufferItem *		paraBi,
					int			n,
					int			off,
					const TextAttribute *	ta )
    {
    TextParticule *	tp;
    InsertedObject *	io;

    int			objectNumber;
    int			textAttributeNumber;

    textAttributeNumber= docTextAttributeNumber( bd, ta );
    if  ( textAttributeNumber < 0 )
	{ LDEB(textAttributeNumber); return (TextParticule *)0;	}

    io= docClaimObject( &objectNumber, bd );
    if  ( ! io )
	{ XDEB(io); return (TextParticule *)0; }

    tp= docInsertTextParticule( paraBi, n, off, 1,
					DOCkindOBJECT, textAttributeNumber );
    if  ( ! tp )
	{
	XDEB(tp);
	docDeleteObject( bd, objectNumber );
	return tp;
	}

    tp->tpObjectNumber= objectNumber;

    return tp;
    }

TextParticule *	docAppendObject(	BufferDocument *	bd,
					BufferItem *		paraBi,
					const TextAttribute *	ta )
    {
    TextParticule *	tp;
    int			stroffShift= 0;
    int			off= docParaStrlen( paraBi );

    if  ( docParaStringReplace( &stroffShift, paraBi, off, off, " ", 1 ) )
	{ LLDEB(docParaStrlen(paraBi),1); return (TextParticule *)0; }

    tp= docInsertObject( bd, paraBi, -1, off, ta );
    if  ( ! tp )
	{ LDEB(paraBi->biParaParticuleCount); return tp;	}

    return tp;
    }

/************************************************************************/
/*									*/
/*  Close the objects in a buffer item.					*/
/*									*/
/************************************************************************/

static void docCleanParaObjects(	int *			pBulletsDeleted,
					DocumentTree *		ei,
					BufferDocument *	bd,
					BufferItem *		paraBi,
					DOC_CLOSE_OBJECT	closeObject )
    {
    int			part;
    TextParticule *	tp;

    tp= paraBi->biParaParticules;
    for ( part= 0; part < paraBi->biParaParticuleCount; tp++, part++ )
	{
	if  ( tp->tpKind == DOCkindOBJECT )
	    { (*closeObject)( bd, tp );	}
	}

    if  ( paraBi->biParaListOverride > 0			||
	  paraBi->biParaOutlineLevel < PPoutlineBODYTEXT	)
	{
	if  ( docRemoveParagraphFromList( paraBi, ei, bd ) )
	    { LDEB(1);	}

	if  ( paraBi->biParaListOverride > 0 )
	    { (*pBulletsDeleted)++;	}
	}

    return;
    }

void docCleanExternalItemObjects(
				int *			pBulletsDeleted,
				int *			pParagraphCount,
				DocumentTree *		ei,
				BufferDocument *	bd,
				DOC_CLOSE_OBJECT	closeObject )
    {
    if  ( ei->eiRoot )
	{
	docCleanItemObjects( pBulletsDeleted, pParagraphCount,
				ei, bd, ei->eiRoot, closeObject );
	}
    }

void docCleanItemObjects(	int *			pBulletsDeleted,
				int *			pParagraphCount,
				DocumentTree *		ei,
				BufferDocument *	bd,
				BufferItem *		bi,
				DOC_CLOSE_OBJECT	closeObject )
    {
    int		i;

    switch( bi->biLevel )
	{
	case DOClevBODY:
	case DOClevROW:
	case DOClevCELL:
	    for ( i= 0; i < bi->biChildCount; i++ )
		{
		docCleanItemObjects( pBulletsDeleted,
						    pParagraphCount,
						    ei, bd, bi->biChildren[i],
						    closeObject );
		}
	    break;

	case DOClevSECT:
	    docCleanExternalItemObjects( pBulletsDeleted, pParagraphCount,
					    &(bi->biSectFirstPageHeader),
					    bd, closeObject );

	    docCleanExternalItemObjects( pBulletsDeleted, pParagraphCount,
					    &(bi->biSectLeftPageHeader),
					    bd, closeObject );

	    docCleanExternalItemObjects( pBulletsDeleted, pParagraphCount,
					    &(bi->biSectRightPageHeader),
					    bd, closeObject );

	    docCleanExternalItemObjects( pBulletsDeleted, pParagraphCount,
					    &(bi->biSectFirstPageFooter),
					    bd, closeObject );

	    docCleanExternalItemObjects( pBulletsDeleted, pParagraphCount,
					    &(bi->biSectLeftPageFooter),
					    bd, closeObject );

	    docCleanExternalItemObjects( pBulletsDeleted, pParagraphCount,
					    &(bi->biSectRightPageFooter),
					    bd, closeObject );

	    for ( i= 0; i < bi->biChildCount; i++ )
		{
		docCleanItemObjects( pBulletsDeleted, pParagraphCount,
						    ei, bd, bi->biChildren[i],
						    closeObject );
		}
	    break;


	case DOClevPARA:
	    docCleanParaObjects( pBulletsDeleted,
					ei, bd, bi, closeObject );
	    (*pParagraphCount)++;
	    break;

	default:
	    LDEB(bi->biLevel); return;
	}

    return;
    }

void docCleanDocumentObjects(	BufferDocument *	bd,
				DOC_CLOSE_OBJECT	closeObject )
    {
    int		bulletsDeleted= 0;
    int		paragraphCount= 0;

    docCleanExternalItemObjects( &bulletsDeleted, &paragraphCount,
				    &(bd->bdBody), bd, closeObject );

    docCleanExternalItemObjects( &bulletsDeleted, &paragraphCount,
				    &(bd->bdEiFtnsep), bd, closeObject );

    docCleanExternalItemObjects( &bulletsDeleted, &paragraphCount,
				    &(bd->bdEiFtnsepc), bd, closeObject );

    docCleanExternalItemObjects( &bulletsDeleted, &paragraphCount,
				    &(bd->bdEiFtncn), bd, closeObject );

    docCleanExternalItemObjects( &bulletsDeleted, &paragraphCount,
				    &(bd->bdEiAftnsep), bd, closeObject );

    docCleanExternalItemObjects( &bulletsDeleted, &paragraphCount,
				    &(bd->bdEiAftnsepc), bd, closeObject );

    docCleanExternalItemObjects( &bulletsDeleted, &paragraphCount,
				    &(bd->bdEiAftncn), bd, closeObject );

    return;
    }
