/************************************************************************/
/*									*/
/*  Evaluate an 'IncludePicture' field.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appSystem.h>
#   include	"docBuf.h"
#   include	"docEvalField.h"

#   include	<appDebugon.h>

#   define	FIC_COUNT	15

/************************************************************************/
/*									*/
/*  Extract an INCLUDEPICTURE field.					*/
/*									*/
/************************************************************************/

static int docFieldGetIncludePicture(
				const DocumentField *	df,
				const char **		pFileName,
				int *			pFileSize )
    {
    FieldInstructionsComponent	fic[FIC_COUNT];
    int				n;
    int				comp;
    unsigned char *		bytes= df->dfInstructions.mbBytes;

    char *			fileName= (char *)0;
    int				fileSize= 0;

    if  ( df->dfKind != DOCfkINCLUDEPICTURE )
	{ return -1;	}

    n= docSplitFieldInstructions( &(df->dfInstructions), fic, FIC_COUNT );
    if  ( n < 2 )
	{ LDEB(n); return -1;	}

    comp= 0;
    if  ( fic[comp].ficSize != 14					||
	  memcmp( bytes+ fic[comp].ficOffset, "INCLUDEPICTURE", 14 )	)
	{ SDEB((char *)bytes); return -1;	}
    comp++;

    fileName= (char *)bytes+ fic[comp].ficOffset;
    fileSize= fic[comp].ficSize;
    comp++;

    while( comp < n )
	{
	if  ( docFieldHasMergeformat( bytes, fic, n, comp ) )
	    { comp += 2; continue;	}

	if  ( fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\d", 2 )	)
	    { comp++; continue;	}

	LSDEB(comp,(char *)bytes+ fic[comp].ficOffset); comp++;
	}

    *pFileName= fileName;
    *pFileSize= fileSize;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Evaluate an 'INCLUDEPICTURE' field.					*/
/*									*/
/************************************************************************/

int docRecalculateIncludePictureField(
				int *				pCalculated,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			paraBi,
				int				part,
				int				partCount,
				DocumentField *			df,
				const RecalculateFields *	rf )
    {
    const DocumentProperties *		dp= &(rf->rfBd->bdProperties);

    TextParticule *			tp;

    InsertedObject *			io;
    int					objectNumber;

    int					oldPartCount= paraBi->biParaParticuleCount;
    int					oldStrlen= docParaStrlen( paraBi );
    int					stroff;

    int					stroffShift= 0;

    const char *			fileName;
    int					fileSize;

    int					fullNameLen= 0;
    char				fullName[1000+1];
    int					textAttributeNumber;
    int					res= -1;

    tp= paraBi->biParaParticules+ part+ 1;

    if  ( partCount == 1		&&
	  tp->tpKind == DOCkindOBJECT	)
	{ *pCalculated= 0; return 0; }

    if  ( docFieldGetIncludePicture( df, &fileName, &fileSize ) )
	{ LDEB(1); return -1;	}

    if  ( fileSize < 1 )
	{ LDEB(fileSize); *pCalculated= 0; return 0; }

    {
    char *	scratch= malloc( fileSize+ 1 );

    if  ( ! scratch )
	{ XDEB(scratch); fullNameLen= -1;	}
    else{
	const int	relativeIsFile= 1;

	strncpy( scratch, fileName, fileSize )[fileSize]= '\0';

	fullNameLen= appAbsoluteName( fullName, sizeof(fullName)-1, scratch,
				relativeIsFile, (const char *)dp->dpFilename );
	free( scratch );
	}

    if  ( fullNameLen < 0 )
	{ LDEB(fullNameLen); *pCalculated= 0; return 0; }
    }

    io= docClaimObject( &objectNumber, rf->rfBd );
    if  ( ! io )
	{ XDEB(io); return -1;	}

    res= docReadFileObject( fullName, fullNameLen, io );
    
    if  ( res )
	{
	docDeleteObject( rf->rfBd, objectNumber );

	if  ( docFieldReplaceContents( &stroff,
		&stroffShift, &textAttributeNumber, paraBi, part, partCount,
				*pStroffShift, fullName, fullNameLen, rf ) )
	    { LDEB(1); return -1;	}

	tp= docInsertTextParticule( paraBi, part+ 1, stroff, fullNameLen,
				    DOCkindSPAN, textAttributeNumber );
	if  ( ! tp )
	    { XDEB(tp); return -1;	}
	}
    else{
	if  ( docFieldReplaceContents( &stroff,
			&stroffShift, &textAttributeNumber,
			paraBi, part, partCount,
			*pStroffShift, " ", 1, rf ) )
	    { LDEB(1); return -1;	}

	tp= docInsertTextParticule( paraBi, part+ 1, stroff, 1,
				    DOCkindOBJECT, textAttributeNumber );
	if  ( ! tp )
	    { XDEB(tp); return -1;	}

	tp->tpObjectNumber= objectNumber;
	}

  /*ready:*/

    *pCalculated= 1;
    *pPartShift= paraBi->biParaParticuleCount- oldPartCount;
    *pStroffShift= docParaStrlen( paraBi )- oldStrlen;
    return 0;
    }

