/************************************************************************/
/*									*/
/*  Calculate 'Hyperlink' fields.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	"docEdit.h"
#   include	"docEvalField.h"

#   define	FIC_COUNT	15

/************************************************************************/
/*									*/
/*  Evaluate a 'HYPERLINK' field.					*/
/*									*/
/*  Just make the contents blue as a compatibility hack with previous	*/
/*  versions.								*/
/*									*/
/************************************************************************/

int docRecalculateHyperlinkField(
				int *				pCalculated,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			paraBi,
				int				partFrom,
				int				partCount,
				DocumentField *			df,
				const RecalculateFields *	rf )
    {
    const int				partUpto= partFrom+ partCount+ 2;

    TextAttribute			taSet;
    PropertyMask			taSetMask;
    PropertyMask			taDoneMask;

    DocumentProperties *		dp= &(rf->rfBd->bdProperties);
    int					blue;
    RGB8Color				rgb8Blue;

    if  ( ! getenv( "TED_HYPERLINKS_BLUE" ) )
	{ *pCalculated= 0; return 0;	}

    docPlainTextAttribute( &taSet, rf->rfBd );
    utilPropMaskClear( &taSetMask );
    utilPropMaskClear( &taDoneMask );

    bmInitRGB8Color( &rgb8Blue );
    rgb8Blue.rgb8Red= 0;
    rgb8Blue.rgb8Green= 0;
    rgb8Blue.rgb8Blue= 255;

    blue= docAllocateDocumentColor( dp, &rgb8Blue );
    if  ( blue < 0 )
	{ LDEB(blue); return -1;	}

    taSet.taTextColorNumber= blue;
    taSet.taTextIsUnderlined= 1;
    PROPmaskADD( &taSetMask, TApropTEXT_COLOR );
    PROPmaskADD( &taSetMask, TApropTEXTUNDERLINED );

    if  ( docChangeParticuleAttributes( &taDoneMask, rf->rfBd,
						paraBi, partFrom, partUpto,
						&taSet, &taSetMask ) )
	{ LDEB(1); return -1;	}

    if  ( utilPropMaskIsEmpty( &taDoneMask ) )
	{ *pCalculated= 0;	}
    else{ *pCalculated= 1;	}

    /*
    *pPartShift += 0;
    *pStroffShift += 0;
    */

    return 0;
    }

/************************************************************************/

void docMakeHyperlinkRelative(	DocumentField *		dfTo,
				const char *		refFileName,
				int			refFileSize )
    {
    const char *	fileName;
    int			fileSize;
    const char *	markName;
    int			markSize;

    if  ( ! docFieldGetHyperlink( dfTo, &fileName, &fileSize,
						&markName, &markSize )	&&
	  fileSize == refFileSize 					&&
	  markSize > 0							&&
	  ! strncmp( fileName, refFileName, fileSize )			)
	{
	char *		copy= (char *)malloc( markSize+ 1 );

	if  ( ! copy )
	    { XDEB(copy);	}
	else{
	    strncpy( copy, markName, markSize )[markSize]= '\0';

	    if  ( docFieldSetHyperlink( dfTo, (char *)0, 0, copy, markSize ) )
		{ SDEB(copy);	}

	    free( copy );
	    }
	}
    }

/************************************************************************/

int docFieldSetHyperlink(	DocumentField *		df,
				const char *		file,
				int			fileSize,
				const char *		markName,
				int			markSize )
    {
    int			size;
    char *		fresh;
    char *		to;

    size= 11;
    if  ( fileSize > 0 )
	{ size += 1+ fileSize+ 2;	}
    if  ( markName )
	{ size += 4+ markSize+ 2;	}

    fresh= to= (char *)malloc( size+ 1 );
    if  ( ! fresh )
	{ LXDEB(size,fresh); return -1;	}

    strcpy( to, " HYPERLINK " ); to += strlen( to );
    if  ( fileSize > 0 )
	{
	*(to++)= '"';
	memcpy( to, file, fileSize ); to += fileSize;
	strcpy( to, "\" " ); to += strlen( to );
	}

    if  ( markSize > 0 )
	{
	strcpy( to, "\\l \"" ); to += strlen( to );
	memcpy( to, markName, markSize ); to += markSize;
	strcpy( to, "\" " ); to += strlen( to );
	}

    size= strlen( fresh );

    if  ( docSetFieldInst( df, fresh, size ) )
	{ LDEB(size); free( fresh ); return -1;	}

    df->dfKind= DOCfkHYPERLINK;
    free( fresh ); return 0;
    }

/************************************************************************/
/*									*/
/*  Extract the destination from a hyperlink field.			*/
/*									*/
/*  Return the file name and the bookmark.				*/
/*  The strings are NOT '\0' terminated.				*/
/*									*/
/************************************************************************/

int docFieldGetHyperlink(	const DocumentField *	df,
				const char **		pFileName,
				int *			pFileSize,
				const char **		pMarkName,
				int *			pMarkSize )
    {
    FieldInstructionsComponent	fic[FIC_COUNT];
    int				n;
    int				comp;
    unsigned char *		bytes= df->dfInstructions.mbBytes;

    char *			fileName= (char *)0;
    int				fileSize= 0;
    char *			markName= (char *)0;
    int				markSize= 0;

    if  ( df->dfKind != DOCfkHYPERLINK )
	{ return -1;	}

    n= docSplitFieldInstructions( &(df->dfInstructions), fic, FIC_COUNT );
    if  ( n < 2 )
	{ LDEB(n); return -1;	}

    comp= 0;
    if  ( fic[comp].ficSize != 9					||
	  memcmp( bytes+ fic[comp].ficOffset, "HYPERLINK", 9 )	)
	{ SDEB((char *)bytes); return -1;	}
    comp++;

    if  ( fic[comp].ficSize > 0				&&
	  ( fic[comp].ficSize != 2		||
	    bytes[fic[comp].ficOffset] != '\\'	)	)
	{
	fileName= (char *)bytes+ fic[comp].ficOffset;
	fileSize= fic[comp].ficSize;
	comp++;
	}

    while( comp < n )
	{
	if  ( fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\o", 2 )	&&
	      comp < n- 1					)
	    {
	    /*
	    fontName= (char *)bytes+ fic[comp+ 1].ficOffset;
	    fontSize= fic[comp+ 1].ficSize;
	    */
	    comp += 2; continue;
	    }

	if  ( comp < n						&&
	      fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\l", 2 )	)
	    {
	    if  ( comp >= n )
		{ LLDEB(comp,n); return -1;	}

	    markName= (char *)bytes+ fic[comp+ 1].ficOffset;
	    markSize= fic[comp+ 1].ficSize;

	    comp += 2; continue;
	    }

	break;
	}

    while( comp < n )
	{ LSDEB(comp,(char *)bytes+ fic[comp].ficOffset); comp++; }

    *pFileName= fileName;
    *pFileSize= fileSize;
    *pMarkName= markName;
    *pMarkSize= markSize;
    return 0;
    }

