/************************************************************************/
/*									*/
/*  Get headers and footers for a certain page/position.		*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Determine what header/footer applies for a certain page.		*/
/*									*/
/************************************************************************/

static int docCheckItemIsEmpty(	int *			pIsEmpty,
				const BufferDocument *	bd,
				const DocumentTree *	ei )
    {
    int			isEmpty= 1;

    if  ( ei && ei->eiRoot )
	{
	DocumentPosition		dpBegin;
	DocumentPosition		dpNext;

	const NumberedPropertiesList *	bpl= &(bd->bdBorderPropertyList);
	const NumberedPropertiesList *		isl= &(bd->bdItemShadingList);

	if  ( docFirstPosition( &dpBegin, ei->eiRoot ) )
	    { LDEB(1); docInitDocumentPosition( &dpBegin );	}

	dpNext= dpBegin;
	if  ( ! docNextPosition( &dpNext ) )
	    { isEmpty= 0;	}
	else{
	    const ParagraphProperties *	pp= &(dpBegin.dpBi->biParaProperties);

	    if  ( pp->ppTableNesting > 0 )
		{ isEmpty= 0;	}

	    if  ( docBorderNumberIsBorder( bpl, pp->ppTopBorderNumber ) )
		{ isEmpty= 0;	}
	    if  ( docBorderNumberIsBorder( bpl, pp->ppBottomBorderNumber ) )
		{ isEmpty= 0;	}
	    if  ( docBorderNumberIsBorder( bpl, pp->ppLeftBorderNumber ) )
		{ isEmpty= 0;	}
	    if  ( docBorderNumberIsBorder( bpl, pp->ppRightBorderNumber ) )
		{ isEmpty= 0;	}
	    if  ( docBorderNumberIsBorder( bpl, pp->ppBetweenBorderNumber ) )
		{ isEmpty= 0;	}
	    if  ( docBorderNumberIsBorder( bpl, pp->ppBarNumber ) )
		{ isEmpty= 0;	}

	    if  ( docShadingNumberIsShading( isl, pp->ppShadingNumber ) )
		{ isEmpty= 0;	}
	    }
	}

    *pIsEmpty= isEmpty;
    return 0;
    }

int docWhatPageHeader(	DocumentTree **		pEi,
			int *			pIsEmpty,
			BufferItem *		bodySectBi,
			int			page,
			const BufferDocument *	bd )
    {
    const DocumentProperties *	dp= &(bd->bdProperties);
    const SectionProperties *	sp= &(bodySectBi->biSectProperties);

    if  ( page == bodySectBi->biTopPosition.lpPage && sp->spHasTitlePage )
	{
	*pEi= &(bodySectBi->biSectFirstPageHeader);
	docCheckItemIsEmpty( pIsEmpty, bd, *pEi );
	return DOCinFIRST_HEADER;
	}

    if  ( page % 2 && dp->dpHasFacingPages )
	{
	*pEi= &(bodySectBi->biSectLeftPageHeader);
	docCheckItemIsEmpty( pIsEmpty, bd, *pEi );
	return DOCinLEFT_HEADER;
	}
    else{
	*pEi= &(bodySectBi->biSectRightPageHeader);
	docCheckItemIsEmpty( pIsEmpty, bd, *pEi );
	return DOCinRIGHT_HEADER;
	}
    }

int docWhatPageFooter(	DocumentTree **		pEi,
			int *			pIsEmpty,
			BufferItem *		bodySectBi,
			int			page,
			const BufferDocument *	bd )
    {
    const DocumentProperties *	dp= &(bd->bdProperties);
    const SectionProperties *	sp= &(bodySectBi->biSectProperties);

    if  ( page == bodySectBi->biTopPosition.lpPage && sp->spHasTitlePage )
	{
	*pEi= &(bodySectBi->biSectFirstPageFooter);
	docCheckItemIsEmpty( pIsEmpty, bd, *pEi );
	return DOCinFIRST_FOOTER;
	}

    if  ( page % 2 && dp->dpHasFacingPages )
	{
	*pEi= &(bodySectBi->biSectLeftPageFooter);
	docCheckItemIsEmpty( pIsEmpty, bd, *pEi );
	return DOCinLEFT_FOOTER;
	}
    else{
	*pEi= &(bodySectBi->biSectRightPageFooter);
	docCheckItemIsEmpty( pIsEmpty, bd, *pEi );
	return DOCinRIGHT_FOOTER;
	}
    }

int docWhatPagesForHeaderFooter( const DocumentProperties *	dp,
				const SectionProperties *	sp,
				int				which )
    {
    switch( which )
	{
	case DOCinFIRST_HEADER:
	case DOCinFIRST_FOOTER:
	    return PAGES_FIRST_PAGE;

	case DOCinLEFT_HEADER:
	case DOCinLEFT_FOOTER:
	    return PAGES_EVEN_PAGES;

	case DOCinRIGHT_HEADER:
	case DOCinRIGHT_FOOTER:
	    if  ( dp->dpHasFacingPages )
		{ return PAGES_ODD_PAGES;		}
	    else{
		if  ( sp->spHasTitlePage )
		    { return PAGES_SUBSEQUENT_PAGES;	}
		else{ return PAGES_ALL_PAGES;		}
		}
	    /*unreachable*/

	default:
	    LDEB(which);
	    return -1;
	}
    }

/************************************************************************/
/*									*/
/*  Return a particular header or footer by scope.			*/
/*									*/
/************************************************************************/

DocumentTree *	docSectionHeaderFooter(	BufferItem *		bodySectBi,
					int			which )
    {
    switch( which )
	{
	case DOCinBODY:
	    LDEB(which); return (DocumentTree *)0;

	case DOCinFIRST_HEADER:
	    return &(bodySectBi->biSectFirstPageHeader);

	case DOCinLEFT_HEADER:
	    return &(bodySectBi->biSectLeftPageHeader);

	case DOCinRIGHT_HEADER:
	    return &(bodySectBi->biSectRightPageHeader);

	case DOCinFIRST_FOOTER:
	    return &(bodySectBi->biSectFirstPageFooter);

	case DOCinLEFT_FOOTER:
	    return &(bodySectBi->biSectLeftPageFooter);

	case DOCinRIGHT_FOOTER:
	    return &(bodySectBi->biSectRightPageFooter);

	default:
	    LDEB(which); return (DocumentTree *)0;
	}
    }

/************************************************************************/
/*									*/
/*  Return the first page where a particular kind of header/footer can	*/
/*  be used in a document. The existence of the item is checked by the	*/
/*  caller.								*/
/*									*/
/************************************************************************/

int docSectionHeaderFooterFirstPage(
				int *				pUsedByDocument,
				const BufferItem *		bodySectBi,
				int				which,
				const DocumentProperties *	dp )
    {
    const SectionProperties *	sp= &(bodySectBi->biSectProperties);
    int				topPage= bodySectBi->biTopPosition.lpPage;
    int				belowPage= bodySectBi->biBelowPosition.lpPage;
    int				page;

    const BufferItem *		prevBi= (const BufferItem *)0;

    if  ( bodySectBi->biNumberInParent > 0 )
	{
	prevBi= bodySectBi->biParent->biChildren[
					    bodySectBi->biNumberInParent- 1];

	if  ( prevBi->biBelowPosition.lpPage >= belowPage )
	    { *pUsedByDocument= 0; return -1;	}
	}

    switch( which )
	{
	case DOCinBODY:
	    LDEB(which); *pUsedByDocument= 0; return -1;

	case DOCinFIRST_HEADER:
	case DOCinFIRST_FOOTER:
	    if  ( ! sp->spHasTitlePage )
		{ *pUsedByDocument= 0; return -1;	}

	    if  ( prevBi && prevBi->biBelowPosition.lpPage >= topPage )
		{ *pUsedByDocument= 0; return topPage;
		}
	    page= topPage;
	    break;

	case DOCinLEFT_HEADER:
	case DOCinLEFT_FOOTER:
	    if  ( ! dp->dpHasFacingPages )
		{ *pUsedByDocument= 0; return -1;	}
	    if  ( topPage % 2 )
		{
		if  ( sp->spHasTitlePage )
		    { page= topPage+ 2;	}
		else{ page= topPage;	}
		}
	    else{ page= topPage+ 1;	}
	    break;

	case DOCinRIGHT_HEADER:
	case DOCinRIGHT_FOOTER:
	    if  ( dp->dpHasFacingPages )
		{
		if  ( topPage % 2 == 0 )
		    {
		    if  ( sp->spHasTitlePage )
			{ page= topPage+ 2;	}
		    else{ page= topPage;	}
		    }
		else{ page= topPage+ 1;	}
		}
	    else{
		if  ( sp->spHasTitlePage )
		    { page= topPage+ 1;	}
		else{ page= topPage;	}
		}
	    break;

	default:
	    LDEB(which); *pUsedByDocument= 0; return -1;
	}

    *pUsedByDocument= page <= bodySectBi->biBelowPosition.lpPage;

    return page;
    }

/************************************************************************/
/*									*/
/*  Return a particular separator for an annotation by scope.		*/
/*									*/
/************************************************************************/

DocumentTree *	docDocumentNoteSeparator(
					BufferDocument *	bd,
					int			which )
    {
    switch( which )
	{
	case DOCinFTNSEP:
	    return &(bd->bdEiFtnsep);

	case DOCinFTNSEPC:
	    return &(bd->bdEiFtnsepc);

	case DOCinFTNCN:
	    return &(bd->bdEiFtncn);

	case DOCinAFTNSEP:
	    return &(bd->bdEiAftnsep);

	case DOCinAFTNSEPC:
	    return &(bd->bdEiAftnsepc);

	case DOCinAFTNCN:
	    return &(bd->bdEiAftncn);

	default:
	    LDEB(which); return (DocumentTree *)0;
	}
    }

/************************************************************************/
/*									*/
/*  Get the external item that an item is contained in.			*/
/*									*/
/************************************************************************/

int docGetRootOfSelectionScope(	DocumentTree **		pEi,
				BufferItem **		pBodySectBi,
				BufferDocument *	bd,
				const SelectionScope *	ss )
    {
    const DocumentFieldList *	dfl= &(bd->bdFieldList);
    const int			fieldCount= dfl->dflPagedList.plItemCount;
    BufferItem *		bodySectBi;
    DocumentTree *		ei;

    DocumentField *		dfNote;
    DocumentNote *		dn;

    switch( ss->ssInExternalItem )
	{
	case DOCinBODY:
	    bodySectBi= docGetBodySectBiOfScope( ss, bd );
	    ei= &(bd->bdBody);
	    break;

	case DOCinFIRST_HEADER:
	case DOCinLEFT_HEADER:
	case DOCinRIGHT_HEADER:

	case DOCinFIRST_FOOTER:
	case DOCinLEFT_FOOTER:
	case DOCinRIGHT_FOOTER:
	    bodySectBi= docGetBodySectBiOfScope( ss, bd );
	    if  ( ! bodySectBi )
		{ XDEB(bodySectBi); return -1;	}

	    ei= docSectionHeaderFooter( bodySectBi, ss->ssInExternalItem );
	    if  ( ! ei )
		{ LXDEB(ss->ssInExternalItem,ei); return -1;	}

	    break;

	case DOCinFOOTNOTE:
	case DOCinENDNOTE:
	    if  ( ss->ssOwnerNumber < 0			||
		  ss->ssOwnerNumber >= fieldCount	)
		{
		LLDEB(ss->ssOwnerNumber,fieldCount);
		return -1;
		}
	    dfNote= docGetFieldByNumber( &(bd->bdFieldList),
							ss->ssOwnerNumber );
	    dn= docGetNoteOfField( dfNote, bd );
	    ei= &(dn->dnDocumentTree);

	    bodySectBi= docGetBodySectBiOfScope( ss, bd );
	    if  ( ! bodySectBi )
		{ XDEB(bodySectBi); return -1;	}
	    break;

	case DOCinFTNSEP:
	case DOCinFTNSEPC:
	case DOCinFTNCN:
	case DOCinAFTNSEP:
	case DOCinAFTNSEPC:
	case DOCinAFTNCN:
	    ei= docDocumentNoteSeparator( bd, ss->ssInExternalItem );
	    if  ( ! ei )
		{ LXDEB(ss->ssInExternalItem,ei); return -1;	}
	    bodySectBi= (BufferItem *)0;
	    /* HACK */
	    if  ( bd->bdBody.eiRoot->biChildCount > 0 )
		{ bodySectBi= bd->bdBody.eiRoot->biChildren[0];	}
	    break;

	case DOCinSHPTXT:
	    bodySectBi= docGetBodySectBiOfScope( ss, bd );
	    if  ( ! bodySectBi )
		{ XDEB(bodySectBi); return -1;	}
	    {
	    DrawingShape *	ds;

	    ds= docGetShapeByNumber( &(bd->bdShapeList), ss->ssOwnerNumber );
	    if  ( ! ds )
		{ LPDEB(ss->ssOwnerNumber,ds); return -1;	}
	    ei= &(ds->dsDocumentTree);
	    }
	    break;

	default:
	    LDEB(ss->ssInExternalItem);
	    return -1;
	}

    *pEi= ei;
    *pBodySectBi= bodySectBi;

    return 0;
    }

int docGetRootForItem(		DocumentTree **		pEi,
				BufferItem **		pBodySectBi,
				BufferDocument *	bd,
				BufferItem *		bi )
    {
    BufferItem *	selSectBi;
    BufferItem *	bodySectBi= (BufferItem *)0;
    DocumentTree *	ei;
    SelectionScope *	ss;

    if  ( bi->biLevel == DOClevBODY && bi->biChildCount > 0 )
	{ selSectBi= bi->biChildren[0];	}
    else{
	bi= docGetSectItem( bi );
	if  ( ! bi )
	    { XDEB(bi); return -1;	}

	selSectBi= bi;
	}

    ss= &(selSectBi->biSectSelectionScope);

    if  ( docGetRootOfSelectionScope( &ei, &bodySectBi, bd, ss ) )
	{ LDEB(1); return -1;	}

    if  ( ss->ssInExternalItem == DOCinBODY )
	{ bodySectBi= selSectBi;	}

    *pEi= ei;
    *pBodySectBi= bodySectBi;

    return 0;
    }

/************************************************************************/
/*									*/
/*  What BufferItem is the common root of the selection.		*/
/*									*/
/************************************************************************/

BufferItem * docGetSelectionRoot(
			DocumentTree **			pEi,
			BufferItem **			pBodySectBi,
			BufferDocument *		bd,
			const DocumentSelection *	ds )
    {
    BufferItem *	bi1= ds->dsHead.dpBi;
    BufferItem *	bi2= ds->dsTail.dpBi;

    DocumentTree *	ei= (DocumentTree *)0;
    BufferItem *	selRootBi= (BufferItem *)0;
    BufferItem *	bodySectBi= (BufferItem *)0;

    if  ( ! bi1 || ! bi2 )
	{ XXDEB(bi1,bi2); return (BufferItem *)0;	}

    while( bi1 && bi1->biLevel > bi2->biLevel )
	{ bi1= bi1->biParent;	}

    if  ( ! bi1 )
	{
	XDEB(bi1);
	LLDEB(ds->dsHead.dpBi->biLevel,ds->dsTail.dpBi->biLevel);
	/* should be impossible: simply crash below! */
	}

    while( bi2 && bi2->biLevel > bi1->biLevel )
	{ bi2= bi2->biParent;	}

    while( bi1					&&
	   bi2					&&
	   bi1 != bi2				)
	{ bi1= bi1->biParent; bi2= bi2->biParent; }

    if  ( ! bi1 || ! bi2 )
	{ XXDEB(bi1,bi2); return (BufferItem *)0;	}

    selRootBi= bi1;

    if  ( docGetRootForItem( &ei, &bodySectBi, bd, bi1 ) )
	{ LDEB(1); return (BufferItem *)0;	}

    if  ( pEi )
	{ *pEi= ei;			}
    if  ( pBodySectBi )
	{ *pBodySectBi= bodySectBi;	}

    return selRootBi;
    }

/************************************************************************/
/*									*/
/*  Return the Header/Footer corrsponding to 'which'. If the selection	*/
/*  itself is in an external item, go to the section in the body to	*/
/*  get the header or footer.						*/
/*									*/
/************************************************************************/

int docGetHeaderFooter(		DocumentTree **			pEi,
				BufferItem **			pBodySectBi,
				const DocumentSelection *	ds,
				BufferDocument *		bd,
				int				which )
    {
    DocumentTree *	eiDs;
    DocumentTree *	eiHdFt;
    BufferItem *	bodySectBi;

    if  ( docGetRootForItem( &eiDs, &bodySectBi, bd, ds->dsHead.dpBi ) )
	{ LDEB(1); return -1;	}

    eiHdFt= docSectionHeaderFooter( bodySectBi, which );
    if  ( ! eiHdFt )
	{ XDEB(eiHdFt); return -1;	}

    *pEi= eiHdFt; *pBodySectBi= bodySectBi; return 0;
    }

/************************************************************************/
/*									*/
/*  Determine whether that document has headers and footers at all.	*/
/*									*/
/************************************************************************/

int docInquireHeadersFooters(	int *			pDocHasHeaders,
				int *			pDocHasFooters,
				const BufferItem *	bodyBi )
    {
    int			i;
    int			hasPageHeader= 0;
    int			hasPageFooter= 0;

    for ( i= 0; i < bodyBi->biChildCount; i++ )
	{
	int			j;
	BufferItem *		sectBi= bodyBi->biChildren[i];

	for ( j= 0; j < PAGES__COUNT; j++ )
	    {
	    DocumentTree *	ei;

	    ei= docSectionHeaderFooter( sectBi, DOC_HeaderScopes[j] );
	    if  ( ei && ei->eiRoot )
		{ hasPageHeader= 1;	}

	    ei= docSectionHeaderFooter( sectBi, DOC_FooterScopes[j] );
	    if  ( ei && ei->eiRoot )
		{ hasPageFooter= 1;	}
	    }
	}

    *pDocHasHeaders= hasPageHeader;
    *pDocHasFooters= hasPageFooter;
    return 0;
    }
