/************************************************************************/
/*									*/
/*  Ted: Manipulation of font and text attributes.			*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"docBuf.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Get font properties of the current position.			*/
/*									*/
/************************************************************************/

static void docGetPositionAttributes(
				const BufferDocument *		bd,
				const TextParticule *		tp,
				PropertyMask *			pUpdMask,
				TextAttribute *			pTaNew )
    {
    TextAttribute		ta;

    utilGetTextAttributeByNumber( &ta, &(bd->bdTextAttributeList),
							    tp->tpTextAttrNr );

    *pTaNew= ta;

    utilPropMaskClear( pUpdMask );
    utilPropMaskFill( pUpdMask, TAprop_COUNT );

    return;
    }

/************************************************************************/
/*									*/
/*  Get the common text properties of the current selection.		*/
/*									*/
/*  1)  Get the last particule number for the beginning of the 		*/
/*	selection.							*/
/*  2)  If the paragraph is part of a list, exclude the bullet from	*/
/*	the selection.							*/
/*									*/
/************************************************************************/

void docGetSelectionAttributes(	BufferDocument *		bd,
				const DocumentSelection *	ds,
				PropertyMask *			pUpdMask,
				TextAttribute *			pTaNew )
    {
    BufferItem *		paraBi;
    int				part;
    const TextParticule *	tp;

    TextAttribute		taNew;
    PropertyMask		updMask;

    int				bulletPartBegin= -1;
    int				bulletPartEnd= -1;

    int				returnBullet= 0;

    paraBi= ds->dsHead.dpBi;

    /*  1  */
    {
    const int			lastOne= 1;

    if  ( docFindParticuleOfPosition( &part, &(ds->dsHead), lastOne ) )
	{
	LDEB(ds->dsHead.dpStroff);
	utilPropMaskClear( pUpdMask );
	return;
	}
    }

    /*  2  */
    if  ( paraBi->biParaListOverride > 0 )
	{
	DocumentField *		dfBullet= (DocumentField *)0;
	DocumentSelection	dsInsideBullet;
	DocumentSelection	dsAroundBullet;

	if  ( docDelimitParaHeadField( &dfBullet,
					&dsInsideBullet, &dsAroundBullet,
					&bulletPartBegin, &bulletPartEnd,
					paraBi, bd ) )
	    { LDEB(1);	}

	if  ( part <= bulletPartEnd )
	    {
	    if  ( ! docSelectionInsideParagraph( ds )			||
		  ds->dsTail.dpStroff >= dsAroundBullet.dsTail.dpStroff	)
		{ part= bulletPartEnd+ 1;	}
	    else{ returnBullet= 1;		}
	    }
	}

    tp= paraBi->biParaParticules+ part;

    docGetPositionAttributes( bd, tp, &updMask, &taNew );

    if  ( docIsIBarSelection( ds ) || returnBullet )
	{
	*pUpdMask= updMask;
	*pTaNew= taNew;
	return;
	}

    utilPropMaskClear( &updMask );

    for (;;)
	{
	int	col;

	col= paraBi->biParent->biNumberInParent;

	if  ( ds->dsCol0 < 0					||
	      ds->dsCol1 < 0					||
	      ( col >= ds->dsCol0 && col <= ds->dsCol1 )	)
	    {
	    while( part < paraBi->biParaParticuleCount )
		{
		PropertyMask	pm;
		PropertyMask	pmAll;

		TextAttribute	ta;

		if  ( paraBi == ds->dsTail.dpBi			&&
		      tp->tpStroff >= ds->dsTail.dpStroff	)
		    { break;	}

		utilGetTextAttributeByNumber( &ta,
						&(bd->bdTextAttributeList),
						tp->tpTextAttrNr );

		utilPropMaskClear( &pm );

		utilPropMaskClear( &pmAll );
		utilPropMaskFill( &pmAll, TAprop_COUNT );

		utilAttributeDifference( &pm, &taNew, &ta, &pmAll );

		utilPropMaskOr( &updMask, &updMask, &pm );

		tp++; part++;
		}
	    }

	if  ( paraBi == ds->dsTail.dpBi )
	    { break;	}

	paraBi= docNextParagraph( paraBi );
	if  ( ! paraBi )
	    { break;	}

	part= 0;
	tp= paraBi->biParaParticules+ part;

	/*  2  */
	if  ( paraBi->biParaListOverride > 0 )
	    {
	    DocumentField *	dfBullet= (DocumentField *)0;
	    DocumentSelection	dsInsideBullet;
	    DocumentSelection	dsAroundBullet;

	    if  ( docDelimitParaHeadField( &dfBullet,
					&dsInsideBullet, &dsAroundBullet,
					&bulletPartBegin, &bulletPartEnd,
					paraBi, bd ) )
		{ LDEB(1);	}

	    part= bulletPartEnd+ 1;
	    tp= paraBi->biParaParticules+ part;
	    }
	}

    utilPropMaskNot( &updMask, &updMask );

    *pUpdMask= updMask;
    *pTaNew= taNew;

    return;
    }

/************************************************************************/
/*									*/
/*  Remember the text attribute of the beginning of the selection.	*/
/*									*/
/*  NOTE that for I-Bar selections, in case of ambiguity, there is a	*/
/*	preference for the attribute of the particule before the	*/
/*	current position.						*/
/*									*/
/************************************************************************/

int docGetTextAttributeForInsert(	TextAttribute *			ta,
					const BufferDocument *		bd,
					int				IBar,
					const DocumentPosition *	dp )
    {
    BufferItem *		bi= dp->dpBi;

    const int			lastOne= 1;
    int				part;
    const TextParticule *	tp= bi->biParaParticules;

    if  ( docFindParticuleOfPosition( &part, dp, lastOne ) )
	{ LDEB(dp->dpStroff); return- 1;	}

    tp= bi->biParaParticules+ part;

    if  ( IBar				&&
	  part > 0			&&
	  dp->dpStroff == tp->tpStroff	&&
	  tp[-1].tpKind == DOCkindSPAN	)
	{ tp--; part--; }

    utilGetTextAttributeByNumber( ta, &(bd->bdTextAttributeList),
							    tp->tpTextAttrNr );

    return tp->tpTextAttrNr;
    }

