/************************************************************************/
/*									*/
/*  Pieces of text, physically implemented as a 'Section' thay are	*/
/*  outside the normal flow of text.					*/
/*									*/
/************************************************************************/

#   ifndef	DOC_EXTERNAL_ITEM_H
#   define	DOC_EXTERNAL_ITEM_H

#   include	"docDocumentField.h"
#   include	"docListNumberTree.h"

/************************************************************************/
/*									*/
/*  Forward declarations of structs.					*/
/*									*/
/************************************************************************/

struct BufferDocument;
struct BufferItem;
struct DocumentField;

/************************************************************************/
/*									*/
/*  Kinds of external items.						*/
/*									*/
/************************************************************************/


typedef enum DOC_ItemRoot
    {
    DOCinUNKNOWN= 0,

    DOCinBODY,

    /*  As of Word 11, the right (odd) header is used without facing pages.
    DOCinSECT_HEADER, */
    DOCinFIRST_HEADER,
    DOCinLEFT_HEADER,
    DOCinRIGHT_HEADER,

    /*  As of Word 11, the right (odd) footer is used without facing pages.
    DOCinSECT_FOOTER, */
    DOCinFIRST_FOOTER,
    DOCinLEFT_FOOTER,
    DOCinRIGHT_FOOTER,

    DOCinFOOTNOTE,
    DOCinENDNOTE,
    DOCinANNOTATION,

    DOCinFTNSEP,
    DOCinFTNSEPC,
    DOCinFTNCN,

    DOCinAFTNSEP,
    DOCinAFTNSEPC,
    DOCinAFTNCN,

    DOCinSHPTXT,

    DOCin_COUNT
    } DOC_ItemRoot;

/************************************************************************/
/*									*/
/*  Headers and/or footers appear on different pages, depending on	*/
/*  whether the section has a title page and/or the document has facing	*/
/*  pages. These are the options as they exist on the tool. In my	*/
/*  opinion these are also the possibilities from the users perspective.*/
/*									*/
/*  The arrays are a mapping from the options to the header/footer data	*/
/*  structure that is used in the implementation.			*/
/*									*/
/************************************************************************/

typedef enum WhatPages
    {
    PAGES_FIRST_PAGE= 0,
    PAGES_SUBSEQUENT_PAGES,
    PAGES_ALL_PAGES,
    PAGES_ODD_PAGES,
    PAGES_EVEN_PAGES,
    PAGES__COUNT
    } WhatPages;

extern const int DOC_HeaderScopes[PAGES__COUNT];
extern const int DOC_FooterScopes[PAGES__COUNT];

/************************************************************************/
/*									*/
/*  A structure describing an external item.				*/
/*									*/
/************************************************************************/

typedef struct DocumentTree
    {
    struct BufferItem *		eiRoot;
    int				eiPageFormattedFor;
    int				eiColumnFormattedFor;
    int				eiY0UsedTwips;
    int				eiY1UsedTwips;
    int				eiY0ReservedTwips;
    int				eiY1ReservedTwips;

    int				eiPageSelectedUpon;
    int				eiColumnSelectedIn;

    ListNumberTrees		eiListNumberTrees;
    ListNumberTreeNode		eiOutlineTree;

    ChildFields			eiRootFields;
    } DocumentTree;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void docInitExternalItem(	DocumentTree *		ei );

extern void docCleanExternalItem(	struct BufferDocument *	bd,
					DocumentTree *		ei );

extern int docExternalItemAddRootField(	DocumentTree *		ei,
					DocumentField *		dfCh );

#   endif
