/************************************************************************/
/*									*/
/*  Evaluate fields+ the list of kinds of fields.			*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	"docParaString.h"
#   include	"docEvalField.h"

/************************************************************************/
/*									*/
/*  Manage fields.							*/
/*									*/
/************************************************************************/

void docInitRecalculateFields(   RecalculateFields *     rf )
    {
    rf->rfBd= (BufferDocument *)0;
    rf->rfEi= (DocumentTree *)0;
    rf->rfMergeValueTree= (void *)0;
    rf->rfCloseObject= (DOC_CLOSE_OBJECT)0;
    rf->rfFieldsUpdated= 0;
    rf->rfUpdateFlags= 0;

    docInitEditPosition( &(rf->rfSelBegin) );
    docInitEditPosition( &(rf->rfSelEnd) );

    rf->rfFieldDataProvider= (FieldDataProvider)0;
    rf->rfInstanceStreamProvider= (InstanceStreamProvider)0;
    rf->rfMergeThrough= (void *)0;

    return;
    }

/************************************************************************/
/*									*/
/*  Replace the previous contents of a field with new contents.		*/
/*									*/
/************************************************************************/

int docFieldReplaceContents(
			int *				pStroff,
			int *				pStroffShift,
			int *				pTextAttrNr,
			BufferItem *			paraBi,
			int				part,
			int				partCount,
			int				stroffShift,
			const char *			addedString,
			int				addedStrlen,
			const RecalculateFields *	rf )
    {
    int			i;
    TextParticule *	tp= paraBi->biParaParticules+ part;

    int			textAttributeNumber= tp[1].tpTextAttrNr;
    int			past= tp[1+partCount].tpStroff+ stroffShift;
    int			stroff= tp[1].tpStroff+ stroffShift;

    int			d= 0;

    if  ( docParaStringReplace( &d, paraBi, stroff, past,
					    addedString, addedStrlen ) )
	{ LDEB(addedStrlen); return -1;	}

    if  ( partCount > 0 )
	{
	tp= paraBi->biParaParticules+ part+ 1;
	for ( i= 0; i < partCount; tp++, i++ )
	    {
	    if  ( rf->rfCloseObject )
		{ (*rf->rfCloseObject)( rf->rfBd, tp );	}
	    docCleanParticuleObject( rf->rfBd, tp );
	    }

	docDeleteParticules( paraBi, part+ 1, partCount );
	}

    *pStroff= stroff;
    *pStroffShift= d;
    *pTextAttrNr= textAttributeNumber;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Substitute an individual text field in a paragraph.			*/
/*									*/
/*  NOTE: This routine is not recursive. Nested fields are handeled	*/
/*	by the caller.							*/
/*									*/
/************************************************************************/

int docRecalculateParaStringTextParticules(
				int *				pCalculated,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			paraBi,
				int				part,
				int				partCount,
				DocumentField *			df,
				const RecalculateFields *	rf )
    {
    int					rval= 0;
    MemoryBuffer			mbResult;
    int					calculated= 0;

    int					d;

    TextParticule *			tp= paraBi->biParaParticules+ part;

    int					textAttributeNumber;

    int					past;
    int					stroff;
    int					partsMade;

    int					i;

    const FieldKindInformation *	fki= DOC_FieldKinds+ df->dfKind;

    utilInitMemoryBuffer( &mbResult );

    if  ( (*fki->fkiCalculateTextString)( &calculated, &mbResult,
					    paraBi, part, partCount, df, rf ) )
	{ SDEB(fki->fkiLabel); rval= -1; goto ready;	}

    if  ( ! calculated )
	{
	*pCalculated= 0;
	*pPartShift= 0;
	/* NO! *pStroffShift= 0; */
	goto ready;
	}

    if  ( tp[1].tpStrlen == mbResult.mbSize				&&
	  ! memcmp( docParaString( paraBi, tp[1].tpStroff+ *pStroffShift ),
					mbResult.mbBytes, mbResult.mbSize ) )
	{
	*pCalculated= 0;
	*pPartShift= 0;
	/* NO! *pStroffShift= 0; */
	goto ready;
	}

    textAttributeNumber= tp[1].tpTextAttrNr;
    past= tp[1+partCount].tpStroff+ *pStroffShift;
    stroff= tp[1].tpStroff+ *pStroffShift;

    if  ( docParaStringReplace( &d, paraBi, stroff, past,
				(char *)mbResult.mbBytes, mbResult.mbSize ) )
	{ LDEB(mbResult.mbSize); rval= -1; goto ready;	}

    tp= paraBi->biParaParticules+ part+ 1;
    for ( i= 0; i < partCount; tp++, i++ )
	{
	if  ( rf->rfCloseObject )
	    { (*rf->rfCloseObject)( rf->rfBd, tp ); }

	docCleanParticuleObject( rf->rfBd, tp );
	}

    partsMade= docRedivideStringInParticules( paraBi, stroff, mbResult.mbSize,
				    part+ 1, partCount, textAttributeNumber );
    if  ( partsMade < partCount )
	{
	docDeleteParticules( paraBi, part+ 1+ partsMade, partCount- partsMade );
	}

    *pCalculated= 1;
    *pPartShift= partsMade- partCount;
    *pStroffShift += d;

  ready:

    utilCleanMemoryBuffer( &mbResult );

    return rval;
    }

/************************************************************************/
/*									*/
/*  Substitute the text fields in a paragraph.				*/
/*									*/
/*  1)  For all fields in range...					*/
/*	NOTE that the end of the range may have been shifted by the	*/
/*	calculation of field results.					*/
/*  2)  Shift this particule by what previous calculations have changed	*/
/*	in size.							*/
/*  3)  Not the beginning of a field.. Irrelevant.			*/
/*  4)  Retrieve the field. Do some sanity checks: Only text level	*/
/*	fields are evaluated here.					*/
/*  5)  Count the number of particules currently in the field.		*/
/*  6)  When the field is to be recalculated.. do so.			*/
/*	NOTE that this may shift both the array of particules and the	*/
/*	paragraph text.							*/
/*	Otherwise just shift the offsets of the particules inside the	*/
/*	field.								*/
/*  7)  When there is sufficient space inside the field to contain	*/
/*	yet another one.. go into recursion.				*/
/*	NOTE that this may shift both the array of particules and the	*/
/*	paragraph text.							*/
/*  8)  Shift the end particule of the field.				*/
/*  9)  Set the current position in the loop to the end particule. The	*/
/*	loop increment will move to the particule after the field.	*/
/*									*/
/************************************************************************/

static int docRecalculateParaTextFields(
				RecalculateFields *	rf,
				int *			pPartShift,
				int *			pStroffShift,
				BufferItem *		paraBi,
				int			part,
				int			partUpto )
    {
    BufferDocument *	bd= rf->rfBd;
    int			fieldsUpdated= 0;
    int			paraNr= -1;

    /*  1  */
    for ( part= part; part < partUpto+ *pPartShift; part++ )
	{
	TextParticule *			tp= paraBi->biParaParticules+ part;

	DocumentField *			df;
	const FieldKindInformation *	fki;

	int				tailPart;
	int				partCount;
	int				closed;
	int				stroffTail;

	/*  2  */
	if  ( docShiftParticuleOffsets( rf->rfBd, paraBi, part, part+ 1,
							    *pStroffShift ) )
	    { LDEB(*pStroffShift);	}

	/*  3  */
	if  ( tp->tpKind != DOCkindFIELDSTART )
	    { continue;	}

	if  ( paraNr <= 0					&&
	      ( rf->rfSelBegin.epParaNr > 0	||
	        rf->rfSelEnd.epParaNr > 0	)	)
	    { paraNr= docNumberOfParagraph( paraBi );	}

	/*  4  */
	df= docGetFieldByNumber( &(bd->bdFieldList), tp->tpObjectNumber );
	if  ( ! df )
	    { LXDEB(tp->tpObjectNumber,df); continue;	}
	if  ( /*df->dfKind < 0 ||*/ df->dfKind >= DOC_FieldKindCount )
	    { LLDEB(df->dfKind,DOC_FieldKindCount); continue;	}

	fki= DOC_FieldKinds+ df->dfKind;

	/*  5  */
	partCount= docCountParticulesInField( paraBi, &closed, part,
						    partUpto+ *pPartShift );
	if  ( partCount < 0 )
	    { SLDEB(docFieldKindStr(df->dfKind),partCount); continue;	}
	tailPart= part+ 1+ partCount;
	if  ( tailPart < paraBi->biParaParticuleCount )
	    { stroffTail= tp[1+partCount].tpStroff;	}
	else{ stroffTail= docParaStrlen( paraBi );	}

	/*  6  */
	if  ( closed						&&
	      fki->fkiLevel == DOClevSPAN			&&
	      ( fki->fkiCalculateWhen & rf->rfUpdateFlags )	&&
	      fki->fkiCalculateTextParticules			)
	    {
	    int			partShift= 0;
	    int			calculated= 0;
	    int			oldStroffShift= *pStroffShift;

	    if  ( (*fki->fkiCalculateTextParticules)( &calculated,
					&partShift, pStroffShift,
					paraBi, part, partCount, df, rf ) )
		{ LDEB(1); return -1;	}

	    if  ( calculated )
		{
		int	stroffShift= *pStroffShift- oldStroffShift;

		docAdjustEditPositionOffsetB( &(rf->rfSelBegin),
					paraNr, stroffTail, stroffShift );
		docAdjustEditPositionOffsetE( &(rf->rfSelEnd),
					paraNr, stroffTail, stroffShift );

		fieldsUpdated++; rf->rfFieldsUpdated++;
		}
	    else{
		if  ( docShiftParticuleOffsets( rf->rfBd, paraBi,
					part+ 1, tailPart, *pStroffShift ) )
		    { LDEB(*pStroffShift);	}
		}

	    tailPart += partShift;
	    *pPartShift += partShift;
	    }
	else{
	    if  ( docShiftParticuleOffsets( rf->rfBd, paraBi,
					part+ 1, tailPart, *pStroffShift ) )
		{ LDEB(*pStroffShift);	}
	    }

	/*  7  */
	if  ( tailPart- part >= 2 )
	    {
	    int			partShift= 0;
	    int			stroffShift= 0;

	    if  ( docRecalculateParaTextFields( rf,
			&partShift, &stroffShift, paraBi, part+ 1, tailPart ) )
		{ LDEB(1); return -1;	}

	    tailPart += partShift;
	    *pPartShift += partShift;
	    *pStroffShift += stroffShift;
	    }

	/*  8   */
	if  ( closed )
	    {
	    tp= paraBi->biParaParticules+ tailPart;
	    if  ( tp->tpKind != DOCkindFIELDEND )
		{ LDEB(tp->tpKind);	}

	    tp->tpStroff += *pStroffShift;
	    df->dfTailPosition.epStroff= tp->tpStroff;
	    }

	/*  9  */
	part= tailPart;
	}

    if  ( fieldsUpdated )
	{ docInvalidateParagraphLayout( paraBi );	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Substitute the text fields in a buffer item.			*/
/*									*/
/************************************************************************/

int docRecalculateTextLevelFieldsInExternalItem(
					RecalculateFields *	rf,
					DocumentTree *		ei,
					const BufferItem *	bodySectBi,
					int			page )
    {
    int			rval= 0;
    int			ret;
    int			saveFieldsUpdated= rf->rfFieldsUpdated;
    DocumentTree *	saveEi= rf->rfEi;

    if  ( ! ei->eiRoot )
	{ return 0;	}

    if  ( ei->eiRoot->biLevel == DOClevSECT		&&
          ei->eiRoot->biSectExternalUseForSectBi	)
	{ XDEB(ei->eiRoot->biSectExternalUseForSectBi); return -1;	}

    ei->eiRoot->biSectExternalUseForSectBi= bodySectBi;
    ei->eiRoot->biSectExternalUseForPage= page;

    rf->rfFieldsUpdated= 0;
    rf->rfEi= ei;

    ret= docRecalculateTextLevelFields( rf, ei->eiRoot );
    if  ( ret )
	{ LDEB(ret); rval= -1;	}

    if  ( rf->rfFieldsUpdated > 0 )
	{
	ei->eiPageFormattedFor= -1;
	ei->eiColumnFormattedFor= -1;
	}

    rf->rfFieldsUpdated += saveFieldsUpdated;
    rf->rfEi= saveEi;

    ei->eiRoot->biSectExternalUseForSectBi= (const BufferItem *)0;

    return rval;
    }

int docRecalculateTextLevelFields(	RecalculateFields *	rf,
					BufferItem *		bi )
    {
    BufferDocument *	bd= rf->rfBd;
    int			i;

    switch( bi->biLevel )
	{
	case DOClevBODY:
	    for ( i= 0; i < bi->biChildCount; i++ )
		{
		if  ( docRecalculateTextLevelFields( rf, bi->biChildren[i] ) )
		    { LDEB(i); return -1;	}
		}

	    {
	    const int	page= -1;

	    if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
			&(bd->bdEiFtnsep), (BufferItem *)0, page )	)
		{ LDEB(1); return -1;	}

	    if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
			&(bd->bdEiFtnsepc), (BufferItem *)0, page )	)
		{ LDEB(1); return -1;	}

	    if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
			&(bd->bdEiFtncn), (BufferItem *)0, page )	)
		{ LDEB(1); return -1;	}

	    if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
			&(bd->bdEiAftnsep), (BufferItem *)0, page )	)
		{ LDEB(1); return -1;	}

	    if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
			&(bd->bdEiAftnsepc), (BufferItem *)0, page )	)
		{ LDEB(1); return -1;	}

	    if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
			&(bd->bdEiAftncn), (BufferItem *)0, page )	)
		{ LDEB(1); return -1;	}
	    }

	    return 0;

	case DOClevROW:
	case DOClevCELL:
	    for ( i= 0; i < bi->biChildCount; i++ )
		{
		if  ( docRecalculateTextLevelFields( rf, bi->biChildren[i] ) )
		    { LDEB(i); return -1;	}
		}

	    return 0;

	case DOClevSECT:
	    for ( i= 0; i < bi->biChildCount; i++ )
		{
		if  ( docRecalculateTextLevelFields( rf, bi->biChildren[i] ) )
		    { LDEB(i); return -1;	}
		}

	    if  ( bi->biInExternalItem == DOCinBODY )
		{
		DocumentField *		dfNote;
		DocumentNote *		dn;
		const int		page= -1;
		const int		extItKind= -1;

		if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
				    &(bi->biSectFirstPageHeader), bi, page ) )
		    { LDEB(1); return -1;	}

		if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
				    &(bi->biSectLeftPageHeader), bi, page ) )
		    { LDEB(1); return -1;	}

		if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
				    &(bi->biSectRightPageHeader), bi, page ) )
		    { LDEB(1); return -1;	}


		if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
				    &(bi->biSectFirstPageFooter), bi, page ) )
		    { LDEB(1); return -1;	}

		if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
				    &(bi->biSectLeftPageFooter), bi, page ) )
		    { LDEB(1); return -1;	}

		if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
				    &(bi->biSectRightPageFooter), bi, page ) )
		    { LDEB(1); return -1;	}

		dfNote= docGetFirstNoteOfSection( &dn, bd,
					    bi->biNumberInParent, extItKind );
		while( dfNote )
		    {
		    DocumentTree *	ei= &(dn->dnDocumentTree);
		    if  ( ! ei->eiRoot )
			{ continue;	}

		    if  ( docRecalculateTextLevelFieldsInExternalItem( rf,
							    ei, bi, page ) )
			{ LDEB(1); return -1;	}

		    dfNote= docGetNextNoteInSection( &dn, bd,
				    bi->biNumberInParent, dfNote, extItKind );
		    }
		}

	    return 0;

	case DOClevPARA:

	    {
	    int		partShift= 0;
	    int		stroffShift= 0;

	    if  ( docRecalculateParaTextFields( rf, &partShift, &stroffShift,
					bi, 0, bi->biParaParticuleCount ) )
		{ LDEB(1); return -1;	}
	    }

	    return 0;

	default:
	    LDEB(bi->biLevel); return -1;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Recalculate TOC fields.						*/
/*									*/
/*  1)  See whether there are any TOC fields.				*/
/*  2)  Make sure that all TOC candidates have valid bookmarls.		*/
/*  3)  Calculate the table(s) of contents.				*/
/*									*/
/************************************************************************/

int docRecalculateTocFields( RecalculateFields *		rf )
    {
    BufferDocument *	bdDoc= rf->rfBd;
    DocumentFieldList *	dfl= &(bdDoc->bdFieldList);
    const int		fieldCount= dfl->dflPagedList.plItemCount;
    int			fieldNr;

    /*  1  */
    for ( fieldNr= 0; fieldNr < fieldCount; fieldNr++ )
	{
	DocumentField *		df= docGetFieldByNumber( dfl, fieldNr );

	if  ( ! df							||
	      df->dfKind != DOCfkTOC					||
	      df->dfSelectionScope.ssInExternalItem != DOCinBODY	)
	    { continue;	}

	break;
	}

    if  ( fieldNr >= fieldCount )
	{ return 0;	}

    /*  2  */
    docRemoveUnbalancedTocBookmarks( bdDoc );

    if  ( docSetTocBookmarks( bdDoc ) )
	{ LDEB(1); return -1;	}

    /*  3  */
    for ( fieldNr= 0; fieldNr < fieldCount; fieldNr++ )
	{
	DocumentField *		df= docGetFieldByNumber( dfl, fieldNr );

	if  ( ! df )
	    { continue;	}
	if  ( df->dfKind != DOCfkTOC					||
	      df->dfSelectionScope.ssInExternalItem != DOCinBODY	)
	    { continue;	}

	if  ( docRecalculateOneTocField( bdDoc, df ) )
	    { LDEB(fieldNr); return -1;	}
	}

    return 0;
    }

