/************************************************************************/
/*									*/
/*  Section manipulation routines.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>

#   include	"docBuf.h"

int docChangeSectionProperties(	PropertyMask *		pSpChgMask,
				int *			pRedraw,
				BufferDocument *	bd,
				BufferItem *		sectBi,
				const PropertyMask *	spSetMask,
				const SectionProperties * spNew )
    {
    PropertyMask	spChgMask;

    utilPropMaskClear( &spChgMask );

    if  ( docUpdSectProperties( &spChgMask,
			    &(sectBi->biSectProperties), spSetMask, spNew ) )
	{ XDEB(spSetMask); return -1;	}

    if  ( sectBi->biInExternalItem == DOCinBODY )
	{
	if  ( PROPmaskISSET( &spChgMask, DGpropPAGE_WIDTH )	||
	      PROPmaskISSET( &spChgMask, DGpropLEFT_MARGIN )	||
	      PROPmaskISSET( &spChgMask, DGpropRIGHT_MARGIN )	)
	    {
	    PropertyMask	spWideMask;

	    utilPropMaskClear( &spWideMask );

	    PROPmaskADD( &spWideMask, DGpropPAGE_WIDTH );
	    PROPmaskADD( &spWideMask, DGpropLEFT_MARGIN );
	    PROPmaskADD( &spWideMask, DGpropRIGHT_MARGIN );
	    }
	}

    if  ( PROPmaskISSET( &spChgMask, SPpropTITLEPG )		||
	  PROPmaskISSET( &spChgMask, SPpropNUMBER_STYLE )	||
	  PROPmaskISSET( &spChgMask, SPpropNUMBER_HYPHEN )	||
	  PROPmaskISSET( &spChgMask, SPpropPAGE_RESTART )	||
	  PROPmaskISSET( &spChgMask, SPpropSTART_PAGE )		)
	{ *pRedraw= 1;	}

    if  ( PROPmaskISSET( &spChgMask, SPpropNUMBER_STYLE )	||
	  PROPmaskISSET( &spChgMask, SPpropNUMBER_HYPHEN )	||
	  PROPmaskISSET( &spChgMask, SPpropPAGE_RESTART )	||
	  PROPmaskISSET( &spChgMask, SPpropSTART_PAGE )		||
	  PROPmaskISSET( &spChgMask, DGpropPAGE_WIDTH )		||
	  PROPmaskISSET( &spChgMask, DGpropLEFT_MARGIN )	||
	  PROPmaskISSET( &spChgMask, DGpropRIGHT_MARGIN )	)
	{
	sectBi->biSectFirstPageHeader.eiPageFormattedFor= -1;
	sectBi->biSectFirstPageHeader.eiColumnFormattedFor= -1;
	sectBi->biSectLeftPageHeader.eiPageFormattedFor= -1;
	sectBi->biSectLeftPageHeader.eiColumnFormattedFor= -1;
	sectBi->biSectRightPageHeader.eiPageFormattedFor= -1;
	sectBi->biSectRightPageHeader.eiColumnFormattedFor= -1;

	sectBi->biSectFirstPageFooter.eiPageFormattedFor= -1;
	sectBi->biSectFirstPageFooter.eiColumnFormattedFor= -1;
	sectBi->biSectLeftPageFooter.eiPageFormattedFor= -1;
	sectBi->biSectLeftPageFooter.eiColumnFormattedFor= -1;
	sectBi->biSectRightPageFooter.eiPageFormattedFor= -1;
	sectBi->biSectRightPageFooter.eiColumnFormattedFor= -1;
	}

    if  ( PROPmaskISSET( &spChgMask, SPpropNUMBER_STYLE )	||
	  PROPmaskISSET( &spChgMask, SPpropNUMBER_HYPHEN )	||
	  PROPmaskISSET( &spChgMask, SPpropPAGE_RESTART )	||
	  PROPmaskISSET( &spChgMask, SPpropSTART_PAGE )		||
	  PROPmaskISSET( &spChgMask, DGpropPAGE_WIDTH )		||
	  PROPmaskISSET( &spChgMask, DGpropLEFT_MARGIN )	||
	  PROPmaskISSET( &spChgMask, DGpropRIGHT_MARGIN )	||

	  PROPmaskISSET( &spChgMask, SPpropCOLUMN_COUNT )	||
	  PROPmaskISSET( &spChgMask, SPpropCOLUMN_SPACING )	||
	  PROPmaskISSET( &spChgMask, SPpropCOLUMNS )		)
	{
	*pRedraw= 1;
	docInvalidateNoteLayoutForSection( bd, sectBi->biNumberInParent );
	}

    utilPropMaskOr( pSpChgMask, pSpChgMask, &spChgMask );

    return 0;
    }

void docInvalidateNoteLayoutForSection(		BufferDocument *	bd,
						int			sect )
    {
    DocumentField *	dfNote;
    DocumentNote *	dn;
    const int		extItKind= -1;

    if  ( sect >= 0 )
	{
	dfNote= docGetFirstNoteOfSection( &dn, bd, sect, extItKind );
	}
    else{
	dfNote= docGetFirstNoteOfDocument( &dn, bd, extItKind );
	}

    for ( ;
	  dfNote;
	  dfNote= docGetNextNoteInSection( &dn, bd, sect, dfNote, extItKind ) )
	{
	dn->dnReferringPage= -1;
	dn->dnReferringColumn= -1;

	dn->dnDocumentTree.eiPageFormattedFor= -1;
	dn->dnDocumentTree.eiColumnFormattedFor= -1;
	}

    return;
    }

