/************************************************************************/
/*									*/
/*  Positions in a document. To prevent crashes, all references are	*/
/*  to the paragraph number, rather than the paragraph object.		*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docPropVal.h"
#   include	"docEditRange.h"

/************************************************************************/
/*									*/
/*  Initialize an EditRange.						*/
/*									*/
/************************************************************************/

void docInitEditRange(	EditRange *	er )
    {
    er->erBottomLevel= DOClevOUT;

    docInitEditPosition( &(er->erHead) );
    docInitEditPosition( &(er->erTail) );
    }

/************************************************************************/
/*									*/
/*  Shift references in various administrations.			*/
/*									*/
/************************************************************************/

void docShiftEditRange(	EditRange  *		er,
			int			paraFrom,
			int			stroffFrom,
			int			paraShift,
			int			stroffShift )
    {
    docAdjustEditPositionB( &(er->erHead),
				paraFrom, stroffFrom, paraShift, stroffShift );
    docAdjustEditPositionE( &(er->erTail),
				paraFrom, stroffFrom, paraShift, stroffShift );

    return;
    }

