/************************************************************************/
/*									*/
/*  Document Editing.							*/
/*									*/
/************************************************************************/

#   ifndef		DOC_EDIT_OPERATION_H
#   define		DOC_EDIT_OPERATION_H

#   include		"docBuf.h"

/************************************************************************/
/*									*/
/*  Describes an edit operation. Part is only used for interactive edit	*/
/*  operations.								*/
/*									*/
/************************************************************************/

typedef struct EditOperation
    {
    SelectionScope		eoSelectionScope;
    const BufferItem *		eoBodySectBi;
    DocumentField *		eoBottomField;
				    /************************************/
				    /*  Field (if any) that fully holds	*/
				    /*  the initial selection for this	*/
				    /*  edit operation. The assumption	*/
				    /*	is that it will not be deleted	*/
				    /*  and that it will be the parent	*/
				    /*  of new fields.			*/
				    /************************************/

    int				eoIBarSelectionOld;
    int				eoMultiParagraphSelectionOld;

    /**/
    int				eoParaAdjustParagraphNumber;
    int				eoParaAdjustStroffFrom;
    int				eoParaAdjustStroffShift;
    int				eoParaAdjustStroffUpto;

    /**/
    EditRange			eoReformatRange;
				    /************************************/
				    /*  Document range that is touched	*/
				    /*  by the edit operation: It must	*/
				    /*  be reformatted and redisplayed.	*/
				    /*  after editing.			*/
				    /************************************/
    EditRange			eoSelectedRange;
				    /************************************/
				    /*  The selection at the beginning	*/
				    /*  of the edit operation. If	*/
				    /*  needed, it is updated along the	*/
				    /*  way to make it possible to	*/
				    /*  select the same content after	*/
				    /*  the operation.			*/
				    /************************************/
    /**/
    int				eoNotesDeleted;
    int				eoNotesAdded;
    int				eoSectionsDeleted;
    int				eoSectionsAdded;
    int				eoBulletsChanged;
    int				eoParagraphsInserted;

    unsigned int		eoFieldUpdate;

    /**/
    BufferDocument *		eoBd;
    DocumentTree *		eoEi;
    DOC_CLOSE_OBJECT		eoCloseObject;

    /*  1  */
    DocumentPosition		eoHeadDp;
    DocumentPosition		eoTailDp;
    DocumentPosition		eoLastDp;
    int				eoHeadParticule;
    int				eoTailParticule;
				/****************************************/
				/*  If we are at particule head, a	*/
				/*  freshly inserted particule will get	*/
				/*  this number, pushing remaining	*/
				/*  particules to the right. The number	*/
				/*  may	be past the last particule.	*/
				/*  If we are not at particule head, we	*/
				/*  are inside an existing particule	*/
				/*  that must be split before we insert	*/
				/*  fresh particules.			*/
				/****************************************/
    int				eoTailAtPartHead;
				/****************************************/
				/*  The insertion position for new	*/
				/*  particules equals eoTailParticule:	*/
				/*  we are either at the head of the	*/
				/*  particule or past the last one of	*/
				/*  the paragraph. Otherwise we must	*/
				/*  split a particule before we insert	*/
				/*  fresh ones.				*/
				/****************************************/
    } EditOperation;

/************************************************************************/
/*									*/
/*  Routine Declarations.						*/
/*									*/
/************************************************************************/

extern void docInitEditOperation(	EditOperation *	eo );

extern void docIncludePositionInReformat(
					EditOperation *		eo,
					const EditPosition *	ep );

extern void docIncludeDocumentSelectionInReformat(
					EditOperation *			eo,
					const DocumentSelection *	ds );

extern void docEditOperationGetSelection(	DocumentSelection *	dsNew,
						const EditOperation *	eo );

extern int docStartEditOperation(	EditOperation *			eo,
					const DocumentSelection *	ds,
					BufferDocument *		bd );

extern void docEditIncludeItemInReformatRange(	EditOperation *		eo,
						BufferItem *		bi );

extern void docEditIncludeRowsInReformatRange(
					EditOperation *		eo,
					BufferItem *		sectBi,
					int			row0,
					int			row1 );

extern void docSetParagraphAdjust(	EditOperation *		eo,
					BufferItem *		paraBi,
					int			stroffShift,
					int			stroffUpto );

extern void docExtendParagraphAdjust(	EditOperation *		eo,
					BufferItem *		paraBi,
					int			stroffShift );

extern void docEditFinishStep(		EditOperation *		eo );

#   endif	/*	DOC_EDIT_OPERATION_H	*/
