/************************************************************************/
/*									*/
/*  Administration of EditOperations.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docEditOperation.h"

void docInitEditOperation(	EditOperation *	eo )
    {
    docInitSelectionScope( &(eo->eoSelectionScope) );
    eo->eoBodySectBi= (const BufferItem *)0;
    eo->eoBottomField= (DocumentField *)0;

    eo->eoIBarSelectionOld= 0;
    eo->eoMultiParagraphSelectionOld= 0;

    eo->eoParaAdjustParagraphNumber= -1;
    eo->eoParaAdjustStroffFrom= 0;
    eo->eoParaAdjustStroffShift= 0;
    eo->eoParaAdjustStroffUpto= 0;

    docInitEditRange( &(eo->eoReformatRange) );
    docInitEditRange( &(eo->eoSelectedRange) );

    eo->eoNotesDeleted= 0;
    eo->eoNotesAdded= 0;
    eo->eoSectionsDeleted= 0;
    eo->eoSectionsAdded= 0;
    eo->eoBulletsChanged= 0;
    eo->eoParagraphsInserted= 0;
    eo->eoFieldUpdate= FIELDdoNOTHING;

    eo->eoBd= (BufferDocument *)0;
    eo->eoEi= (DocumentTree *)0;
    eo->eoCloseObject= (DOC_CLOSE_OBJECT)0;

    docInitDocumentPosition( &(eo->eoHeadDp) );
    eo->eoHeadParticule= 0;

    docInitDocumentPosition( &(eo->eoTailDp) );
    eo->eoTailParticule= 0;
    eo->eoTailAtPartHead= 0;

    docInitDocumentPosition( &(eo->eoLastDp) );

    return;
    }

/************************************************************************/
/*									*/
/*  Include a position in the range in the document that is to be	*/
/*  reformatted.							*/
/*									*/
/*  0)  Not used for adjusts: Remove the adjust.			*/
/*  1)  The document has been empty. in the course of the modification.	*/
/*	Now that a paragraph is included it is not empty anymore. Move	*/
/*	the start position to the beginning of the document.		*/
/*  2)  Shift beginning if necessary.					*/
/*  3)  Shift end if necessary.						*/
/*									*/
/************************************************************************/

void docIncludePositionInReformat(	EditOperation *		eo,
					const EditPosition *	ep )
    {
    EditRange *		er= &(eo->eoReformatRange);

    /*  0  */
    eo->eoParaAdjustParagraphNumber= -1;
    eo->eoParaAdjustStroffFrom= 0;
    eo->eoParaAdjustStroffShift= 0;
    eo->eoParaAdjustStroffUpto= 0;

    /*  1  */
    if  ( er->erHead.epParaNr == 0 )
	{
	er->erHead.epParaNr= 1;
	er->erHead.epStroff= 0;
	}

    /*  2  */
    if  ( er->erHead.epParaNr < 0				||
	  docCompareEditPositions( &(er->erHead), ep ) > 0	)
	{ er->erHead= *ep;	}

    /*  3  */
    if  ( er->erTail.epParaNr < 0				||
	  docCompareEditPositions( &(er->erTail), ep ) < 0	)
	{ er->erTail= *ep;	}

    return;
    }

void docIncludeDocumentSelectionInReformat(
					EditOperation *			eo,
					const DocumentSelection *	ds )
    {
    EditPosition	epFirst;
    EditPosition	epLast;

    docSetEditPosition( &epFirst, ds->dsHead.dpBi, ds->dsHead.dpStroff );
    docIncludePositionInReformat( eo, &epFirst );

    docSetEditPosition( &epLast, ds->dsTail.dpBi, ds->dsTail.dpStroff );
    docIncludePositionInReformat( eo, &epLast );

    return;
    }

void docEditIncludeItemInReformatRange(	EditOperation *		eo,
					BufferItem *		bi )
    {
    EditRange *		er= &(eo->eoReformatRange);
    DocumentPosition	dpFirst;
    DocumentPosition	dpLast;

    docInitDocumentPosition( &dpFirst );
    docInitDocumentPosition( &dpLast );

    eo->eoParaAdjustParagraphNumber= -1;
    eo->eoParaAdjustStroffFrom= 0;
    eo->eoParaAdjustStroffShift= 0;
    eo->eoParaAdjustStroffUpto= 0;

    if  ( er->erBottomLevel == DOClevOUT	||
	  er->erBottomLevel > bi->biLevel	)
	{ er->erBottomLevel= bi->biLevel; }

    if  ( docFirstPosition( &dpFirst, bi ) )
	{ LDEB(1);	}
    else{
	EditPosition	epFirst;

	docSetEditPosition( &epFirst, dpFirst.dpBi, dpFirst.dpStroff );
	docIncludePositionInReformat( eo, &epFirst );
	}

    if  ( docLastPosition( &dpLast, bi ) )
	{ LDEB(1);	}
    else{
	EditPosition	epLast;

	docSetEditPosition( &epLast, dpLast.dpBi, dpLast.dpStroff );
	docIncludePositionInReformat( eo, &epLast );
	}

    return;
    }

void docEditIncludeRowsInReformatRange(	EditOperation *		eo,
					BufferItem *		sectBi,
					int			row0,
					int			row1 )
    {
    docEditIncludeItemInReformatRange( eo, sectBi->biChildren[row0] );
    docEditIncludeItemInReformatRange( eo, sectBi->biChildren[row1] );

    return;
    }

/************************************************************************/
/*									*/
/*  Set the range within a paragraph that must be reformatted.		*/
/*									*/
/*  By default, entire paragraphs are reformatted. As an optimization	*/
/*  we limit reformatting of the text during typing to exactly those	*/
/*  lines that are affected.						*/
/*									*/
/************************************************************************/

void docSetParagraphAdjust(	EditOperation *		eo,
				BufferItem *		paraBi,
				int			stroffShift,
				int			stroffUpto )
    {
    EditRange *		er= &(eo->eoReformatRange);
    int			paraNr;

    if  ( paraBi->biLevel != DOClevPARA )
	{ LDEB(paraBi->biLevel); return;	}

    if  ( er->erBottomLevel == DOClevOUT )
	{ er->erBottomLevel= paraBi->biLevel; }

    if  ( eo->eoParaAdjustParagraphNumber >= 0 )
	{ docEditIncludeItemInReformatRange( eo, paraBi ); return; }

    paraNr= docNumberOfParagraph( paraBi );

    if  ( er->erHead.epParaNr == paraNr		&&
	  er->erTail.epParaNr == paraNr		)
	{
	eo->eoParaAdjustParagraphNumber= paraNr;
	/* eo->eoParaAdjustStroffFrom is set from the beginning */
	eo->eoParaAdjustStroffShift= stroffShift;
	eo->eoParaAdjustStroffUpto= stroffUpto;
	}
    else{
	docEditIncludeItemInReformatRange( eo, paraBi );
	}

    return;
    }

void docExtendParagraphAdjust(	EditOperation *		eo,
				BufferItem *		paraBi,
				int			stroffShift )
    {
    int			paraNr;

    if  ( paraBi->biLevel != DOClevPARA )
	{ LDEB(paraBi->biLevel); return;	}

    paraNr= docNumberOfParagraph( paraBi );

    if  ( eo->eoParaAdjustParagraphNumber != paraNr )
	{ LLDEB(eo->eoParaAdjustParagraphNumber,paraNr); return;	}

    eo->eoParaAdjustStroffShift += stroffShift;
    eo->eoParaAdjustStroffUpto += stroffShift;

    return;
    }

void docEditOperationGetSelection(		DocumentSelection *	dsNew,
						const EditOperation *	eo )
    {
    docSetRangeSelection( dsNew, &(eo->eoHeadDp), &(eo->eoTailDp), 1, -1, -1 );
    }

/************************************************************************/
/*									*/
/*  Start an edit operation.						*/
/*									*/
/*  1)  Make a first guess about the particules involved: The last one	*/
/*	at the begin position and the first one at the end position.	*/
/*  2)  Adapt selection not to partially overlap fields, nor to fully	*/
/*	lie inside read-only fields.					*/
/*  3)  Admin on the particules.					*/
/*  3)  Aditional admin on the selection.				*/
/*									*/
/*  6)	Find the offset of the last particule that really starts before	*/
/*	the edit operation. This is the point to start a partial layout	*/
/*	of the paragraph.						*/
/*									*/
/************************************************************************/

int docStartEditOperation(	EditOperation *			eo,
				const DocumentSelection *	ds,
				BufferDocument *		bd )
    {
    BufferItem *		bodySectBi;
    const BufferItem *		paraBi;

    DocumentField *		dfLeft;
    DocumentField *		dfRight;
    int				beginMoved= 0;
    int				endMoved= 0;
    int				headPart= -1;
    int				tailPart= -1;
    int				part;

    DocumentSelection		dsBal= *ds;

    const TextParticule *	tp;
    const int			lastOne= 1;
    int				multiPara;

    multiPara= dsBal.dsHead.dpBi != dsBal.dsTail.dpBi;

    /*  1  */
    if  ( docFindParticuleOfPosition( &headPart, &(dsBal.dsHead), lastOne ) )
	{ LDEB(1); return -1; }
    if  ( docFindParticuleOfPosition( &tailPart, &(dsBal.dsTail), lastOne ) )
	{ LDEB(1); return -1; }

    paraBi= dsBal.dsHead.dpBi;
    if  ( dsBal.dsHead.dpStroff >= docParaStrlen( paraBi ) )
	{ headPart= paraBi->biParaParticuleCount; }
    paraBi= dsBal.dsTail.dpBi;
    if  ( dsBal.dsTail.dpStroff >= docParaStrlen( paraBi ) )
	{ tailPart= paraBi->biParaParticuleCount; }

    paraBi= dsBal.dsTail.dpBi;
    tp= paraBi->biParaParticules;

    while( ( multiPara || tailPart > headPart )				&&
	   tailPart > 0							&&
	   tp[tailPart-1].tpKind != DOCkindSPAN				&&
	   tp[tailPart-1].tpStrlen == 0					&&
	   tp[tailPart-1].tpStroff == dsBal.dsTail.dpStroff	)
	{ tailPart--;	}

    /*  4  */
    eo->eoSelectionScope= dsBal.dsSelectionScope;

    if  ( docGetRootOfSelectionScope( &(eo->eoEi),
				&bodySectBi, bd, &(eo->eoSelectionScope) ) )
	{ LDEB(1); return -1;	}

    docIncludeDocumentSelectionInReformat( eo, &dsBal );
    eo->eoSelectedRange= eo->eoReformatRange;

    /*  2  */
    if  ( docBalanceFieldSelection( &dfLeft, &dfRight,
			    &beginMoved, &endMoved, &headPart, &tailPart, 
			    &(dsBal.dsHead), &(dsBal.dsTail),
			    eo->eoEi, bd ) )
	{ LDEB(1); return -1;	}

    eo->eoBottomField= docFieldGetCommonParent( dfLeft, dfRight );

    /*  3  */
    eo->eoHeadDp= dsBal.dsHead;
    eo->eoTailDp= dsBal.dsTail;
    eo->eoLastDp= dsBal.dsTail;

    eo->eoHeadParticule= headPart;
    eo->eoTailParticule= tailPart;

    paraBi= eo->eoTailDp.dpBi;
    if  ( tailPart >= paraBi->biParaParticuleCount			||
	  paraBi->biParaParticules[tailPart].tpStroff ==
						eo->eoTailDp.dpStroff	)
	{ eo->eoTailAtPartHead= 1;	}
    else{ eo->eoTailAtPartHead= 0;	}

    /*  5  */
    eo->eoBd= bd;

    /*  6  */
    if  ( headPart < dsBal.dsHead.dpBi->biParaParticuleCount )
	{
	part= headPart;
	tp= dsBal.dsHead.dpBi->biParaParticules+ part;
	while( part >= 0 )
	    {
	    if  ( tp->tpStroff < eo->eoHeadDp.dpStroff )
		{
		eo->eoParaAdjustStroffFrom= tp->tpStroff;
		break;
		}

	    part--; tp--;
	    }
	}

#   if 0
    LLDEB(eo->eoHeadParticule,eo->eoHeadDp.dpStroff);
    LLDEB(eo->eoTailParticule,eo->eoTailDp.dpStroff);
    docListItem(0,eo->eoHeadDp.dpBi,0);
    if  ( eo->eoTailDp.dpBi != eo->eoHeadDp.dpBi )
	{ docListItem(0,eo->eoTailDp.dpBi,0); }
#   endif

    return 0;
    }
