/************************************************************************/
/*									*/
/*  Manipulate lists.							*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Make a fresh default list level to be inserted in a document.	*/
/*									*/
/************************************************************************/

static int docFindFreeLevelTemplateId(
				const DocumentListTable *	dlt )
    {
    int		found= 1;
    int		retLevelTemplateID= -1;

    while( found )
	{
	int			i;
	const DocumentList *	dl;
	int			levelTemplateID= rand();

	found= 0;

	dl= dlt->dltLists;
	for ( i= 0; i < dlt->dltListCount; dl++, i++ )
	    {
	    int				j;
	    const DocumentListLevel *	dll;

	    dll= dl->dlLevels;
	    for ( j= 0; j < dl->dlLevelCount; dll++, j++ )
		{
		if  ( dll->dllTemplateID == levelTemplateID )
		    { found= 1; break;	}
		}

	    if  ( found )
		{ break;	}
	    }

	if  ( ! found )
	    { retLevelTemplateID= levelTemplateID; break; }
	}

    return retLevelTemplateID;
    }

/************************************************************************/
/*									*/
/*  Make a fresh default list to be inserted in a document.		*/
/*									*/
/*  0)  Restart from scratch.						*/
/*  1)  Make a unique list ID. The procedure is far from optimal, but	*/
/*	the number of lists in the document is small, this does not	*/
/*	really hurt.							*/
/*  2)  Make a unique template ID.					*/
/*  3)  Word does not set list style properties by default. (probably	*/
/*	never)								*/
/*  4)  Word makes anonymous lists.					*/
/*  5)  Word 2000+ makes hybrid lists by default.			*/
/*									*/
/************************************************************************/

static int docDefaultList(	DocumentList *			dlTo,
				const DocumentListTable *	dlt,
				int				deftab,
				const PropertyMask *		taSetMask,
				const TextAttribute *		taSet )
    {
    int			found;
    int			level;

    /*  0,3,4  */
    docCleanDocumentList( dlTo );
    docInitDocumentList( dlTo );

    /*  1  */
    found= 1;
    while( found )
	{
	int			i;
	const DocumentList *	dl;
	int			listID= rand();

	found= 0;

	dl= dlt->dltLists;
	for ( i= 0; i < dlt->dltListCount; dl++, i++ )
	    {
	    if  ( dl->dlListID == listID )
		{ found= 1; break; }
	    }

	if  ( ! found )
	    { dlTo->dlListID= listID;	}
	}

    /*  2  */
    found= 1;
    while( found )
	{
	int			i;
	const DocumentList *	dl;
	int			templateID= rand();

	found= 0;

	dl= dlt->dltLists;
	for ( i= 0; i < dlt->dltListCount; dl++, i++ )
	    {
	    if  ( dl->dlListTemplateID == templateID )
		{ found= 1; break; }
	    }

	if  ( ! found )
	    { dlTo->dlListTemplateID= templateID;	}
	}

    /*  5  */
    dlTo->dlListHybrid= 1;
    dlTo->dlRestartPerSect= 0;
    dlTo->dlLevelCount= DLmaxLEVELS;

    for ( level= 0; level < DLmaxLEVELS; level++ )
	{
	int	levelTemplateID= -1;

	if  ( dlTo->dlListHybrid )
	    { levelTemplateID= docFindFreeLevelTemplateId( dlt );	}

	if  ( docDefaultListLevel( dlTo->dlLevels+ level,
					level, deftab, levelTemplateID,
					taSetMask, taSet ) )
	    { LDEB(level); return -1;	}
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Insert a fresh list into the document and a list override that	*/
/*  refers to it.							*/
/*									*/
/************************************************************************/

int docNewList(			int *			pLs,
				int			lsExample,
				BufferDocument *	bd,
				const PropertyMask *	taSetMask,
				const TextAttribute *	taSet )
    {
    DocumentProperties *	dp= &(bd->bdProperties);
    DocumentListTable *		dlt= &(dp->dpListTable);
    ListOverrideTable *		lot= &(dp->dpListOverrideTable);
    int				ls= lot->lotOverrideCount;

    DocumentList *		dl;
    ListOverride *		lo;

    const int * const		fontMap= (const int *)0;
    const int * const		colorMap= (const int *)0;

    const DocumentList *	dlExample= (const DocumentList *)0;

    if  ( lsExample > 0 )
	{
	const ListOverride *	loExample= lot->lotOverrides+ lsExample;

	dlExample= dlt->dltLists+ loExample->loListIndex;
	}

    if  ( ls == 0 )
	{ ls= 1;	}

    if  ( docDocumentListTableAddList( dlt, dlExample, fontMap, colorMap ) )
	{ LDEB(dlt->dltListCount); return -1;	}

    dl= dlt->dltLists+ (dlt->dltListCount- 1);

    if  ( ! dlExample )
	{
	if  ( docDefaultList( dl, dlt, dp->dpTabIntervalTwips,
							taSetMask, taSet ) )
	    { LDEB(1); return -1;	}
	}

    if  ( docListOverrideTableAddOverride( lot,
			    (const ListOverride *)0, ls, fontMap, colorMap ) )
	{ LDEB(lot->lotOverrideCount); return -1;	}

    lo= lot->lotOverrides+ (lot->lotOverrideCount- 1);
    lo->loListID= dl->dlListID;
    lo->loListIndex= dlt->dltListCount- 1;

    *pLs= ls;
    return 0;
    }
