/************************************************************************/
/*									*/
/*  Buffer: Manipulation of item tree.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>

#   include	"docBuf.h"
#   include	"docEdit.h"

#   define	VALIDATE_TREE	0

/************************************************************************/
/*									*/
/*  The current selection consisted of several paragraphs. An edit	*/
/*  operation was executed on the first one.. The rest is to be		*/
/*  deleted.								*/
/*									*/
/************************************************************************/

void docDeleteEmptyParents(	EditOperation *		eo,
				int *			pSectsDeleted,
				BufferItem *		bi )
    {
    int			sectionsDeleted= 0;

    while( bi && bi->biChildCount == 0 )
	{
	int		numberInParent= bi->biNumberInParent;
	BufferItem *	parent= bi->biParent;

	if  ( ! parent )
	    { LXDEB(bi->biNumberInParent,bi->biParent); break;	}

	if  ( bi->biLevel == DOClevSECT )
	    { sectionsDeleted++;	}

	docDeleteItem( eo->eoBd, eo->eoEi, bi );

	if  ( parent				&&
	      docIsRowItem( parent )		)
	    {
	    if  ( docDeleteColumnsFromRow( &(parent->biRowProperties),
							numberInParent, 1 ) )
		{ LDEB(numberInParent);	}
	    }

	bi= parent;
	if  ( ! bi )
	    { break;	}

	if  ( docValidChildLevel( bi->biLevel, DOClevROW )	&&
	      bi->biChildCount > 0				)
	    { docDelimitTables( bi );	}
	}

    *pSectsDeleted= sectionsDeleted;
    return;
    }

int docRemoveSelectionTail(	EditOperation *			eo )
    {
    BufferItem *	lastParaBi;
    int			paraShift= 0;
    int			sectShift= 0;

    int			firstDeleted= -1;
    int			parentCount= 0;
    int			mergeTail= 0;

    lastParaBi= eo->eoLastDp.dpBi;

    for (;;)
	{
	BufferItem *	parent= lastParaBi->biParent;
	BufferItem *	prevParaBi= docPrevParagraph( lastParaBi );

	int		sectionsDeleted= 0;
	int		firstParaDeleted= -1;
	int		paragraphsDeleted= 0;

	int		from;
	int		count;

	while( prevParaBi != eo->eoTailDp.dpBi			&&
	       prevParaBi->biParent == lastParaBi->biParent	)
	    { prevParaBi= docPrevParagraph( prevParaBi );	}

	if  ( prevParaBi->biParent == parent )
	    { from= prevParaBi->biNumberInParent+ 1;	}
	else{
	    from= 0;

	    if  ( parentCount == 0					&&
		  lastParaBi->biNumberInParent < parent->biChildCount	)
		{ mergeTail= 1;	}
	    }

	count= lastParaBi->biNumberInParent- from+ 1;

	parentCount++;
	docEditDeleteItems( eo, &sectionsDeleted,
					&firstParaDeleted, &paragraphsDeleted,
					parent, from, count );

	if  ( docIsRowItem( parent ) )
	    {
	    if  ( docDeleteColumnsFromRow( &(parent->biRowProperties),
								from, count ) )
		{ LLDEB(from,count);	}
	    }

	sectShift -= sectionsDeleted;
	paraShift -= paragraphsDeleted;
	if  ( firstParaDeleted >= 0 )
	    {
	    if  ( firstDeleted < 0 || firstDeleted > firstParaDeleted )
		{ firstDeleted= firstParaDeleted;	}
	    }

	if  ( parent->biChildCount > 0 )
	    { docEditIncludeItemInReformatRange( eo, parent );	}

	sectionsDeleted= 0;
	docDeleteEmptyParents( eo, &sectionsDeleted, parent );

	sectShift -= sectionsDeleted;

	if  ( prevParaBi == eo->eoTailDp.dpBi )
	    { break;	}

	lastParaBi= prevParaBi;
	if  ( ! lastParaBi )
	    { XDEB(lastParaBi); break;	}
	}

    if  ( mergeTail )
	{
	lastParaBi= docNextParagraph( eo->eoTailDp.dpBi );
	if  ( lastParaBi )
	    {
	    int			sectionsDeleted;
	    BufferItem *	lastParent;

	    lastParent= lastParaBi->biParent;

	    if  ( docMergeGroupItems( eo->eoTailDp.dpBi->biParent,
							    lastParent ) )
		{ LDEB(mergeTail); return -1;	}

	    sectionsDeleted= 0;
	    docDeleteEmptyParents( eo, &sectionsDeleted, lastParent );
	    sectShift -= sectionsDeleted;
	    }
	}

    if  ( sectShift != 0 )
	{
	const int	paraNr= firstDeleted+ 1;
	const int	stroffFrom= 0;
	const int	stroffShift= 0;
	const int	paraShiftX= 0;

	eo->eoSectionsDeleted -= sectShift;

	docEditShiftReferences( eo, &(eo->eoSelectionScope),
				    paraNr, stroffFrom,
				    sectShift, paraShiftX, stroffShift );
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Delete some buffer items but first close the objects in them.	*/
/*									*/
/*  1)  Preliminary administration for shifting the bottom of the range	*/
/*	of paragraphs that are to be reformatted.			*/
/*  2)  Include the whole of the parent in the range of items to be	*/
/*	reformatted.							*/
/*									*/
/************************************************************************/

void docEditDeleteItems(	EditOperation *		eo,
				int *			pSectionsDeleted,
				int *			pFirstParaDeleted,
				int *			pParagraphsDeleted,
				BufferItem *		parentBi,
				int			first,
				int			count )
    {
    int		i;

    int		firstParaDeleted= -1;
    int		bulletsDeleted= 0;
    int		sectionsDeleted= 0;
    int		paragraphsDeleted= 0;
    int		lastStroff= 0;

    if  ( count == 0 )
	{ LDEB(count);	}

    if  ( count > 0 )
	{
	DocumentPosition	dp;

	/*  1  */
	if  ( docFirstPosition( &dp, parentBi->biChildren[first] ) )
	    { LDEB(1);							}
	else{ firstParaDeleted= docNumberOfParagraph( dp.dpBi );	}

	/*  1  */
	if  ( docLastPosition( &dp, parentBi->biChildren[first+count-1] ) )
	    { LDEB(1);							}
	else{ lastStroff= docParaStrlen( dp.dpBi );			}
	}

    for ( i= first+ count- 1; i >= first; i-- )
	{
	docCleanItemObjects( &bulletsDeleted, &paragraphsDeleted,
				eo->eoEi, eo->eoBd, parentBi->biChildren[i],
				eo->eoCloseObject );

	if  ( parentBi->biChildren[i]->biLevel == DOClevSECT )
	    { eo->eoSectionsDeleted++;	}
	}

    docDeleteItems( eo->eoBd, eo->eoEi, parentBi, first, count );

    if  ( parentBi->biLevel == DOClevBODY )
	{ sectionsDeleted= count;	}

    if  ( count > 0 )
	{
	const int		sectShift= -sectionsDeleted;
	const int		stroffShift= 0;

	if  ( firstParaDeleted < 0 )
	    { LDEB(firstParaDeleted);	}
	else{
	    docEditAvoidDeletedParagraphs( eo, &(eo->eoSelectionScope),
		    firstParaDeleted, firstParaDeleted+ paragraphsDeleted );

	    docEditShiftReferences( eo, &(eo->eoSelectionScope),
			    firstParaDeleted+ paragraphsDeleted-1 , lastStroff,
			    sectShift, -paragraphsDeleted, stroffShift );
	    }

	/*  Must be done by caller!
	docEditIncludeItemInReformatRange( eo, parentBi );
	*/
	}

    if  ( first == 0					&&
	  ( parentBi->biLevel == DOClevCELL	||
	    parentBi->biLevel == DOClevROW	)	)
	{
	DocumentPosition	dp;

	if  ( ! docFirstPosition( &dp, parentBi )	&&
	      dp.dpBi->biNumberInParent == 0		)
	    { docEditAdaptRowPropertiesToFirstChild( eo, dp.dpBi ); }
	}

    eo->eoBulletsChanged += bulletsDeleted;

    *pSectionsDeleted= sectionsDeleted;
    *pFirstParaDeleted= firstParaDeleted;
    *pParagraphsDeleted= paragraphsDeleted;
    return;
    }

/************************************************************************/
/*									*/
/*  Make sure that a Section contains an empty paragraph.		*/
/*									*/
/************************************************************************/

int docSectionParagraph( EditOperation *		eo,
			BufferItem **			pParaBi,
			BufferItem *			sectBi,
			int				sectShift,
			const ParagraphProperties *	pp,
			int				textAttributeNumber )
    {
    BufferDocument *	bd= eo->eoBd;
    BufferItem *	paraBi;

    paraBi= docInsertEmptyParagraph( bd, sectBi, textAttributeNumber );
    if  ( ! paraBi )
	{ XDEB(paraBi); return -1;	}

    if  ( pp )
	{
	PropertyMask		ppChgMask;
	PropertyMask		ppUpdMask;

	utilPropMaskClear( &ppChgMask );

	utilPropMaskClear( &ppUpdMask );
	utilPropMaskFill( &ppUpdMask, PPprop_FULL_COUNT );
	PROPmaskUNSET( &ppUpdMask, PPpropTABLE_NESTING );

	if  ( docEditUpdParaProperties( eo, &ppChgMask, paraBi,
				    &ppUpdMask, pp,
				    (const DocumentAttributeMap *)0 ) )
	    { LDEB(1);	}
	}

    {
    int			paraNr= docNumberOfParagraph( paraBi );
    const int		paraShift= 1;
    const int		stroffFrom= 0;
    const int		stroffShift= 0;

    docEditShiftReferences( eo, &(sectBi->biSectSelectionScope),
				    paraNr, stroffFrom,
				    sectShift, paraShift, stroffShift );
    }

    *pParaBi= paraBi; return 0;
    }

/************************************************************************/
/*									*/
/*  Roll the children of a group item.					*/
/*									*/
/************************************************************************/

int docRollItemChildren(	EditOperation *		eo,
				BufferItem *		parentBi,
				int			from,
				int			upto,
				int			by )
    {
    int				rval= 0;
    int				del0= upto;
    int				del1= upto;

    DocumentCopyJob		dcj;

    DocumentSelection		dsClean;

    docInitDocumentCopyJob( &dcj );

#   if VALIDATE_TREE
    if  ( docCheckItem( parentBi ) )
	{ LDEB(2); docListItem( 0, parentBi ); abort(); }
#   endif

    if  ( docSet1DocumentCopyJob( &dcj, eo ) )
	{ LDEB(1); rval= -1; goto ready;	}
    dcj.dcjCopyFields= 1;

    if  ( by > 0 )
	{
	int	i;

	for ( i= 0; i < by; i++ )
	    {
	    if  ( ! docCopyItem( &dcj, parentBi, upto+ i,
					    parentBi->biChildren[from+ i] ) )
		{ LDEB(upto+ i); rval= -1; goto ready;	}
	    }

	del0= from;
	del1= from+ by- 1;
	}

    if  ( by < 0 )
	{
	int	i;

	for ( i= 0; i < -by; i++ )
	    {
	    if  ( ! docCopyItem( &dcj, parentBi, from,
					    parentBi->biChildren[upto- 1] ) )
		{ LDEB(from); rval= -1; goto ready;	}
	    }

	del0= upto;
	del1= upto- by- 1;
	}

    if  ( docFirstPosition( &(dsClean.dsHead), parentBi->biChildren[del0] ) )
	{ LDEB(del0); rval= -1; goto ready;	}
    if  ( docLastPosition( &(dsClean.dsTail), parentBi->biChildren[del1] ) )
	{ LDEB(del1); rval= -1; goto ready;	}

    if  ( docEditDeleteFieldsForBlockDelete( eo, &dsClean ) )
	{ LLDEB(del0,del1); rval= -1; goto ready;	}

    {
    int		sectionsDeleted= 0;
    int		firstParaDeleted= -1;
    int		paragraphsDeleted= 0;

    docEditDeleteItems( eo, &sectionsDeleted,
				&firstParaDeleted, &paragraphsDeleted,
				parentBi, del0, del1- del0+ 1 );
    }

#   if VALIDATE_TREE
    if  ( docCheckItem( parentBi ) )
	{ LDEB(2); docListItem( 0, parentBi ); abort(); }
#   endif

  ready:

    docCleanDocumentCopyJob( &dcj );

    return rval;
    }

/************************************************************************/
/*									*/
/*  Insert a section before the current paragraph.			*/
/*									*/
/************************************************************************/

int docEditInsertSection(	DocumentPosition *	dpNew,
				EditOperation *		eo )
    {
    BufferItem *	insBi;
    BufferItem *	aftBi;

    BufferItem *	oldParaBi= eo->eoTailDp.dpBi;
    int			n= oldParaBi->biNumberInParent;

    const int		sectShift= 1;

    docInvalidateParagraphLayout( oldParaBi );

    if  ( docSplitGroupItem( eo->eoBd, &insBi, &aftBi, oldParaBi->biParent,
							    n, DOClevSECT ) )
	{ LDEB(1); return -1;	}

    if  ( insBi->biParent )
	{ docEditIncludeItemInReformatRange( eo, insBi->biParent );	}
    if  ( aftBi->biParent )
	{ docEditIncludeItemInReformatRange( eo, aftBi->biParent );	}

    eo->eoSectionsAdded += sectShift;
    {
    const int	paraNr= docNumberOfParagraph( oldParaBi )+ 1;
    const int	stroffFrom= 0;
    const int	paraShift= 0;
    const int	stroffShift= 0;

    docEditShiftReferences( eo, &(eo->eoSelectionScope),
				paraNr, stroffFrom,
				sectShift, paraShift, stroffShift );
    }

    if  ( docFirstPosition( dpNew, insBi ) )
	{
	BufferItem *	newParaBi;
	int		textAttributeNumber;

	textAttributeNumber= oldParaBi->biParaParticules[0].tpTextAttrNr;

	if  ( docSectionParagraph( eo, &newParaBi, insBi, sectShift,
						&(oldParaBi->biParaProperties),
						textAttributeNumber ) )
	    { LDEB(1); return -1;	}
	}

    if  ( docFirstPosition( dpNew, aftBi ) )
	{ LDEB(1); return -1;	}

    if  ( aftBi->biParent )
	{ docEditIncludeItemInReformatRange( eo, aftBi->biParent );	}
    else{ XDEB(aftBi->biParent);					}

    return 0;
    }

