/************************************************************************/
/*									*/
/*  A list of shapes.							*/
/*									*/
/************************************************************************/

#   ifndef DOC_DOCUMENT_SHAPE_LIST_H
#   define DOC_DOCUMENT_SHAPE_LIST_H

#   include	"docShape.h"
#   include	"utilPagedList.h"

typedef struct DrawingShapeList
    {
    PagedList		dslPagedList;
    } DrawingShapeList;

extern DrawingShape * docGetShapeByNumber(
					const DrawingShapeList *	dsl,
					int				n );

extern void docDeleteShapeFromList(	DrawingShapeList *		dsl,
					DrawingShape *			ds );

extern void docCleanShapeList(		DrawingShapeList *	dsl );
extern void docInitShapeList(		DrawingShapeList *	dsl );

extern DrawingShape * docClaimDrawingShape(
					DrawingShapeList *	dsl );

DrawingShape * docClaimShapeInParent(	DrawingShapeList *	dsl,
					DrawingShape *		parent,
					int			n,
					int			kind );

#   endif /*  DOC_DOCUMENT_SHAPE_LIST_H  */
