/************************************************************************/
/*									*/
/*  Administrative routines about selections.				*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Initialise Document Selection.					*/
/*									*/
/************************************************************************/

void docInitDocumentSelection(	DocumentSelection *	ds )
    {
    docInitSelectionScope( &(ds->dsSelectionScope) );

    docInitDocumentPosition( &(ds->dsHead) );
    docInitDocumentPosition( &(ds->dsTail) );
    docInitDocumentPosition( &(ds->dsAnchor) );

    ds->dsCol0= -1;
    ds->dsCol1= -1;

    ds->dsDirection= 0;

    return;
    }

void docSetIBarSelection(	DocumentSelection *		ds,
				const DocumentPosition *	dp )
    {
    docSetSelectionScope( ds, dp->dpBi );

    ds->dsHead= *dp;
    ds->dsTail= *dp;
    ds->dsAnchor= *dp;

    ds->dsCol0= -1;
    ds->dsCol1= -1;
    ds->dsDirection= 0;

    return;
    }

void docSetRangeSelection(	DocumentSelection *		ds,
				const DocumentPosition *	dpFrom,
				const DocumentPosition *	dpTo,
				int				direction,
				int				col0,
				int				col1 )
    {
    docInitDocumentSelection( ds );

    docSetSelectionScope( ds, dpFrom->dpBi );

    ds->dsHead= *dpFrom;
    ds->dsTail= *dpTo;
    ds->dsDirection= direction;

    ds->dsCol0= col0;
    ds->dsCol1= col1;
    
    if  ( direction >= 0 )
	{ ds->dsAnchor= *dpFrom;	}
    else{ ds->dsAnchor= *dpTo;		}

    return;
    }

int docIsIBarSelection( const DocumentSelection *		ds )
    {
    if  ( ! ds->dsHead.dpBi )
	{ return 0;	}

    if  ( ds->dsHead.dpBi != ds->dsTail.dpBi )
	{ return 0;	}

    if  ( ds->dsHead.dpStroff != ds->dsTail.dpStroff )
	{ return 0;	}

    return 1;
    }

int docIsParaSelection( const DocumentSelection *		ds )
    {
    if  ( ! ds->dsHead.dpBi )
	{ return 0;	}

    if  ( ds->dsHead.dpBi != ds->dsTail.dpBi )
	{ return 0;	}

    return 1;
    }

/************************************************************************/
/*									*/
/*  Reduce a selection to one paragraph.				*/
/*									*/
/************************************************************************/

void docConstrainSelectionToOneParagraph( int *			pHeadMoved,
					int *			pTailMoved,
					DocumentSelection *	ds )
    {
    int		lenBegin;
    int		lenEnd;

    if  ( docIsParaSelection( ds ) )
	{ return;	}

    lenBegin= docParaStrlen( ds->dsHead.dpBi )- ds->dsHead.dpStroff;
    lenEnd= ds->dsTail.dpStroff;

    if  ( lenEnd > lenBegin )
	{
	if  ( docFirstPosition( &(ds->dsHead), ds->dsTail.dpBi ) )
	    { LDEB(1);	}
	ds->dsCol0= ds->dsCol1;

	if  ( ds->dsAnchor.dpBi != ds->dsHead.dpBi )
	    { ds->dsAnchor= ds->dsHead;	}

	*pHeadMoved= 1; *pTailMoved= 0;
	return;
	}
    else{
	if  ( docLastPosition( &(ds->dsTail), ds->dsHead.dpBi ) )
	    { LDEB(1);	}
	ds->dsCol1= ds->dsCol0;

	if  ( ds->dsAnchor.dpBi != ds->dsTail.dpBi )
	    { ds->dsAnchor= ds->dsTail;	}

	*pHeadMoved= 0; *pTailMoved= 1;
	return;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Translate the result of a search in a paragraph to a selection.	*/
/*									*/
/************************************************************************/

void docSetParaSelection(	DocumentSelection *	ds,
				BufferItem *		paraBi,
				int			direction,
				int			stroff,
				int			length )
    {
    if  ( paraBi->biLevel != DOClevPARA )
	{ LDEB(paraBi->biLevel);	}

    docSetDocumentPosition( &(ds->dsHead), paraBi, stroff );
    docSetDocumentPosition( &(ds->dsTail), paraBi, stroff+ length );

    ds->dsDirection= direction;

    ds->dsCol0= ds->dsCol1= -1;

    if  ( direction >= 0 )
	{ ds->dsAnchor= ds->dsHead;	}
    else{ ds->dsAnchor= ds->dsTail;	}

    docSetSelectionScope( ds, paraBi );

    return;
    }

