/************************************************************************/
/*									*/
/*  Fields: parts of the document that are calculated in stead of typed	*/
/*  by the user.							*/
/*									*/
/************************************************************************/

#   ifndef DOC_DOCUMENT_FIELD_H
#   define DOC_DOCUMENT_FIELD_H

#   include	<utilMemoryBuffer.h>
#   include	"docSelectionScope.h"
#   include	"docEditRange.h"

typedef enum FieldKind
    {
    DOCfkUNKNOWN= 0,
    DOCfkHYPERLINK,
    DOCfkXE,
    DOCfkTC,
    DOCfkTCN,
    DOCfkBOOKMARK,
    DOCfkSECTION,
    DOCfkSECTIONPAGES,
    DOCfkPAGE,
    DOCfkPAGEREF,
    DOCfkNUMPAGES,
    DOCfkREF,

    DOCfkCREATEDATE,
    DOCfkSAVEDATE,
    DOCfkPRINTDATE,
    DOCfkDATE,
    DOCfkTIME,

    DOCfkAUTHOR,
    DOCfkCOMMENTS,
    DOCfkDOCCOMM,
    DOCfkKEYWORDS,
    DOCfkSUBJECT,
    DOCfkTITLE,
    DOCfkFILENAME,

    DOCfkMERGEFIELD,
    DOCfkFORMTEXT,
    DOCfkFORMCHECKBOX,

    DOCfkSYMBOL,
    DOCfkCHFTN,
    DOCfkCHATN,

    DOCfkLISTTEXT,

    DOCfkINCLUDEPICTURE,

    DOCfkTOC,

    DOCfk_COUNT
    } FieldKind;

struct DocumentField;

typedef struct ChildFields
    {
    struct DocumentField **	cfChildren;
    int				cfChildCount;
    } ChildFields;

typedef struct DocumentField
    {
    FieldKind			dfKind;
    MemoryBuffer		dfData;
    MemoryBuffer		dfInstructions;
    SelectionScope		dfSelectionScope;
    EditPosition		dfHeadPosition;
    EditPosition		dfTailPosition;
				/*
				 * If a field spans part of a table,
				 * these can be used to give the first/last 
				 * column covered by the field. Is only 
				 * used for bookmarks.
				 */
    short			dfFirstColumn;
    short			dfLastColumn;
				/*
				 * Flags that reflect the status of the 
				 * field content.
				 */
    unsigned char		dfDirty;
    unsigned char		dfEdited;
    unsigned char		dfLocked;
    unsigned char		dfPrivate;
					/********************************/
					/*  Fields have a hierarchy.	*/
					/********************************/
    ChildFields			dfChildFields;
    struct DocumentField *	dfParent;
    int				dfNumberInParent;
				/*
				 * The index of the field.
				 * ABUSED to keep a linked list of free fields
				 */
    int				dfFieldNumber;
				/*
				 *  Reference to the note of a
				 *  chftn field.
				 */
    int				dfNoteIndex;
				/*
				 * Make it possible to refer
				 * the page number of a field.
				 */
    int				dfPage;
    } DocumentField;

typedef enum FieldProperty
    {
    FPpropFIRST_COLUMN= 0,
    FPpropLAST_COLUMN,
    FPpropDIRTY,
    FPpropEDITED,
    FPpropLOCKED,
    FPpropPRIVATE,

    FPpropFLDRSLT,
    FPpropFLDINST,

    FPprop_COUNT
    } FieldProperty;

# define docGetBodySectNrOfField( df ) \
		((df)->dfSelectionScope.ssInExternalItem == DOCinBODY? \
		 (df)->dfSelectionScope.ssSectNr: \
		 (df)->dfSelectionScope.ssOwnerSectNr)

typedef struct FieldInstructionsComponent
    {
    int		ficOffset;
    int		ficSize;
    } FieldInstructionsComponent;

#   define	DOCmaxBOOKMARK	40

# define docEditPositionInField( df, ep ) \
	( docCompareEditPositions( &((df)->dfHeadPosition), (ep) ) <= 0 && \
	  docCompareEditPositions( &((df)->dfTailPosition), (ep) ) >= 0 )

/************************************************************************/
/*									*/
/*  Administrative routines.						*/
/*									*/
/************************************************************************/

extern DocumentField * docGetFirstField(const ChildFields *	rootFields );
extern DocumentField * docGetLastField(	const ChildFields *	rootFields );

extern DocumentField * docGetNextField(	const ChildFields *	rootFields,
					DocumentField *		df );

extern DocumentField * docGetPrevField(	const ChildFields *	rootFields,
					DocumentField *		df );

DocumentField * docGetFirstFieldOfSection(
					const ChildFields *	rootFields,
					int			sect );

extern DocumentField * docGetNextFieldInSection(
					const ChildFields *	rootFields,
					int			sect,
					DocumentField *		df );

extern int docFieldGetHyperlink(	const DocumentField *	df,
					const char **		pFileName,
					int *			pFileSize,
					const char **		pMarkName,
					int *			pMarkSize );

extern int docFieldGetBookmark(		const DocumentField *	df,
					const char **		pMarkName,
					int *			pMarkSize );

extern int docFieldMatchesBookmark(	const DocumentField *	df,
					const char *		markName,
					int			markSize );

extern int docFieldSetBookmark(		DocumentField *		df,
					const char *		mark,
					int			markSize );

extern int docFieldSetRef(		DocumentField *		df,
					const char *		mark,
					int			markSize );

extern int docFieldSetPageref(		DocumentField *		df,
					const char *		mark,
					int			markSize );

extern void docInitDocumentField(	DocumentField *		df );
extern void docInitChildFields(		ChildFields *		cf );
extern void docCleanChildFields(	ChildFields *		cf );

extern void docCleanDocumentField(	DocumentField *		df );

extern int docFieldSetHyperlink(	DocumentField *		df,
					const char *		fileName,
					int			fileSize,
					const char *		markName,
					int			markSize );

extern int docSetFieldInst(		DocumentField *		df,
					const char *		bytes,
					int			size );

extern int docAddToFieldInst(		DocumentField *		df,
					const char *		bytes,
					int			size );

extern int docAddToFieldData(		DocumentField *		df,
					const char *		bytes,
					int			size );

extern int docSplitFieldInstructions(	const MemoryBuffer *	mb,
				FieldInstructionsComponent *	fic,
				int				count );

extern int docFieldHasMergeformat(	const unsigned char *		bytes,
					FieldInstructionsComponent *	fic,
					int				n,
					int				comp );

extern void docAdaptBookmarkName(	int *			pLength,
					char *			mark );

extern int docFieldGetTc(		const DocumentField *	df,
					char *			pFlag,
					int *			pLevel,
					int *			pNumbered );

extern int docInsertChildField(		DocumentField *		parent,
					ChildFields *		cf,
					DocumentField *		df );

extern int docDeleteChildField(		ChildFields *		cf,
					DocumentField *		df );

extern DocumentField * docFindChildField( const ChildFields *	cf,
					const EditPosition *	ep,
					int			lastOne );

extern DocumentField * docFindTypedChildField(
					const ChildFields *	cf,
					const EditPosition *	ep,
					int			type );

extern void docSetFieldEnd(		DocumentField *		dfPa,
					const EditPosition *	epEnd );

extern int docAddChildToField(		DocumentField *		dfCh,
					DocumentField *		dfPa );

extern int docInsertFieldInTree(	ChildFields *		cf,
					DocumentField *		df );

extern DocumentField *	docFieldGetCommonParent(
					DocumentField *		dfLeft,
					DocumentField *		dfRight );

#   endif /*  DOC_DOCUMENT_FIELD_H  */
