/************************************************************************/
/*									*/
/*  Manage fields.							*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<limits.h>

#   include	<appDebugon.h>

#   include	"docDocumentField.h"

/************************************************************************/
/*									*/
/*  Manage fields.							*/
/*									*/
/************************************************************************/

void docCleanDocumentField(	DocumentField *		df )
    {
    utilCleanMemoryBuffer( &df->dfData );
    utilCleanMemoryBuffer( &df->dfInstructions );

    docCleanChildFields( &(df->dfChildFields) );

    return;
    }

/************************************************************************/
/*									*/
/*  Free a field: Only called when the field list is cleaned as a	*/
/*  whole.								*/
/*									*/
/************************************************************************/

void docInitChildFields(	ChildFields *	cf )
    {
    cf->cfChildren= (DocumentField **)0;
    cf->cfChildCount= 0;
    }

void docCleanChildFields(	ChildFields *	cf )
    {
    if  ( cf->cfChildren )
	{ free( cf->cfChildren );	}
    }

void docInitDocumentField(	DocumentField *	df )
    {
    df->dfKind= DOCfkUNKNOWN;

    utilInitMemoryBuffer( &df->dfData );
    utilInitMemoryBuffer( &df->dfInstructions );

    docInitSelectionScope( &(df->dfSelectionScope) );
    docInitEditPosition( &(df->dfHeadPosition) );
    docInitEditPosition( &(df->dfTailPosition) );

    df->dfFirstColumn= -1;
    df->dfLastColumn= -1;

    df->dfDirty= 0;
    df->dfEdited= 0;
    df->dfLocked= 0;
    df->dfPrivate= 0;

    docInitChildFields( &(df->dfChildFields) );
    df->dfParent= (DocumentField *)0;
    df->dfNumberInParent= 0;

    df->dfFieldNumber= -1;
    df->dfNoteIndex= -1;

    df->dfPage= -1;
    }

int docSetFieldInst(	DocumentField *		df,
			const char *		bytes,
			int			size )
    {
    return utilSetMemoryBuffer( &(df->dfInstructions),
					(const unsigned char *)bytes, size );
    }

int docAddToFieldInst(	DocumentField *		df,
			const char *		bytes,
			int			size )
    {
    return utilAddToMemoryBuffer( &(df->dfInstructions),
					(const unsigned char *)bytes, size );
    }

int docAddToFieldData(	DocumentField *		df,
			const char *		bytes,
			int			size )
    {
    return utilAddToMemoryBuffer( &(df->dfData),
					(const unsigned char *)bytes, size );
    }

/************************************************************************/
/*									*/
/*  Navigation over the field tree in document order.			*/
/*									*/
/************************************************************************/

DocumentField * docGetFirstField(	const ChildFields *	rootFields )
    { return docGetNextField( rootFields, (DocumentField *)0 );	}

DocumentField * docGetLastField(	const ChildFields *	rootFields )
    { return docGetPrevField( rootFields, (DocumentField *)0 );	}

DocumentField * docGetNextField(	const ChildFields *	rootFields,
					DocumentField *		df )
    {
    const ChildFields *	parentFields;

    if  ( ! df )
	{
	if  ( rootFields->cfChildCount == 0 )
	    { return (DocumentField *)0;	}
	else{ return rootFields->cfChildren[0];	}
	}

    if  ( df->dfChildFields.cfChildCount > 0 )
	{ return df->dfChildFields.cfChildren[0];	}

    while( df->dfParent )
	{
	parentFields= &(df->dfParent->dfChildFields);

	if  ( df->dfNumberInParent < parentFields->cfChildCount- 1 )
	    { return parentFields->cfChildren[df->dfNumberInParent+ 1];	}

	df= df->dfParent;
	}

    parentFields= rootFields;
    if  ( df->dfNumberInParent >= parentFields->cfChildCount- 1 )
	{ return (DocumentField *)0;					}
    else{ return parentFields->cfChildren[df->dfNumberInParent+ 1];	}
    }

DocumentField * docGetPrevField(	const ChildFields *	rootFields,
					DocumentField *		df )
    {
    const ChildFields *	parentFields;

    if  ( ! df )
	{
	if  ( rootFields->cfChildCount == 0 )
	    { return (DocumentField *)0;				}
	else{ df= rootFields->cfChildren[rootFields->cfChildCount- 1];	}
	}
    else{
	if  ( df->dfNumberInParent == 0 )
	    { return df->dfParent;	}

	if  ( df->dfParent )
	    { parentFields= &(df->dfParent->dfChildFields);		}
	else{ parentFields= rootFields;				}

	df= parentFields->cfChildren[df->dfNumberInParent- 1];
	}

    while( df->dfChildFields.cfChildCount > 0 )
	{ df= df->dfChildFields.cfChildren[df->dfChildFields.cfChildCount- 1]; }

    return df;
    }

/************************************************************************/
/*									*/
/*  Return the first field in a section.				*/
/*									*/
/*  NOTE: That fields do not span sections.				*/
/*									*/
/************************************************************************/

DocumentField * docGetFirstFieldOfSection(
					const ChildFields *	rootFields,
					int			sect )
    {
    int		pos;

    for ( pos= 0; pos < rootFields->cfChildCount; pos++ )
	{
	DocumentField *	df= rootFields->cfChildren[pos];

	if  ( df->dfSelectionScope.ssSectNr == sect )
	    { return df;	}
	if  ( df->dfSelectionScope.ssSectNr >  sect )
	    { break;	}
	}

    return (DocumentField *)0;
    }

DocumentField * docGetNextFieldInSection(
					const ChildFields *	rootFields,
					int			sect,
					DocumentField *		df )
    {
    df= docGetNextField( rootFields, df );

    if  ( ! df )
	{ return df;	}

    if  ( df && df->dfSelectionScope.ssSectNr == sect )
	{ return df;	}

    return (DocumentField *)0;
    }
