/************************************************************************/
/*									*/
/*  Document Editing: Copying over (part of) a document to the same	*/
/*  document or another one.						*/
/*									*/
/************************************************************************/

#   ifndef		DOC_DOCUMENT_COPY_JOB_H
#   define		DOC_DOCUMENT_COPY_JOB_H

#   include		"docBuf.h"
#   include		"docEditOperation.h"
#   include		"docDocumentAttributeMap.h"

/************************************************************************/
/*									*/
/*  For copying information from one location to another. Possibly	*/
/*  between different documents.					*/
/*									*/
/************************************************************************/

typedef struct FieldCopyStackLevel
    {
    DocumentField *			fcslField;
    struct FieldCopyStackLevel *	fcslPrev;
    } FieldCopyStackLevel;

typedef struct DocumentCopyJob
    {
    EditOperation *		dcjEditOperation;
    SelectionScope		dcjSelectionScope;
    DocumentTree *		dcjEiTo;
    BufferDocument *		dcjBdFrom;
    int				dcjInExternalItem;

    int				dcjCopyFields;
    int *			dcjFieldMap;
    FieldCopyStackLevel *	dcjFieldStack;

    DocumentAttributeMap	dcjAttributeMap;
    int				dcjForceAttributeTo;

    char *			dcjRefFileName;
    int				dcjRefFileSize;

    int				dcjCurrentTextAttributeNumberFrom;
    int				dcjCurrentTextAttributeNumberTo;

    int				dcjNotesCopied;
    int				dcjBulletsCopied;
    } DocumentCopyJob;

/************************************************************************/
/*									*/
/*  Routine Declarations.						*/
/*									*/
/************************************************************************/

extern int docMapTextAttributeNumber(
				DocumentCopyJob *	dcj,
				int			attributeNumberFrom );

extern void docInitDocumentCopyJob(	DocumentCopyJob *	dcj );
extern void docCleanDocumentCopyJob(	DocumentCopyJob *	dcj );

extern int docSet1DocumentCopyJob(	DocumentCopyJob *	dcj,
					EditOperation *		eo );

extern int docSet2DocumentCopyJob(
				DocumentCopyJob *		dcj,
				EditOperation *			eo,
				BufferDocument *		bdFrom,
				const char *			refFileName );

extern int docPushFieldOnCopyStack(	DocumentCopyJob *	dcj,
					DocumentField *		df );

extern void docMapTextAttribute(	TextAttribute *		taTo,
					const TextAttribute *	taFrom,
					const DocumentCopyJob *	dcj );

#   endif	/*	DOC_DOCUMENT_COPY_JOB_H	*/
