/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"docBufConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>
#   include	<charnames.h>

#   include	<appUnit.h>
#   include	"docBuf.h"
#   include	"docEvalField.h"

/************************************************************************/
/*									*/
/*  Evaluate fields to document properties.				*/
/*									*/
/************************************************************************/

#   define	FIC_COUNT	15

/************************************************************************/
/*									*/
/*  Return the value of one of the document dates.			*/
/*									*/
/************************************************************************/

int docCalculateDocDateFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf )
    {
    FieldInstructionsComponent	fic[FIC_COUNT];
    int				n;
    int				comp;
    unsigned char *		bytes= df->dfInstructions.mbBytes;

    const DocumentProperties *	dp= &(rf->rfBd->bdProperties);
    const struct tm *		tm;

    int				mergeFormat= 0;
    int				pictureComp= -1;
    const char *		defaultFormat= (const char *)0;

    time_t			t;
    struct tm			tmNow;

    n= docSplitFieldInstructions( &(df->dfInstructions), fic, FIC_COUNT );
    if  ( n < 1 )
	{ SLDEB((char *)bytes,n); return -1;	}

    for ( comp= 1; comp < n; comp++ )
	{
	if  ( docFieldHasMergeformat( bytes, fic, n, comp ) )
	    { comp++; continue;	}

	if  ( comp < n-1					&&
	      fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\@", 2 )	)
	    { pictureComp= comp+ 1; comp++; continue; }

	LSDEB(comp,(char *)bytes+ fic[comp].ficOffset);
	}

    switch( df->dfKind )
	{
	case DOCfkCREATEDATE:
	    tm= &(dp->dpCreatim);
	    defaultFormat= "%c";
	    break;
	case DOCfkSAVEDATE:
	    tm= &(dp->dpRevtim);
	    defaultFormat= "%c";
	    break;
	case DOCfkPRINTDATE:
	    tm= &(dp->dpPrintim);
	    defaultFormat= "%c";
	    break;

	case DOCfkDATE:
	    t= time( (time_t *)0 );
	    tmNow= *localtime( &t );
	    tm= &tmNow;
	    defaultFormat= "%x";
	    break;
	case DOCfkTIME:
	    t= time( (time_t *)0 );
	    tmNow= *localtime( &t );
	    tm= &tmNow;
	    defaultFormat= "%X";
	    break;

	default:
	    LDEB(df->dfKind); *pCalculated= 0; return 0;
	}

    if  ( tm->tm_mday == 0 )
	{ /*LDEB(tm->tm_mday);*/ *pCalculated= 0; return 0;	}

    if  ( pictureComp >= 0 )
	{
	char		target[50+1];
	char		scratch[50+1];

	if  ( fic[pictureComp].ficSize > sizeof(scratch)- 1 )
	    {
	    LLDEB(fic[pictureComp].ficSize,sizeof(scratch));
	    *pCalculated= 0; return 0;
	    }
	memcpy( scratch, bytes+ fic[pictureComp].ficOffset,
						    fic[pictureComp].ficSize );
	scratch[fic[pictureComp].ficSize]= '\0';

	appWordFormatDate( target, sizeof(target)-1, tm, scratch );
	utilAddToMemoryBuffer( mbResult,
				(unsigned char *)target, strlen( target ) );
	*pCalculated= 1; return 0;
	}

    if  ( mergeFormat )
	{
	char		target[50+1];

	if  ( strftime( (char *)target, sizeof(target)-1,
						    defaultFormat, tm ) < 1 )
	    { *pCalculated= 0; return 0;	}

	utilAddToMemoryBuffer( mbResult,
				(unsigned char *)target, strlen( target ) );
	*pCalculated= 1; return 0;
	}


    *pCalculated= 0; return 0;
    }

/************************************************************************/
/*									*/
/*  Return the value of one of the document properties.			*/
/*									*/
/************************************************************************/

int docCalculateDocStringFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf )
    {
    const DocumentProperties *	dp= &(rf->rfBd->bdProperties);
    const char *		val;
    int				len;
    
    switch( df->dfKind )
	{
	case DOCfkAUTHOR:	val= dp->dpAuthor;	break;
	case DOCfkCOMMENTS:	val= dp->dpDoccomm;	break;
	case DOCfkDOCCOMM:	val= dp->dpDoccomm;	break;
	case DOCfkKEYWORDS:	val= dp->dpKeywords;	break;
	case DOCfkSUBJECT:	val= dp->dpSubject;	break;
	case DOCfkTITLE:	val= dp->dpTitle;	break;
	case DOCfkFILENAME:	val= dp->dpFilename;	break;

	default:
	    LDEB(df->dfKind); *pCalculated= 0; return 0;
	}

    if  ( ! val )
	{ val= "";	}
    len= strlen( val );

    if  ( utilAddToMemoryBuffer( mbResult, (unsigned char *)val, len ) )
	{ LDEB(len); return -1;	}

    *pCalculated= 1; return 0;
    }

/************************************************************************/
/*									*/
/*  Return the file name of the document.				*/
/*									*/
/*  The file name on the document proprties is assumed to be a full	*/
/*  absolute name. (From "/")						*/
/*									*/
/************************************************************************/

int docCalculateFilenameFieldString(
				int *				pCalculated,
				MemoryBuffer *			mbResult,
				const BufferItem *		paraBi,
				int				part,
				int				partCount,
				const DocumentField *		df,
				const RecalculateFields *	rf )
    {
    FieldInstructionsComponent	fic[FIC_COUNT];
    int				n;
    unsigned char *		bytes= df->dfInstructions.mbBytes;

    const DocumentProperties *	dp= &(rf->rfBd->bdProperties);

    int				fullPath= 0;
    const char *		file= dp->dpFilename;
    char *			relative= (char *)0;

    int				comp;

    n= docSplitFieldInstructions( &(df->dfInstructions), fic, FIC_COUNT );
    if  ( n < 1 )
	{ LDEB(n); return -1;	}

    for ( comp= 1; comp < n; comp++ )
	{
	if  ( docFieldHasMergeformat( bytes, fic, n, comp ) )
	    { comp++; continue;	}

	if  ( comp < n-1					&&
	      fic[comp].ficSize == 2				&&
	      ! memcmp( bytes+ fic[comp].ficOffset, "\\p", 2 )	)
	    { fullPath= 1; continue;	}

	LSDEB(comp,(char *)bytes+ fic[comp].ficOffset);
	}

    if  ( ! file )
	{ file= "";	}

    if  ( ! fullPath )
	{ relative= strrchr( (char *)file, '/' );	}

    if  ( fullPath || ! relative )
	{
	if  ( utilAddToMemoryBuffer( mbResult,
			    (unsigned char *)file, strlen( file ) ) )
	    { LDEB(1); return -1;	}
	}
    else{
	relative++;

	if  ( utilAddToMemoryBuffer( mbResult,
			    (unsigned char *)relative, strlen( relative ) ) )
	    { LDEB(1); return -1;	}
	}

    *pCalculated= 1;

    return 0;
    }

