#   include	"docBufConfig.h"

#   include	"docBuf.h"
#   include	<stdio.h>
#   include	<appDebugon.h>
#   include	<docFind.h>

static int docListObject( int n, void * vio, void * through )
    {
    InsertedObject *	io= (InsertedObject *)vio;
    const char *	kind= docObjectKindStr(io->ioKind);
    const char *	reskind= docObjectKindStr(io->ioResultKind);

    int			size= io->ioObjectData.mbSize;
    int			ressize= io->ioResultData.mbSize;

    LSSLLDEB(n,kind,reskind,size,ressize);

    if  ( size > 4 )
	{ size= 4;	}
    if  ( ressize > 4 )
	{ ressize= 4;	}

    if  ( size > 0 )
	{
	appDebug( "    OBJ BYTES: \"%.*s\"\n", size,
				(char *)io->ioObjectData.mbBytes );
	}

    if  ( ressize > 0 )
	{
	appDebug( "    RES BYTES: \"%.*s\"\n", ressize,
				(char *)io->ioResultData.mbBytes );
	}

    return 0;
    }

void docListObjects( BufferDocument * bd )
    {
    utilPagedListForAll( &(bd->bdObjectList), docListObject, (void *)0 );
    }

static void docListShape(	int				indent,
				const DrawingShape *		ds )
    {
    appDebug( "%*sSHAPE %4d\n", indent, "", ds->dsShapeNumber );

    if  ( ds->dsChildCount > 0 )
	{
	int		ch;

	appDebug( "%*s{\n", indent+ 4, "" );

	for ( ch= 0; ch < ds->dsChildCount; ch++ )
	    { docListShape( indent+ 4, ds->dsChildren[ch] ); }

	appDebug( "%*s}\n", indent+ 4, "" );
	}
    }

static int docListShapeX(	int				n,
				void *				vds,
				void *				through )
    {
    docListShape( 0, (const DrawingShape *)vds );
    return 0;
    }

void docListShapes(		BufferDocument *		bd )
    {
    DrawingShapeList *	dsl= &(bd->bdShapeList);
    PagedList *		pl= &(dsl->dslPagedList);

    utilPagedListForAll( pl, docListShapeX, (void *)0 );
    }

static int docFindParaObjects(	DocumentSelection *		ds,
				BufferItem *			paraBi,
				const BufferDocument *		bd,
				const DocumentPosition *	dpFrom,
				void *				through );

static void docListShapeObjects(	const DrawingShape *	dshp,
					const BufferDocument *	bd )
    {
    DocumentSelection		ds;

    if  ( docFirstPosition( &(ds.dsHead), dshp->dsDocumentTree.eiRoot ) )
	{ LDEB(1); return;	}

    docFindFindNextInTree( &ds, &(ds.dsHead), bd,
				docFindParaObjects, (void *)0 );
    }

static void docListParaObjects(	const BufferItem *	paraBi,
				const BufferDocument *	bd )
    {
    const TextParticule *	tp=  paraBi->biParaParticules;
    int				part;

    for ( part= 0; part < paraBi->biParaParticuleCount; tp++, part++ )
	{
	const InsertedObject *	io;

	if  ( tp->tpKind != DOCkindOBJECT )
	    { continue;	}

	io= docGetObject( bd, tp->tpObjectNumber );
	if  ( ! io )
	    { LXDEB(tp->tpObjectNumber,io); continue;	}

	switch( io->ioKind )
	    {
	    DrawingShape *	dshp;

	    case DOCokDRAWING_SHAPE:
		dshp= io->ioDrawingShape;

		appDebug( "%s - OBJECT %4d: %s %4d\n",
			docExternalKindStr( paraBi->biInExternalItem ),
			tp->tpObjectNumber, docObjectKindStr( io->ioKind ),
			dshp->dsShapeNumber );

		docListShape( 4, dshp );

		if  ( dshp->dsDocumentTree.eiRoot )
		    { docListShapeObjects( dshp, bd );	}
		break;

	    case DOCokOLEOBJECT:
		switch( io->ioResultKind )
		    {
		    case DOCokDRAWING_SHAPE:
			dshp= io->ioDrawingShape;

			appDebug( "%s - OBJECT %4d: %s -> %s %4d\n",
			    docExternalKindStr( paraBi->biInExternalItem ),
			    tp->tpObjectNumber,
			    docObjectKindStr( io->ioKind ),
			    docObjectKindStr( io->ioResultKind ),
			    dshp->dsShapeNumber );

			docListShape( 4, dshp );

			if  ( dshp->dsDocumentTree.eiRoot )
			    { docListShapeObjects( dshp, bd );	}
			break;

		    default:
			appDebug( "%s - OBJECT %4d: %s -> %s\n",
			    docExternalKindStr( paraBi->biInExternalItem ),
			    tp->tpObjectNumber,
			    docObjectKindStr( io->ioKind ),
			    docObjectKindStr( io->ioResultKind ) );
			break;
		    }
		break;

	    default:
		appDebug( "%s - OBJECT %4d: %s\n",
			docExternalKindStr( paraBi->biInExternalItem ),
			tp->tpObjectNumber, docObjectKindStr( io->ioKind ) );
		break;
	    }
	}

    return;
    }

static int docFindParaObjects(	DocumentSelection *		ds,
				BufferItem *			paraBi,
				const BufferDocument *		bd,
				const DocumentPosition *	dpFrom,
				void *				through )
    {
    docListParaObjects( paraBi, bd );
    return 1;
    }

void docListDocumentObjects(	BufferDocument *	bd )
    {
    DocumentSelection		ds;

    if  ( docFirstDocumentPosition( &(ds.dsHead), bd ) )
	{ LDEB(1); return;	}

    docFindFindNextInDocument( &ds, &(ds.dsHead), bd,
				docFindParaObjects, (void *)0 );
    return;
    }
